/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyRep;
import java.security.ProviderException;
import java.security.PublicKey;
import java.util.Objects;
import javax.crypto.spec.DHParameterSpec;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

final class DHPublicKey
implements PublicKey,
javax.crypto.interfaces.DHPublicKey,
Serializable {
    private static final long serialVersionUID = 7647557958927458271L;
    private BigInteger y;
    private byte[] key;
    private byte[] encodedKey;
    private final BigInteger p;
    private final BigInteger g;
    private int l;
    private int[] DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};

    DHPublicKey(BigInteger y, BigInteger p, BigInteger g) throws InvalidKeyException {
        this(y, p, g, 0);
    }

    DHPublicKey(BigInteger y, BigInteger p, BigInteger g, int l) {
        this.y = y;
        this.p = p;
        this.g = g;
        this.l = l;
        try {
            this.key = new DerValue(2, this.y.toByteArray()).toByteArray();
            this.encodedKey = this.getEncoded();
        }
        catch (IOException e) {
            throw new ProviderException("Cannot produce ASN.1 encoding", e);
        }
    }

    DHPublicKey(byte[] encodedKey) throws InvalidKeyException {
        ByteArrayInputStream inStream = new ByteArrayInputStream(encodedKey);
        try {
            DerValue derKeyVal = new DerValue(inStream);
            if (derKeyVal.tag != 48) {
                throw new InvalidKeyException("Invalid key format");
            }
            DerValue algid = derKeyVal.data.getDerValue();
            if (algid.tag != 48) {
                throw new InvalidKeyException("AlgId is not a SEQUENCE");
            }
            DerInputStream derInStream = algid.toDerInputStream();
            ObjectIdentifier oid = derInStream.getOID();
            if (oid == null) {
                throw new InvalidKeyException("Null OID");
            }
            if (derInStream.available() == 0) {
                throw new InvalidKeyException("Parameters missing");
            }
            DerValue params = derInStream.getDerValue();
            if (params.tag == 5) {
                throw new InvalidKeyException("Null parameters");
            }
            if (params.tag != 48) {
                throw new InvalidKeyException("Parameters not a SEQUENCE");
            }
            params.data.reset();
            this.p = params.data.getBigInteger();
            this.g = params.data.getBigInteger();
            if (params.data.available() != 0) {
                this.l = params.data.getInteger();
            }
            if (params.data.available() != 0) {
                throw new InvalidKeyException("Extra parameter data");
            }
            this.key = derKeyVal.data.getBitString();
            this.parseKeyBits();
            if (derKeyVal.data.available() != 0) {
                throw new InvalidKeyException("Excess key data");
            }
            this.encodedKey = (byte[])encodedKey.clone();
        }
        catch (IOException | NumberFormatException e) {
            throw new InvalidKeyException("Error parsing key encoding", e);
        }
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public synchronized byte[] getEncoded() {
        if (this.encodedKey == null) {
            try {
                DerOutputStream algid = new DerOutputStream();
                algid.putOID(new ObjectIdentifier(this.DH_data));
                DerOutputStream params = new DerOutputStream();
                params.putInteger(this.p);
                params.putInteger(this.g);
                if (this.l != 0) {
                    params.putInteger(this.l);
                }
                DerValue paramSequence = new DerValue(48, params.toByteArray());
                algid.putDerValue(paramSequence);
                DerOutputStream tmpDerKey = new DerOutputStream();
                tmpDerKey.write((byte)48, algid);
                tmpDerKey.putBitString(this.key);
                DerOutputStream derKey = new DerOutputStream();
                derKey.write((byte)48, tmpDerKey);
                this.encodedKey = derKey.toByteArray();
            }
            catch (IOException e) {
                return null;
            }
        }
        return (byte[])this.encodedKey.clone();
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    @Override
    public DHParameterSpec getParams() {
        if (this.l != 0) {
            return new DHParameterSpec(this.p, this.g, this.l);
        }
        return new DHParameterSpec(this.p, this.g);
    }

    public String toString() {
        String LINE_SEP = System.getProperty("line.separator");
        StringBuffer strbuf = new StringBuffer("SunJCE Diffie-Hellman Public Key:" + LINE_SEP + "y:" + LINE_SEP + Debug.toHexString(this.y) + LINE_SEP + "p:" + LINE_SEP + Debug.toHexString(this.p) + LINE_SEP + "g:" + LINE_SEP + Debug.toHexString(this.g));
        if (this.l != 0) {
            strbuf.append(LINE_SEP + "l:" + LINE_SEP + "    " + this.l);
        }
        return strbuf.toString();
    }

    private void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.y = in.getBigInteger();
        }
        catch (IOException e) {
            throw new InvalidKeyException("Error parsing key encoding: " + e.toString());
        }
    }

    public int hashCode() {
        return Objects.hash(this.y, this.p, this.g);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof javax.crypto.interfaces.DHPublicKey)) {
            return false;
        }
        javax.crypto.interfaces.DHPublicKey other = (javax.crypto.interfaces.DHPublicKey)obj;
        DHParameterSpec otherParams = other.getParams();
        return this.y.compareTo(other.getY()) == 0 && this.p.compareTo(otherParams.getP()) == 0 && this.g.compareTo(otherParams.getG()) == 0;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.PUBLIC, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.key == null || this.key.length == 0) {
            throw new InvalidObjectException("key not deserializable");
        }
        this.key = (byte[])this.key.clone();
        if (this.encodedKey == null || this.encodedKey.length == 0) {
            throw new InvalidObjectException("encoded key not deserializable");
        }
        this.encodedKey = (byte[])this.encodedKey.clone();
    }
}

