/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.ProviderException;

final class GHASH {
    private static final int AES_BLOCK_SIZE = 16;
    private final long[] subkeyH;
    private final long[] state;
    private long stateSave0;
    private long stateSave1;

    private static long getLong(byte[] buffer, int offset) {
        long result = 0L;
        int end = offset + 8;
        for (int i = offset; i < end; ++i) {
            result = (result << 8) + (long)(buffer[i] & 0xFF);
        }
        return result;
    }

    private static void putLong(byte[] buffer, int offset, long value) {
        int end = offset + 8;
        for (int i = end - 1; i >= offset; --i) {
            buffer[i] = (byte)value;
            value >>= 8;
        }
    }

    private static void blockMult(long[] st, long[] subH) {
        long carry;
        long mask;
        int i;
        long Z0 = 0L;
        long Z1 = 0L;
        long V0 = subH[0];
        long V1 = subH[1];
        long X = st[0];
        for (i = 0; i < 64; ++i) {
            mask = X >> 63;
            Z0 ^= V0 & mask;
            Z1 ^= V1 & mask;
            mask = V1 << 63 >> 63;
            carry = V0 & 1L;
            V0 >>>= 1;
            V1 = V1 >>> 1 | carry << 63;
            V0 ^= 0xE100000000000000L & mask;
            X <<= 1;
        }
        X = st[1];
        for (i = 64; i < 127; ++i) {
            mask = X >> 63;
            Z0 ^= V0 & mask;
            Z1 ^= V1 & mask;
            mask = V1 << 63 >> 63;
            carry = V0 & 1L;
            V0 >>>= 1;
            V1 = V1 >>> 1 | carry << 63;
            V0 ^= 0xE100000000000000L & mask;
            X <<= 1;
        }
        long mask2 = X >> 63;
        st[0] = Z0 ^= V0 & mask2;
        st[1] = Z1 ^= V1 & mask2;
    }

    GHASH(byte[] subkeyH) throws ProviderException {
        if (subkeyH == null || subkeyH.length != 16) {
            throw new ProviderException("Internal error");
        }
        this.state = new long[2];
        this.subkeyH = new long[2];
        this.subkeyH[0] = GHASH.getLong(subkeyH, 0);
        this.subkeyH[1] = GHASH.getLong(subkeyH, 8);
    }

    void reset() {
        this.state[0] = 0L;
        this.state[1] = 0L;
    }

    void save() {
        this.stateSave0 = this.state[0];
        this.stateSave1 = this.state[1];
    }

    void restore() {
        this.state[0] = this.stateSave0;
        this.state[1] = this.stateSave1;
    }

    private static void processBlock(byte[] data, int ofs, long[] st, long[] subH) {
        st[0] = st[0] ^ GHASH.getLong(data, ofs);
        st[1] = st[1] ^ GHASH.getLong(data, ofs + 8);
        GHASH.blockMult(st, subH);
    }

    void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    void update(byte[] in, int inOfs, int inLen) {
        if (inLen == 0) {
            return;
        }
        GHASH.ghashRangeCheck(in, inOfs, inLen, this.state, this.subkeyH);
        GHASH.processBlocks(in, inOfs, inLen / 16, this.state, this.subkeyH);
    }

    private static void ghashRangeCheck(byte[] in, int inOfs, int inLen, long[] st, long[] subH) {
        if (inLen < 0) {
            throw new RuntimeException("invalid input length: " + inLen);
        }
        if (inOfs < 0) {
            throw new RuntimeException("invalid offset: " + inOfs);
        }
        if (inLen > in.length - inOfs) {
            throw new RuntimeException("input length out of bound: " + inLen + " > " + (in.length - inOfs));
        }
        if (inLen % 16 != 0) {
            throw new RuntimeException("input length/block size mismatch: " + inLen);
        }
        if (st.length != 2) {
            throw new RuntimeException("internal state has invalid length: " + st.length);
        }
        if (subH.length != 2) {
            throw new RuntimeException("internal subkeyH has invalid length: " + subH.length);
        }
    }

    private static void processBlocks(byte[] data, int inOfs, int blocks, long[] st, long[] subH) {
        int offset = inOfs;
        while (blocks > 0) {
            GHASH.processBlock(data, offset, st, subH);
            --blocks;
            offset += 16;
        }
    }

    byte[] digest() {
        byte[] result = new byte[16];
        GHASH.putLong(result, 0, this.state[0]);
        GHASH.putLong(result, 8, this.state[1]);
        this.reset();
        return result;
    }
}

