/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;

final class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private static final Debug debug = Debug.getInstance("pkcs11");
    private final Token token;
    private final int maxSessions;
    private AtomicInteger activeSessions = new AtomicInteger();
    private final Pool objSessions;
    private final Pool opSessions;
    private int maxActiveSessions;
    private Object maxActiveSessionsLock;
    private final long openSessionFlags;

    SessionManager(Token token) {
        long n;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            n = token.tokenInfo.ulMaxSessionCount;
        } else {
            this.openSessionFlags = 6L;
            n = token.tokenInfo.ulMaxRwSessionCount;
        }
        if (n == 0L) {
            n = Integer.MAX_VALUE;
        } else if (n == -1L || n < 0L) {
            n = 32L;
        }
        this.maxSessions = (int)Math.min(n, Integer.MAX_VALUE);
        this.token = token;
        this.objSessions = new Pool(this);
        this.opSessions = new Pool(this);
        if (debug != null) {
            this.maxActiveSessionsLock = new Object();
        }
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    Session getObjSession() throws PKCS11Exception {
        Session session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.openSession();
        return this.ensureValid(session);
    }

    Session getOpSession() throws PKCS11Exception {
        Session session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        if (this.maxSessions == Integer.MAX_VALUE || this.activeSessions.get() < this.maxSessions) {
            session = this.openSession();
            return this.ensureValid(session);
        }
        session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        throw new ProviderException("Could not obtain session");
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    Session killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (debug != null) {
            String location = new Exception().getStackTrace()[2].toString();
            System.out.println("Killing session (" + location + ") active: " + this.activeSessions.get());
        }
        this.closeSession(session);
        return null;
    }

    Session releaseSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (session.hasObjects()) {
            this.objSessions.release(session);
        } else {
            this.opSessions.release(session);
        }
        return null;
    }

    void demoteObjSession(Session session) {
        boolean present;
        if (!this.token.isValid()) {
            return;
        }
        if (debug != null) {
            System.out.println("Demoting session, active: " + this.activeSessions.get());
        }
        if (!(present = this.objSessions.remove(session))) {
            return;
        }
        this.releaseSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session openSession() throws PKCS11Exception {
        if (this.maxSessions != Integer.MAX_VALUE && this.activeSessions.get() >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long id = this.token.p11.C_OpenSession(this.token.provider.slotID, this.openSessionFlags, null, null);
        Session session = new Session(this.token, id);
        this.activeSessions.incrementAndGet();
        if (debug != null) {
            Object object = this.maxActiveSessionsLock;
            synchronized (object) {
                if (this.activeSessions.get() > this.maxActiveSessions) {
                    this.maxActiveSessions = this.activeSessions.get();
                    if (this.maxActiveSessions % 10 == 0) {
                        System.out.println("Open sessions: " + this.maxActiveSessions);
                    }
                }
            }
        }
        return session;
    }

    private void closeSession(Session session) {
        session.close();
        this.activeSessions.decrementAndGet();
    }

    public static final class Pool {
        private final SessionManager mgr;
        private final ConcurrentLinkedDeque<Session> pool;

        Pool(SessionManager mgr) {
            this.mgr = mgr;
            this.pool = new ConcurrentLinkedDeque();
        }

        boolean remove(Session session) {
            return this.pool.remove(session);
        }

        Session poll() {
            return this.pool.pollLast();
        }

        void release(Session session) {
            Session oldestSession;
            this.pool.offer(session);
            if (session.hasObjects()) {
                return;
            }
            int n = this.pool.size();
            if (n < 5) {
                return;
            }
            long time = System.currentTimeMillis();
            int i = 0;
            while ((oldestSession = this.pool.peek()) != null && !oldestSession.isLive(time) && this.pool.remove(oldestSession)) {
                this.mgr.closeSession(oldestSession);
                if (n - ++i > 1) continue;
            }
            if (debug != null) {
                System.out.println("Closing " + i + " idle sessions, active: " + this.mgr.activeSessions);
            }
        }
    }
}

