/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.SwingUtilities3;
import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuItemUI;
import sun.swing.MenuItemLayoutHelper;
import sun.swing.SwingUtilities2;

public class WindowsMenuItemUI
extends BasicMenuItemUI {
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        @Override
        public JMenuItem getMenuItem() {
            return WindowsMenuItemUI.this.menuItem;
        }

        @Override
        public TMSchema.State getState(JMenuItem menuItem) {
            return WindowsMenuItemUI.getState(this, menuItem);
        }

        @Override
        public TMSchema.Part getPart(JMenuItem menuItem) {
            return WindowsMenuItemUI.getPart(this, menuItem);
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new WindowsMenuItemUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String prefix = this.getPropertyPrefix();
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(prefix + ".acceleratorSelectionForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(prefix + ".acceleratorForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(prefix + ".disabledForeground");
        }
    }

    @Override
    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintMenuItem(this.accessor, g, c, checkIcon, arrowIcon, background, foreground, this.disabledForeground, this.acceleratorSelectionForeground, this.acceleratorForeground, defaultTextIconGap, this.menuItem, this.getPropertyPrefix());
            return;
        }
        super.paintMenuItem(g, c, checkIcon, arrowIcon, background, foreground, defaultTextIconGap);
    }

    static void paintMenuItem(WindowsMenuItemUIAccessor accessor, Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, Color disabledForeground, Color acceleratorSelectionForeground, Color acceleratorForeground, int defaultTextIconGap, JMenuItem menuItem, String prefix) {
        Rectangle rect;
        Font acceleratorFont;
        Font holdf = g.getFont();
        Color holdc = g.getColor();
        JMenuItem mi = (JMenuItem)c;
        g.setFont(mi.getFont());
        Rectangle viewRect = new Rectangle(0, 0, mi.getWidth(), mi.getHeight());
        SwingUtilities3.applyInsets(viewRect, mi.getInsets());
        String acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (acceleratorDelimiter == null) {
            acceleratorDelimiter = "+";
        }
        if ((acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont")) == null) {
            acceleratorFont = UIManager.getFont("MenuItem.font");
        }
        MenuItemLayoutHelper lh = new MenuItemLayoutHelper(mi, checkIcon, arrowIcon, viewRect, defaultTextIconGap, acceleratorDelimiter, mi.getComponentOrientation().isLeftToRight(), mi.getFont(), acceleratorFont, MenuItemLayoutHelper.useCheckAndArrow(menuItem), prefix);
        MenuItemLayoutHelper.LayoutResult lr = lh.layoutMenuItem();
        WindowsMenuItemUI.paintBackground(accessor, g, mi, background);
        SwingUtilities3.paintCheckIcon(g, lh, lr, holdc, foreground);
        SwingUtilities3.paintIcon(g, lh, lr, holdc);
        if (lh.getCheckIcon() != null && lh.useCheckAndArrow()) {
            rect = lr.getTextRect();
            rect.x += lh.getAfterCheckIconGap();
            lr.setTextRect(rect);
        }
        if (!lh.getText().isEmpty()) {
            if (lh.getHtmlView() != null) {
                lh.getHtmlView().paint(g, lr.getTextRect());
            } else {
                WindowsMenuItemUI.paintText(accessor, g, lh.getMenuItem(), lr.getTextRect(), lh.getText());
            }
        }
        if (lh.getCheckIcon() != null && lh.useCheckAndArrow()) {
            rect = lr.getAccRect();
            rect.x += lh.getAfterCheckIconGap();
            lr.setAccRect(rect);
        }
        SwingUtilities3.paintAccText(g, lh, lr, disabledForeground, acceleratorSelectionForeground, acceleratorForeground);
        SwingUtilities3.paintArrowIcon(g, lh, lr, foreground);
        g.setColor(holdc);
        g.setFont(holdf);
    }

    @Override
    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, g, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        if (model.isEnabled() && (model.isArmed() || menuItem instanceof JMenu && model.isSelected())) {
            g.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(g, menuItem, textRect, text, 0);
        g.setColor(oldColor);
    }

    @Override
    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, g, menuItem, bgColor);
            return;
        }
        super.paintBackground(g, menuItem, bgColor);
    }

    static void paintBackground(WindowsMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Color bgColor) {
        XPStyle xp = XPStyle.getXP();
        assert (WindowsMenuItemUI.isVistaPainting(xp));
        if (WindowsMenuItemUI.isVistaPainting(xp)) {
            int menuWidth = menuItem.getWidth();
            int menuHeight = menuItem.getHeight();
            if (menuItem.isOpaque()) {
                Color oldColor = g.getColor();
                g.setColor(menuItem.getBackground());
                g.fillRect(0, 0, menuWidth, menuHeight);
                g.setColor(oldColor);
            }
            TMSchema.Part part = menuItemUI.getPart(menuItem);
            XPStyle.Skin skin = xp.getSkin(menuItem, part);
            skin.paintSkin(g, 0, 0, menuWidth, menuHeight, menuItemUI.getState(menuItem));
        }
    }

    static void paintText(WindowsMenuItemUIAccessor menuItemUI, Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        assert (WindowsMenuItemUI.isVistaPainting());
        if (WindowsMenuItemUI.isVistaPainting()) {
            TMSchema.State state = menuItemUI.getState(menuItem);
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)menuItem, g);
            int mnemIndex = menuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                mnemIndex = -1;
            }
            WindowsGraphicsUtils.paintXPText(menuItem, menuItemUI.getPart(menuItem), state, g, textRect.x, textRect.y + fm.getAscent(), text, mnemIndex);
        }
    }

    static TMSchema.State getState(WindowsMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        ButtonModel model = menuItem.getModel();
        TMSchema.State state = model.isArmed() ? (model.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT) : (model.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED);
        return state;
    }

    static TMSchema.Part getPart(WindowsMenuItemUIAccessor menuItemUI, JMenuItem menuItem) {
        return TMSchema.Part.MP_POPUPITEM;
    }

    static boolean isVistaPainting(XPStyle xp) {
        return xp != null && xp.isSkinDefined(null, TMSchema.Part.MP_POPUPITEM);
    }

    static boolean isVistaPainting() {
        return WindowsMenuItemUI.isVistaPainting(XPStyle.getXP());
    }
}

