/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.VersionHelper;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.SharedSecrets;

final class VersionHelper12
extends VersionHelper {
    private static final String TRUST_URL_CODEBASE_PROPERTY = "com.sun.jndi.ldap.object.trustURLCodebase";
    private static final String TRUST_SERIAL_DATA_PROPERTY = "com.sun.jndi.ldap.object.trustSerialData";
    private static final boolean trustSerialData;
    private static final boolean trustURLCodebase;

    private static String getPrivilegedProperty(String propertyName, String defaultVal) {
        PrivilegedAction<String> action = () -> System.getProperty(propertyName, defaultVal);
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    VersionHelper12() {
    }

    public static boolean isSerialDataAllowed() {
        return trustSerialData;
    }

    @Override
    ClassLoader getURLClassLoader(String[] url) throws MalformedURLException {
        ClassLoader parent = this.getContextClassLoader();
        if (url != null && trustURLCodebase) {
            return URLClassLoader.newInstance(VersionHelper12.getUrlArray(url), parent);
        }
        return parent;
    }

    @Override
    Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = this.getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    @Override
    Thread createThread(final Runnable r) {
        final AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                return SharedSecrets.getJavaLangAccess().newThreadWithAcc(r, acc);
            }
        });
    }

    static {
        String trust = VersionHelper12.getPrivilegedProperty(TRUST_URL_CODEBASE_PROPERTY, "false");
        trustURLCodebase = "true".equalsIgnoreCase(trust);
        String trustSDString = VersionHelper12.getPrivilegedProperty(TRUST_SERIAL_DATA_PROPERTY, "false");
        trustSerialData = "true".equalsIgnoreCase(trustSDString);
    }
}

