/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class Uri {
    protected String uri;
    protected String scheme;
    protected String host = null;
    protected int port = -1;
    protected boolean hasAuthority;
    protected String path;
    protected String query = null;
    protected String fragment;

    public Uri(String uri) throws MalformedURLException {
        this.init(uri);
    }

    protected Uri() {
    }

    protected ParseMode parseMode() {
        return ParseMode.COMPAT;
    }

    protected void init(String uri) throws MalformedURLException {
        this.uri = uri;
        this.parse(uri, this.parseMode());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.uri;
    }

    private void parse(String uri, ParseMode mode) throws MalformedURLException {
        switch (mode) {
            case STRICT: {
                this.parseStrict(uri);
                break;
            }
            case COMPAT: {
                this.parseCompat(uri);
                break;
            }
            case LEGACY: {
                this.parseLegacy(uri);
            }
        }
    }

    private void parseStrict(String uri) throws MalformedURLException {
        try {
            if (!this.isSchemeOnly(uri)) {
                URI u = new URI(uri);
                this.scheme = u.getScheme();
                if (this.scheme == null) {
                    throw new MalformedURLException("Invalid URI: " + uri);
                }
                String auth = u.getRawAuthority();
                boolean bl = this.hasAuthority = auth != null;
                if (this.hasAuthority) {
                    String hostport;
                    String host = u.getHost();
                    int port = u.getPort();
                    if (host != null) {
                        this.host = host;
                    }
                    if (port != -1) {
                        this.port = port;
                    }
                    if (!(hostport = (host == null ? "" : host) + (port == -1 ? "" : ":" + port)).equals(auth)) {
                        throw new MalformedURLException("unsupported authority: " + auth);
                    }
                }
                this.path = u.getRawPath();
                if (u.getRawQuery() != null) {
                    this.query = "?" + u.getRawQuery();
                }
                if (u.getRawFragment() != null) {
                    if (!this.acceptsFragment()) {
                        throw new MalformedURLException("URI fragments not supported: " + uri);
                    }
                    this.fragment = "#" + u.getRawFragment();
                }
            } else {
                URI u;
                String s = uri.substring(0, uri.indexOf(58));
                if (!s.equals((u = new URI(uri + "/")).getScheme()) || !this.checkSchemeOnly(uri, u.getScheme())) {
                    throw this.newInvalidURISchemeException(uri);
                }
                this.scheme = s;
                this.path = "";
            }
        }
        catch (URISyntaxException e) {
            MalformedURLException mue = new MalformedURLException(e.getMessage());
            mue.initCause(e);
            throw mue;
        }
    }

    private void parseCompat(String uri) throws MalformedURLException {
        int endp;
        int i = uri.indexOf(58);
        int slash = uri.indexOf(47);
        int qmark = uri.indexOf(63);
        int fmark = uri.indexOf(35);
        if (i < 0 || slash > 0 && i > slash || qmark > 0 && i > qmark || fmark > 0 && i > fmark) {
            throw new MalformedURLException("Invalid URI: " + uri);
        }
        if (fmark > -1 && !this.acceptsFragment()) {
            throw new MalformedURLException("URI fragments not supported: " + uri);
        }
        if (i == uri.length() - 1 && !this.isSchemeOnly(uri)) {
            throw this.newInvalidURISchemeException(uri);
        }
        this.scheme = uri.substring(0, i);
        this.hasAuthority = uri.startsWith("//", ++i);
        if (fmark > -1 && qmark > fmark) {
            qmark = -1;
        }
        int n = qmark > -1 ? qmark : (endp = fmark > -1 ? fmark : uri.length());
        if (this.hasAuthority) {
            int starta = i += 2;
            int enda = uri.indexOf(47, i);
            if (enda == -1 || qmark > -1 && qmark < enda) {
                enda = qmark;
            }
            if (enda == -1 || fmark > -1 && fmark < enda) {
                enda = fmark;
            }
            if (enda < 0) {
                enda = uri.length();
            }
            if (uri.startsWith(":", i)) {
                this.host = "";
                if (enda > ++i) {
                    this.port = Integer.parseInt(uri.substring(i, enda));
                }
            } else {
                try {
                    URI u = new URI(uri.substring(0, enda) + "/");
                    String auth = uri.substring(starta, enda);
                    this.host = u.getHost();
                    this.port = u.getPort();
                    String p = u.getRawPath();
                    String q = u.getRawQuery();
                    String f = u.getRawFragment();
                    String ui = u.getRawUserInfo();
                    if (ui != null) {
                        throw new MalformedURLException("user info not supported in authority: " + ui);
                    }
                    if (!"/".equals(p)) {
                        throw new MalformedURLException("invalid authority: " + auth);
                    }
                    if (q != null) {
                        throw new MalformedURLException("invalid trailing characters in authority: ?" + q);
                    }
                    if (f != null) {
                        throw new MalformedURLException("invalid trailing characters in authority: #" + f);
                    }
                    String hostport = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                    if (!auth.equals(hostport)) {
                        throw new MalformedURLException("unsupported authority: " + auth);
                    }
                }
                catch (URISyntaxException e) {
                    MalformedURLException mue = new MalformedURLException(e.getMessage());
                    mue.initCause(e);
                    throw mue;
                }
            }
            i = enda;
        }
        this.path = uri.substring(i, endp);
        if (qmark > -1) {
            this.query = fmark > -1 ? uri.substring(qmark, fmark) : uri.substring(qmark);
        }
        if (fmark > -1) {
            this.fragment = uri.substring(fmark);
        }
    }

    protected boolean isSchemeOnly(String uri) {
        return false;
    }

    protected boolean checkSchemeOnly(String uri, String scheme) {
        return uri.equals(scheme + ":");
    }

    protected MalformedURLException newInvalidURISchemeException(String uri) {
        return new MalformedURLException("Invalid URI scheme: " + uri);
    }

    protected boolean acceptsFragment() {
        return this.parseMode() == ParseMode.LEGACY;
    }

    private void parseLegacy(String uri) throws MalformedURLException {
        int qmark;
        int i = uri.indexOf(58);
        if (i < 0) {
            throw new MalformedURLException("Invalid URI: " + uri);
        }
        this.scheme = uri.substring(0, i);
        this.hasAuthority = uri.startsWith("//", ++i);
        if (this.hasAuthority) {
            int slash = uri.indexOf(47, i += 2);
            if (slash < 0) {
                slash = uri.length();
            }
            if (uri.startsWith("[", i)) {
                int brac = uri.indexOf(93, i + 1);
                if (brac < 0 || brac > slash) {
                    throw new MalformedURLException("Invalid URI: " + uri);
                }
                this.host = uri.substring(i, brac + 1);
                i = brac + 1;
            } else {
                int hostEnd;
                int colon = uri.indexOf(58, i);
                int n = hostEnd = colon < 0 || colon > slash ? slash : colon;
                if (i < hostEnd) {
                    this.host = uri.substring(i, hostEnd);
                }
                i = hostEnd;
            }
            if (i + 1 < slash && uri.startsWith(":", i)) {
                this.port = Integer.parseInt(uri.substring(++i, slash));
            }
            i = slash;
        }
        if ((qmark = uri.indexOf(63, i)) < 0) {
            this.path = uri.substring(i);
        } else {
            this.path = uri.substring(i, qmark);
            this.query = uri.substring(qmark);
        }
    }

    public static enum ParseMode {
        STRICT,
        COMPAT,
        LEGACY;

    }
}

