/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.slf4j.internal.Logger;
import com.sun.org.slf4j.internal.LoggerFactory;
import java.io.ByteArrayOutputStream;

public class SignerOutputStream
extends ByteArrayOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(SignerOutputStream.class);
    final SignatureAlgorithm sa;

    public SignerOutputStream(SignatureAlgorithm sa) {
        this.sa = sa;
    }

    @Override
    public void write(byte[] arg0) {
        try {
            this.sa.update(arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(int arg0) {
        try {
            this.sa.update((byte)arg0);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Canonicalized SignedInfo:");
            StringBuilder sb = new StringBuilder(arg2);
            for (int i = arg1; i < arg1 + arg2; ++i) {
                sb.append((char)arg0[i]);
            }
            LOG.debug(sb.toString());
        }
        try {
            this.sa.update(arg0, arg1, arg2);
        }
        catch (XMLSignatureException e) {
            throw new RuntimeException("" + e);
        }
    }
}

