/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import sun.security.util.Debug;

final class SystemConfigurator {
    private static final Debug sdebug = Debug.getInstance("properties");
    private static final String CRYPTO_POLICIES_BASE_DIR = "/etc/crypto-policies";
    private static final String CRYPTO_POLICIES_JAVA_CONFIG = "/etc/crypto-policies/back-ends/java.config";
    private static boolean systemFipsEnabled = false;
    private static boolean plainKeySupportEnabled = false;
    private static final String SYSTEMCONF_NATIVE_LIB = "systemconf";

    SystemConfigurator() {
    }

    private static native boolean getSystemFIPSEnabled() throws IOException;

    static boolean configureSysProps(Properties props) {
        boolean systemSecPropsLoaded;
        block15: {
            systemSecPropsLoaded = false;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(CRYPTO_POLICIES_JAVA_CONFIG));){
                props.load(bis);
                systemSecPropsLoaded = true;
                if (sdebug != null) {
                    sdebug.println("reading system security properties file /etc/crypto-policies/back-ends/java.config");
                    sdebug.println(props.toString());
                }
            }
            catch (IOException e) {
                if (sdebug == null) break block15;
                sdebug.println("unable to load security properties from /etc/crypto-policies/back-ends/java.config");
                e.printStackTrace();
            }
        }
        return systemSecPropsLoaded;
    }

    static boolean configureFIPS(Properties props) {
        boolean loadedProps;
        block17: {
            loadedProps = false;
            try {
                if (SystemConfigurator.enableFips()) {
                    if (sdebug != null) {
                        sdebug.println("FIPS mode detected");
                    }
                    Iterator i = props.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        if (!((String)e.getKey()).startsWith("security.provider")) continue;
                        if (sdebug != null) {
                            sdebug.println("Removing provider: " + e);
                        }
                        i.remove();
                    }
                    String fipsProviderValue = null;
                    int n = 1;
                    while ((fipsProviderValue = (String)props.get("fips.provider." + n)) != null) {
                        String fipsProviderKey = "security.provider." + n;
                        if (sdebug != null) {
                            sdebug.println("Adding provider " + n + ": " + fipsProviderKey + "=" + fipsProviderValue);
                        }
                        props.put(fipsProviderKey, fipsProviderValue);
                        ++n;
                    }
                    String keystoreTypeValue = (String)props.get("fips.keystore.type");
                    if (keystoreTypeValue != null) {
                        String nonFipsKeystoreType = props.getProperty("keystore.type");
                        props.put("keystore.type", keystoreTypeValue);
                        if (keystoreTypeValue.equals("PKCS11")) {
                            System.setProperty("javax.net.ssl.keyStore", "NONE");
                        }
                        if (System.getProperty("javax.net.ssl.trustStoreType") == null) {
                            System.setProperty("javax.net.ssl.trustStoreType", nonFipsKeystoreType);
                        }
                        if (sdebug != null) {
                            sdebug.println("FIPS mode default keystore.type = " + keystoreTypeValue);
                            sdebug.println("FIPS mode javax.net.ssl.keyStore = " + System.getProperty("javax.net.ssl.keyStore", ""));
                            sdebug.println("FIPS mode javax.net.ssl.trustStoreType = " + System.getProperty("javax.net.ssl.trustStoreType", ""));
                        }
                    }
                    loadedProps = true;
                    systemFipsEnabled = true;
                    String plainKeySupport = System.getProperty("com.redhat.fips.plainKeySupport", "true");
                    boolean bl = plainKeySupportEnabled = !"false".equals(plainKeySupport);
                    if (sdebug != null) {
                        if (plainKeySupportEnabled) {
                            sdebug.println("FIPS support enabled with plain key support");
                        } else {
                            sdebug.println("FIPS support enabled without plain key support");
                        }
                    }
                } else if (sdebug != null) {
                    sdebug.println("FIPS mode not detected");
                }
            }
            catch (Exception e) {
                if (sdebug == null) break block17;
                sdebug.println("unable to load FIPS configuration");
                e.printStackTrace();
            }
        }
        return loadedProps;
    }

    static boolean isSystemFipsEnabled() {
        return systemFipsEnabled;
    }

    static boolean isPlainKeySupportEnabled() {
        return plainKeySupportEnabled;
    }

    private static boolean enableFips() throws IOException {
        if (sdebug != null) {
            sdebug.println("Calling getSystemFIPSEnabled (libsystemconf)...");
        }
        try {
            boolean fipsEnabled = SystemConfigurator.getSystemFIPSEnabled();
            if (sdebug != null) {
                sdebug.println("Call to getSystemFIPSEnabled (libsystemconf) returned: " + fipsEnabled);
            }
            return fipsEnabled;
        }
        catch (IOException e) {
            if (sdebug != null) {
                sdebug.println("Call to getSystemFIPSEnabled (libsystemconf) failed:");
                sdebug.println(e.getMessage());
            }
            throw e;
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary(SystemConfigurator.SYSTEMCONF_NATIVE_LIB);
                return null;
            }
        });
    }
}

