/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.FormattedFloatingDecimal;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable a;
    private final Locale l;
    private IOException lastException;
    private final char zero;
    private static double scaleUp;
    private static final int MAX_FD_CHARS = 30;
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static Pattern fsPattern;

    private static Charset toCharset(String csn) throws UnsupportedEncodingException {
        Objects.requireNonNull(csn, "charsetName");
        try {
            return Charset.forName(csn);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException unused) {
            throw new UnsupportedEncodingException(csn);
        }
    }

    private static final Appendable nonNullAppendable(Appendable a) {
        if (a == null) {
            return new StringBuilder();
        }
        return a;
    }

    private Formatter(Locale l, Appendable a) {
        this.a = a;
        this.l = l;
        this.zero = Formatter.getZero(l);
    }

    private Formatter(Charset charset, Locale l, File file) throws FileNotFoundException {
        this(l, new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset)));
    }

    public Formatter() {
        this(Locale.getDefault(Locale.Category.FORMAT), new StringBuilder());
    }

    public Formatter(Appendable a) {
        this(Locale.getDefault(Locale.Category.FORMAT), Formatter.nonNullAppendable(a));
    }

    public Formatter(Locale l) {
        this(l, new StringBuilder());
    }

    public Formatter(Appendable a, Locale l) {
        this(l, Formatter.nonNullAppendable(a));
    }

    public Formatter(String fileName) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))));
    }

    public Formatter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(fileName, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(String fileName, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(csn), l, new File(fileName));
    }

    public Formatter(File file) throws FileNotFoundException {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
    }

    public Formatter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(File file, String csn, Locale l) throws FileNotFoundException, UnsupportedEncodingException {
        this(Formatter.toCharset(csn), l, file);
    }

    public Formatter(PrintStream ps) {
        this(Locale.getDefault(Locale.Category.FORMAT), Objects.requireNonNull(ps));
    }

    public Formatter(OutputStream os) {
        this(Locale.getDefault(Locale.Category.FORMAT), new BufferedWriter(new OutputStreamWriter(os)));
    }

    public Formatter(OutputStream os, String csn) throws UnsupportedEncodingException {
        this(os, csn, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Formatter(OutputStream os, String csn, Locale l) throws UnsupportedEncodingException {
        this(l, new BufferedWriter(new OutputStreamWriter(os, csn)));
    }

    private static char getZero(Locale l) {
        if (l != null && !l.equals(Locale.US)) {
            DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(l);
            return dfs.getZeroDigit();
        }
        return '0';
    }

    public Locale locale() {
        this.ensureOpen();
        return this.l;
    }

    public Appendable out() {
        this.ensureOpen();
        return this.a;
    }

    public String toString() {
        this.ensureOpen();
        return this.a.toString();
    }

    @Override
    public void flush() {
        this.ensureOpen();
        if (this.a instanceof Flushable) {
            try {
                ((Flushable)((Object)this.a)).flush();
            }
            catch (IOException ioe) {
                this.lastException = ioe;
            }
        }
    }

    @Override
    public void close() {
        if (this.a == null) {
            return;
        }
        try {
            if (this.a instanceof Closeable) {
                ((Closeable)((Object)this.a)).close();
            }
        }
        catch (IOException ioe) {
            this.lastException = ioe;
        }
        finally {
            this.a = null;
        }
    }

    private void ensureOpen() {
        if (this.a == null) {
            throw new FormatterClosedException();
        }
    }

    public IOException ioException() {
        return this.lastException;
    }

    public Formatter format(String format, Object ... args) {
        return this.format(this.l, format, args);
    }

    public Formatter format(Locale l, String format, Object ... args) {
        this.ensureOpen();
        int last = -1;
        int lasto = -1;
        FormatString[] fsa = this.parse(format);
        for (int i = 0; i < fsa.length; ++i) {
            FormatString fs = fsa[i];
            int index = fs.index();
            try {
                switch (index) {
                    case -2: {
                        fs.print(null, l);
                        break;
                    }
                    case -1: {
                        if (last < 0 || args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last], l);
                        break;
                    }
                    case 0: {
                        last = ++lasto;
                        if (args != null && lasto > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[lasto], l);
                        break;
                    }
                    default: {
                        last = index - 1;
                        if (args != null && last > args.length - 1) {
                            throw new MissingFormatArgumentException(fs.toString());
                        }
                        fs.print(args == null ? null : args[last], l);
                        break;
                    }
                }
                continue;
            }
            catch (IOException x) {
                this.lastException = x;
            }
        }
        return this;
    }

    private FormatString[] parse(String s) {
        ArrayList<FormatString> al = new ArrayList<FormatString>();
        Matcher m = fsPattern.matcher(s);
        int i = 0;
        int len = s.length();
        while (i < len) {
            if (m.find(i)) {
                if (m.start() != i) {
                    Formatter.checkText(s, i, m.start());
                    al.add(new FixedString(s.substring(i, m.start())));
                }
                al.add(new FormatSpecifier(m));
                i = m.end();
                continue;
            }
            Formatter.checkText(s, i, len);
            al.add(new FixedString(s.substring(i)));
            break;
        }
        return al.toArray(new FormatString[al.size()]);
    }

    private static void checkText(String s, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (s.charAt(i) != '%') continue;
            char c = i == end - 1 ? (char)'%' : (char)s.charAt(i + 1);
            throw new UnknownFormatConversionException(String.valueOf(c));
        }
    }

    static {
        fsPattern = Pattern.compile(formatSpecifier);
    }

    private static class DateTime {
        static final char HOUR_OF_DAY_0 = 'H';
        static final char HOUR_0 = 'I';
        static final char HOUR_OF_DAY = 'k';
        static final char HOUR = 'l';
        static final char MINUTE = 'M';
        static final char NANOSECOND = 'N';
        static final char MILLISECOND = 'L';
        static final char MILLISECOND_SINCE_EPOCH = 'Q';
        static final char AM_PM = 'p';
        static final char SECONDS_SINCE_EPOCH = 's';
        static final char SECOND = 'S';
        static final char TIME = 'T';
        static final char ZONE_NUMERIC = 'z';
        static final char ZONE = 'Z';
        static final char NAME_OF_DAY_ABBREV = 'a';
        static final char NAME_OF_DAY = 'A';
        static final char NAME_OF_MONTH_ABBREV = 'b';
        static final char NAME_OF_MONTH = 'B';
        static final char CENTURY = 'C';
        static final char DAY_OF_MONTH_0 = 'd';
        static final char DAY_OF_MONTH = 'e';
        static final char NAME_OF_MONTH_ABBREV_X = 'h';
        static final char DAY_OF_YEAR = 'j';
        static final char MONTH = 'm';
        static final char YEAR_2 = 'y';
        static final char YEAR_4 = 'Y';
        static final char TIME_12_HOUR = 'r';
        static final char TIME_24_HOUR = 'R';
        static final char DATE_TIME = 'c';
        static final char DATE = 'D';
        static final char ISO_STANDARD_DATE = 'F';

        private DateTime() {
        }

        static boolean isValid(char c) {
            switch (c) {
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'I': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'p': 
                case 'r': 
                case 's': 
                case 'y': 
                case 'z': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Conversion {
        static final char DECIMAL_INTEGER = 'd';
        static final char OCTAL_INTEGER = 'o';
        static final char HEXADECIMAL_INTEGER = 'x';
        static final char HEXADECIMAL_INTEGER_UPPER = 'X';
        static final char SCIENTIFIC = 'e';
        static final char SCIENTIFIC_UPPER = 'E';
        static final char GENERAL = 'g';
        static final char GENERAL_UPPER = 'G';
        static final char DECIMAL_FLOAT = 'f';
        static final char HEXADECIMAL_FLOAT = 'a';
        static final char HEXADECIMAL_FLOAT_UPPER = 'A';
        static final char CHARACTER = 'c';
        static final char CHARACTER_UPPER = 'C';
        static final char DATE_TIME = 't';
        static final char DATE_TIME_UPPER = 'T';
        static final char BOOLEAN = 'b';
        static final char BOOLEAN_UPPER = 'B';
        static final char STRING = 's';
        static final char STRING_UPPER = 'S';
        static final char HASHCODE = 'h';
        static final char HASHCODE_UPPER = 'H';
        static final char LINE_SEPARATOR = 'n';
        static final char PERCENT_SIGN = '%';

        private Conversion() {
        }

        static boolean isValid(char c) {
            return Conversion.isGeneral(c) || Conversion.isInteger(c) || Conversion.isFloat(c) || Conversion.isText(c) || c == 't' || Conversion.isCharacter(c);
        }

        static boolean isGeneral(char c) {
            switch (c) {
                case 'B': 
                case 'H': 
                case 'S': 
                case 'b': 
                case 'h': 
                case 's': {
                    return true;
                }
            }
            return false;
        }

        static boolean isCharacter(char c) {
            switch (c) {
                case 'C': 
                case 'c': {
                    return true;
                }
            }
            return false;
        }

        static boolean isInteger(char c) {
            switch (c) {
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    return true;
                }
            }
            return false;
        }

        static boolean isFloat(char c) {
            switch (c) {
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    return true;
                }
            }
            return false;
        }

        static boolean isText(char c) {
            switch (c) {
                case '%': 
                case 'n': {
                    return true;
                }
            }
            return false;
        }
    }

    private static class Flags {
        private int flags;
        static final Flags NONE = new Flags(0);
        static final Flags LEFT_JUSTIFY = new Flags(1);
        static final Flags UPPERCASE = new Flags(2);
        static final Flags ALTERNATE = new Flags(4);
        static final Flags PLUS = new Flags(8);
        static final Flags LEADING_SPACE = new Flags(16);
        static final Flags ZERO_PAD = new Flags(32);
        static final Flags GROUP = new Flags(64);
        static final Flags PARENTHESES = new Flags(128);
        static final Flags PREVIOUS = new Flags(256);

        private Flags(int f) {
            this.flags = f;
        }

        public int valueOf() {
            return this.flags;
        }

        public boolean contains(Flags f) {
            return (this.flags & f.valueOf()) == f.valueOf();
        }

        public Flags dup() {
            return new Flags(this.flags);
        }

        private Flags add(Flags f) {
            this.flags |= f.valueOf();
            return this;
        }

        public Flags remove(Flags f) {
            this.flags &= ~f.valueOf();
            return this;
        }

        public static Flags parse(String s) {
            char[] ca = s.toCharArray();
            Flags f = new Flags(0);
            for (int i = 0; i < ca.length; ++i) {
                Flags v = Flags.parse(ca[i]);
                if (f.contains(v)) {
                    throw new DuplicateFormatFlagsException(v.toString());
                }
                f.add(v);
            }
            return f;
        }

        private static Flags parse(char c) {
            switch (c) {
                case '-': {
                    return LEFT_JUSTIFY;
                }
                case '#': {
                    return ALTERNATE;
                }
                case '+': {
                    return PLUS;
                }
                case ' ': {
                    return LEADING_SPACE;
                }
                case '0': {
                    return ZERO_PAD;
                }
                case ',': {
                    return GROUP;
                }
                case '(': {
                    return PARENTHESES;
                }
                case '<': {
                    return PREVIOUS;
                }
            }
            throw new UnknownFormatFlagsException(String.valueOf(c));
        }

        public static String toString(Flags f) {
            return f.toString();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.contains(LEFT_JUSTIFY)) {
                sb.append('-');
            }
            if (this.contains(UPPERCASE)) {
                sb.append('^');
            }
            if (this.contains(ALTERNATE)) {
                sb.append('#');
            }
            if (this.contains(PLUS)) {
                sb.append('+');
            }
            if (this.contains(LEADING_SPACE)) {
                sb.append(' ');
            }
            if (this.contains(ZERO_PAD)) {
                sb.append('0');
            }
            if (this.contains(GROUP)) {
                sb.append(',');
            }
            if (this.contains(PARENTHESES)) {
                sb.append('(');
            }
            if (this.contains(PREVIOUS)) {
                sb.append('<');
            }
            return sb.toString();
        }
    }

    private class FormatSpecifier
    implements FormatString {
        private int index = -1;
        private Flags f = Flags.NONE;
        private int width;
        private int precision;
        private boolean dt = false;
        private char c;

        private int index(String s) {
            if (s != null) {
                try {
                    this.index = Integer.parseInt(s.substring(0, s.length() - 1));
                }
                catch (NumberFormatException x) {
                    assert (false);
                }
            } else {
                this.index = 0;
            }
            return this.index;
        }

        @Override
        public int index() {
            return this.index;
        }

        private Flags flags(String s) {
            this.f = Flags.parse(s);
            if (this.f.contains(Flags.PREVIOUS)) {
                this.index = -1;
            }
            return this.f;
        }

        Flags flags() {
            return this.f;
        }

        private int width(String s) {
            block4: {
                this.width = -1;
                if (s != null) {
                    try {
                        this.width = Integer.parseInt(s);
                        if (this.width < 0) {
                            throw new IllegalFormatWidthException(this.width);
                        }
                    }
                    catch (NumberFormatException x) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.width;
        }

        int width() {
            return this.width;
        }

        private int precision(String s) {
            block4: {
                this.precision = -1;
                if (s != null) {
                    try {
                        this.precision = Integer.parseInt(s.substring(1));
                        if (this.precision < 0) {
                            throw new IllegalFormatPrecisionException(this.precision);
                        }
                    }
                    catch (NumberFormatException x) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }
            return this.precision;
        }

        int precision() {
            return this.precision;
        }

        private char conversion(String s) {
            this.c = s.charAt(0);
            if (!this.dt) {
                if (!Conversion.isValid(this.c)) {
                    throw new UnknownFormatConversionException(String.valueOf(this.c));
                }
                if (Character.isUpperCase(this.c)) {
                    this.f.add(Flags.UPPERCASE);
                }
                this.c = Character.toLowerCase(this.c);
                if (Conversion.isText(this.c)) {
                    this.index = -2;
                }
            }
            return this.c;
        }

        private char conversion() {
            return this.c;
        }

        FormatSpecifier(Matcher m) {
            int idx = 1;
            this.index(m.group(idx++));
            this.flags(m.group(idx++));
            this.width(m.group(idx++));
            this.precision(m.group(idx++));
            String tT = m.group(idx++);
            if (tT != null) {
                this.dt = true;
                if (tT.equals("T")) {
                    this.f.add(Flags.UPPERCASE);
                }
            }
            this.conversion(m.group(idx));
            if (this.dt) {
                this.checkDateTime();
            } else if (Conversion.isGeneral(this.c)) {
                this.checkGeneral();
            } else if (Conversion.isCharacter(this.c)) {
                this.checkCharacter();
            } else if (Conversion.isInteger(this.c)) {
                this.checkInteger();
            } else if (Conversion.isFloat(this.c)) {
                this.checkFloat();
            } else if (Conversion.isText(this.c)) {
                this.checkText();
            } else {
                throw new UnknownFormatConversionException(String.valueOf(this.c));
            }
        }

        @Override
        public void print(Object arg, Locale l) throws IOException {
            if (this.dt) {
                this.printDateTime(arg, l);
                return;
            }
            switch (this.c) {
                case 'd': 
                case 'o': 
                case 'x': {
                    this.printInteger(arg, l);
                    break;
                }
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    this.printFloat(arg, l);
                    break;
                }
                case 'C': 
                case 'c': {
                    this.printCharacter(arg);
                    break;
                }
                case 'b': {
                    this.printBoolean(arg);
                    break;
                }
                case 's': {
                    this.printString(arg, l);
                    break;
                }
                case 'h': {
                    this.printHashCode(arg);
                    break;
                }
                case 'n': {
                    Formatter.this.a.append(System.lineSeparator());
                    break;
                }
                case '%': {
                    Formatter.this.a.append('%');
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void printInteger(Object arg, Locale l) throws IOException {
            if (arg == null) {
                this.print("null");
            } else if (arg instanceof Byte) {
                this.print((Byte)arg, l);
            } else if (arg instanceof Short) {
                this.print((Short)arg, l);
            } else if (arg instanceof Integer) {
                this.print((Integer)arg, l);
            } else if (arg instanceof Long) {
                this.print((Long)arg, l);
            } else if (arg instanceof BigInteger) {
                this.print((BigInteger)arg, l);
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printFloat(Object arg, Locale l) throws IOException {
            if (arg == null) {
                this.print("null");
            } else if (arg instanceof Float) {
                this.print(((Float)arg).floatValue(), l);
            } else if (arg instanceof Double) {
                this.print((Double)arg, l);
            } else if (arg instanceof BigDecimal) {
                this.print((BigDecimal)arg, l);
            } else {
                this.failConversion(this.c, arg);
            }
        }

        private void printDateTime(Object arg, Locale l) throws IOException {
            if (arg == null) {
                this.print("null");
                return;
            }
            Calendar cal = null;
            if (arg instanceof Long) {
                cal = Calendar.getInstance(l == null ? Locale.US : l);
                cal.setTimeInMillis((Long)arg);
            } else if (arg instanceof Date) {
                cal = Calendar.getInstance(l == null ? Locale.US : l);
                cal.setTime((Date)arg);
            } else if (arg instanceof Calendar) {
                cal = (Calendar)((Calendar)arg).clone();
                cal.setLenient(true);
            } else {
                if (arg instanceof TemporalAccessor) {
                    this.print((TemporalAccessor)arg, this.c, l);
                    return;
                }
                this.failConversion(this.c, arg);
            }
            this.print(cal, this.c, l);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void printCharacter(Object arg) throws IOException {
            if (arg == null) {
                this.print("null");
                return;
            }
            String s = null;
            if (arg instanceof Character) {
                s = ((Character)arg).toString();
            } else if (arg instanceof Byte) {
                byte i = (Byte)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Short) {
                short i = (Short)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else if (arg instanceof Integer) {
                int i = (Integer)arg;
                if (!Character.isValidCodePoint(i)) throw new IllegalFormatCodePointException(i);
                s = new String(Character.toChars(i));
            } else {
                this.failConversion(this.c, arg);
            }
            this.print(s);
        }

        private void printString(Object arg, Locale l) throws IOException {
            if (arg instanceof Formattable) {
                Formatter fmt = Formatter.this;
                if (fmt.locale() != l) {
                    fmt = new Formatter(fmt.out(), l);
                }
                ((Formattable)arg).formatTo(fmt, this.f.valueOf(), this.width, this.precision);
            } else {
                if (this.f.contains(Flags.ALTERNATE)) {
                    this.failMismatch(Flags.ALTERNATE, 's');
                }
                if (arg == null) {
                    this.print("null");
                } else {
                    this.print(arg.toString());
                }
            }
        }

        private void printBoolean(Object arg) throws IOException {
            String s = arg != null ? (arg instanceof Boolean ? ((Boolean)arg).toString() : Boolean.toString(true)) : Boolean.toString(false);
            this.print(s);
        }

        private void printHashCode(Object arg) throws IOException {
            String s = arg == null ? "null" : Integer.toHexString(arg.hashCode());
            this.print(s);
        }

        private void print(String s) throws IOException {
            if (this.precision != -1 && this.precision < s.length()) {
                s = s.substring(0, this.precision);
            }
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            Formatter.this.a.append(this.justify(s));
        }

        private String justify(String s) {
            int i;
            if (this.width == -1) {
                return s;
            }
            StringBuilder sb = new StringBuilder();
            boolean pad = this.f.contains(Flags.LEFT_JUSTIFY);
            int sp = this.width - s.length();
            if (!pad) {
                for (i = 0; i < sp; ++i) {
                    sb.append(' ');
                }
            }
            sb.append(s);
            if (pad) {
                for (i = 0; i < sp; ++i) {
                    sb.append(' ');
                }
            }
            return sb.toString();
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("%");
            Flags dupf = this.f.dup().remove(Flags.UPPERCASE);
            sb.append(dupf.toString());
            if (this.index > 0) {
                sb.append(this.index).append('$');
            }
            if (this.width != -1) {
                sb.append(this.width);
            }
            if (this.precision != -1) {
                sb.append('.').append(this.precision);
            }
            if (this.dt) {
                sb.append(this.f.contains(Flags.UPPERCASE) ? (char)'T' : 't');
            }
            sb.append(this.f.contains(Flags.UPPERCASE) ? Character.toUpperCase(this.c) : this.c);
            return sb.toString();
        }

        private void checkGeneral() {
            if ((this.c == 'b' || this.c == 'h') && this.f.contains(Flags.ALTERNATE)) {
                this.failMismatch(Flags.ALTERNATE, this.c);
            }
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
            this.checkBadFlags(Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
        }

        private void checkDateTime() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (!DateTime.isValid(this.c)) {
                throw new UnknownFormatConversionException("t" + this.c);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkCharacter() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            this.checkBadFlags(Flags.ALTERNATE, Flags.PLUS, Flags.LEADING_SPACE, Flags.ZERO_PAD, Flags.GROUP, Flags.PARENTHESES);
            if (this.width == -1 && this.f.contains(Flags.LEFT_JUSTIFY)) {
                throw new MissingFormatWidthException(this.toString());
            }
        }

        private void checkInteger() {
            this.checkNumeric();
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.c == 'd') {
                this.checkBadFlags(Flags.ALTERNATE);
            } else if (this.c == 'o') {
                this.checkBadFlags(Flags.GROUP);
            } else {
                this.checkBadFlags(Flags.GROUP);
            }
        }

        private void checkBadFlags(Flags ... badFlags) {
            for (int i = 0; i < badFlags.length; ++i) {
                if (!this.f.contains(badFlags[i])) continue;
                this.failMismatch(badFlags[i], this.c);
            }
        }

        private void checkFloat() {
            this.checkNumeric();
            if (this.c != 'f') {
                if (this.c == 'a') {
                    this.checkBadFlags(Flags.PARENTHESES, Flags.GROUP);
                } else if (this.c == 'e') {
                    this.checkBadFlags(Flags.GROUP);
                } else if (this.c == 'g') {
                    this.checkBadFlags(Flags.ALTERNATE);
                }
            }
        }

        private void checkNumeric() {
            if (this.width != -1 && this.width < 0) {
                throw new IllegalFormatWidthException(this.width);
            }
            if (this.precision != -1 && this.precision < 0) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            if (this.width == -1 && (this.f.contains(Flags.LEFT_JUSTIFY) || this.f.contains(Flags.ZERO_PAD))) {
                throw new MissingFormatWidthException(this.toString());
            }
            if (this.f.contains(Flags.PLUS) && this.f.contains(Flags.LEADING_SPACE) || this.f.contains(Flags.LEFT_JUSTIFY) && this.f.contains(Flags.ZERO_PAD)) {
                throw new IllegalFormatFlagsException(this.f.toString());
            }
        }

        private void checkText() {
            if (this.precision != -1) {
                throw new IllegalFormatPrecisionException(this.precision);
            }
            switch (this.c) {
                case '%': {
                    if (this.f.valueOf() != Flags.LEFT_JUSTIFY.valueOf() && this.f.valueOf() != Flags.NONE.valueOf()) {
                        throw new IllegalFormatFlagsException(this.f.toString());
                    }
                    if (this.width != -1 || !this.f.contains(Flags.LEFT_JUSTIFY)) break;
                    throw new MissingFormatWidthException(this.toString());
                }
                case 'n': {
                    if (this.width != -1) {
                        throw new IllegalFormatWidthException(this.width);
                    }
                    if (this.f.valueOf() == Flags.NONE.valueOf()) break;
                    throw new IllegalFormatFlagsException(this.f.toString());
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        private void print(byte value, Locale l) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 256L) >= 0L) : v;
            this.print(v, l);
        }

        private void print(short value, Locale l) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 65536L) >= 0L) : v;
            this.print(v, l);
        }

        private void print(int value, Locale l) throws IOException {
            long v = value;
            if (value < 0 && (this.c == 'o' || this.c == 'x')) assert ((v += 0x100000000L) >= 0L) : v;
            this.print(v, l);
        }

        private void print(long value, Locale l) throws IOException {
            StringBuilder sb = new StringBuilder();
            if (this.c == 'd') {
                boolean neg = value < 0L;
                char[] va = value < 0L ? Long.toString(value, 10).substring(1).toCharArray() : Long.toString(value, 10).toCharArray();
                this.leadingSign(sb, neg);
                this.localizedMagnitude(sb, va, this.f, this.adjustWidth(this.width, this.f, neg), l);
                this.trailingSign(sb, neg);
            } else if (this.c == 'o') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = Long.toOctalString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 1 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - len; ++i) {
                        sb.append('0');
                    }
                }
                sb.append(s);
            } else if (this.c == 'x') {
                int len;
                this.checkBadFlags(Flags.PARENTHESES, Flags.LEADING_SPACE, Flags.PLUS);
                String s = Long.toHexString(value);
                int n = len = this.f.contains(Flags.ALTERNATE) ? s.length() + 2 : s.length();
                if (this.f.contains(Flags.ALTERNATE)) {
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - len; ++i) {
                        sb.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    s = s.toUpperCase();
                }
                sb.append(s);
            }
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private StringBuilder leadingSign(StringBuilder sb, boolean neg) {
            if (!neg) {
                if (this.f.contains(Flags.PLUS)) {
                    sb.append('+');
                } else if (this.f.contains(Flags.LEADING_SPACE)) {
                    sb.append(' ');
                }
            } else if (this.f.contains(Flags.PARENTHESES)) {
                sb.append('(');
            } else {
                sb.append('-');
            }
            return sb;
        }

        private StringBuilder trailingSign(StringBuilder sb, boolean neg) {
            if (neg && this.f.contains(Flags.PARENTHESES)) {
                sb.append(')');
            }
            return sb;
        }

        private void print(BigInteger value, Locale l) throws IOException {
            StringBuilder sb = new StringBuilder();
            boolean neg = value.signum() == -1;
            BigInteger v = value.abs();
            this.leadingSign(sb, neg);
            if (this.c == 'd') {
                char[] va = v.toString().toCharArray();
                this.localizedMagnitude(sb, va, this.f, this.adjustWidth(this.width, this.f, neg), l);
            } else if (this.c == 'o') {
                String s = v.toString(8);
                int len = s.length() + sb.length();
                if (neg && this.f.contains(Flags.PARENTHESES)) {
                    ++len;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    ++len;
                    sb.append('0');
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - len; ++i) {
                        sb.append('0');
                    }
                }
                sb.append(s);
            } else if (this.c == 'x') {
                String s = v.toString(16);
                int len = s.length() + sb.length();
                if (neg && this.f.contains(Flags.PARENTHESES)) {
                    ++len;
                }
                if (this.f.contains(Flags.ALTERNATE)) {
                    len += 2;
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "0X" : "0x");
                }
                if (this.f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - len; ++i) {
                        sb.append('0');
                    }
                }
                if (this.f.contains(Flags.UPPERCASE)) {
                    s = s.toUpperCase();
                }
                sb.append(s);
            }
            this.trailingSign(sb, value.signum() == -1);
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private void print(float value, Locale l) throws IOException {
            this.print((double)value, l);
        }

        private void print(double value, Locale l) throws IOException {
            boolean neg;
            StringBuilder sb = new StringBuilder();
            boolean bl = neg = Double.compare(value, 0.0) == -1;
            if (!Double.isNaN(value)) {
                double v = Math.abs(value);
                this.leadingSign(sb, neg);
                if (!Double.isInfinite(v)) {
                    this.print(sb, v, l, this.f, this.c, this.precision, neg);
                } else {
                    sb.append(this.f.contains(Flags.UPPERCASE) ? "INFINITY" : "Infinity");
                }
                this.trailingSign(sb, neg);
            } else {
                sb.append(this.f.contains(Flags.UPPERCASE) ? "NAN" : "NaN");
            }
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private void print(StringBuilder sb, double value, Locale l, Flags f, char c, int precision, boolean neg) throws IOException {
            if (c == 'e') {
                char[] cArray;
                int prec = precision == -1 ? 6 : precision;
                FormattedFloatingDecimal fd = FormattedFloatingDecimal.valueOf(value, prec, FormattedFloatingDecimal.Form.SCIENTIFIC);
                char[] mant = this.addZeros(fd.getMantissa(), prec);
                if (f.contains(Flags.ALTERNATE) && prec == 0) {
                    mant = this.addDot(mant);
                }
                if (value == 0.0) {
                    char[] cArray2 = new char[3];
                    cArray2[0] = 43;
                    cArray2[1] = 48;
                    cArray = cArray2;
                    cArray2[2] = 48;
                } else {
                    cArray = fd.getExponent();
                }
                char[] exp = cArray;
                int newW = this.width;
                if (this.width != -1) {
                    newW = this.adjustWidth(this.width - exp.length - 1, f, neg);
                }
                this.localizedMagnitude(sb, mant, f, newW, l);
                sb.append(f.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags = f.dup().remove(Flags.GROUP);
                char sign = exp[0];
                assert (sign == '+' || sign == '-');
                sb.append(sign);
                char[] tmp = new char[exp.length - 1];
                System.arraycopy(exp, 1, tmp, 0, exp.length - 1);
                sb.append((CharSequence)this.localizedMagnitude(null, tmp, flags, -1, l));
            } else if (c == 'f') {
                int prec = precision == -1 ? 6 : precision;
                FormattedFloatingDecimal fd = FormattedFloatingDecimal.valueOf(value, prec, FormattedFloatingDecimal.Form.DECIMAL_FLOAT);
                char[] mant = this.addZeros(fd.getMantissa(), prec);
                if (f.contains(Flags.ALTERNATE) && prec == 0) {
                    mant = this.addDot(mant);
                }
                int newW = this.width;
                if (this.width != -1) {
                    newW = this.adjustWidth(this.width, f, neg);
                }
                this.localizedMagnitude(sb, mant, f, newW, l);
            } else if (c == 'g') {
                int expRounded;
                char[] mant;
                char[] exp;
                int prec = precision;
                if (precision == -1) {
                    prec = 6;
                } else if (precision == 0) {
                    prec = 1;
                }
                if (value == 0.0) {
                    exp = null;
                    mant = new char[]{'0'};
                    expRounded = 0;
                } else {
                    FormattedFloatingDecimal fd = FormattedFloatingDecimal.valueOf(value, prec, FormattedFloatingDecimal.Form.GENERAL);
                    exp = fd.getExponent();
                    mant = fd.getMantissa();
                    expRounded = fd.getExponentRounded();
                }
                prec = exp != null ? --prec : (prec -= expRounded + 1);
                mant = this.addZeros(mant, prec);
                if (f.contains(Flags.ALTERNATE) && prec == 0) {
                    mant = this.addDot(mant);
                }
                int newW = this.width;
                if (this.width != -1) {
                    newW = exp != null ? this.adjustWidth(this.width - exp.length - 1, f, neg) : this.adjustWidth(this.width, f, neg);
                }
                this.localizedMagnitude(sb, mant, f, newW, l);
                if (exp != null) {
                    sb.append(f.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                    Flags flags = f.dup().remove(Flags.GROUP);
                    char sign = exp[0];
                    assert (sign == '+' || sign == '-');
                    sb.append(sign);
                    char[] tmp = new char[exp.length - 1];
                    System.arraycopy(exp, 1, tmp, 0, exp.length - 1);
                    sb.append((CharSequence)this.localizedMagnitude(null, tmp, flags, -1, l));
                }
            } else if (c == 'a') {
                int prec = precision;
                if (precision == -1) {
                    prec = 0;
                } else if (precision == 0) {
                    prec = 1;
                }
                String s = this.hexDouble(value, prec);
                boolean upper = f.contains(Flags.UPPERCASE);
                sb.append(upper ? "0X" : "0x");
                if (f.contains(Flags.ZERO_PAD)) {
                    for (int i = 0; i < this.width - s.length() - 2; ++i) {
                        sb.append('0');
                    }
                }
                int idx = s.indexOf(112);
                char[] va = s.substring(0, idx).toCharArray();
                if (upper) {
                    String tmp = new String(va);
                    tmp = tmp.toUpperCase(Locale.US);
                    va = tmp.toCharArray();
                }
                sb.append(prec != 0 ? this.addZeros(va, prec) : va);
                sb.append(upper ? (char)'P' : 'p');
                sb.append(s.substring(idx + 1));
            }
        }

        private char[] addZeros(char[] v, int prec) {
            int i;
            for (i = 0; i < v.length && v[i] != '.'; ++i) {
            }
            boolean needDot = false;
            if (i == v.length) {
                needDot = true;
            }
            int outPrec = v.length - i - (needDot ? 0 : 1);
            assert (outPrec <= prec);
            if (outPrec == prec) {
                return v;
            }
            char[] tmp = new char[v.length + prec - outPrec + (needDot ? 1 : 0)];
            System.arraycopy(v, 0, tmp, 0, v.length);
            int start = v.length;
            if (needDot) {
                tmp[v.length] = 46;
                ++start;
            }
            for (int j = start; j < tmp.length; ++j) {
                tmp[j] = 48;
            }
            return tmp;
        }

        private String hexDouble(double d, int prec) {
            long signBit;
            double result;
            boolean sticky;
            boolean subnormal;
            if (!Double.isFinite(d) || d == 0.0 || prec == 0 || prec >= 13) {
                return Double.toHexString(d).substring(2);
            }
            assert (prec >= 1 && prec <= 12);
            int exponent = Math.getExponent(d);
            boolean bl = subnormal = exponent == -1023;
            if (subnormal) {
                scaleUp = Math.scalb(1.0, 54);
                exponent = Math.getExponent(d *= scaleUp);
                assert (exponent >= -1022 && exponent <= 1023) : exponent;
            }
            int precision = 1 + prec * 4;
            int shiftDistance = 53 - precision;
            assert (shiftDistance >= 1 && shiftDistance < 53);
            long doppel = Double.doubleToLongBits(d);
            long newSignif = (doppel & Long.MAX_VALUE) >> shiftDistance;
            long roundingBits = doppel & (-1L << shiftDistance ^ 0xFFFFFFFFFFFFFFFFL);
            boolean leastZero = (newSignif & 1L) == 0L;
            boolean round = (1L << shiftDistance - 1 & roundingBits) != 0L;
            boolean bl2 = sticky = shiftDistance > 1 && ((1L << shiftDistance - 1 ^ 0xFFFFFFFFFFFFFFFFL) & roundingBits) != 0L;
            if (leastZero && round && sticky || !leastZero && round) {
                ++newSignif;
            }
            if (Double.isInfinite(result = Double.longBitsToDouble(newSignif = (signBit = doppel & Long.MIN_VALUE) | newSignif << shiftDistance))) {
                return "1.0p1024";
            }
            String res = Double.toHexString(result).substring(2);
            if (!subnormal) {
                return res;
            }
            int idx = res.indexOf(112);
            if (idx == -1) {
                assert (false);
                return null;
            }
            String exp = res.substring(idx + 1);
            int iexp = Integer.parseInt(exp) - 54;
            return res.substring(0, idx) + "p" + Integer.toString(iexp);
        }

        private void print(BigDecimal value, Locale l) throws IOException {
            if (this.c == 'a') {
                this.failConversion(this.c, value);
            }
            StringBuilder sb = new StringBuilder();
            boolean neg = value.signum() == -1;
            BigDecimal v = value.abs();
            this.leadingSign(sb, neg);
            this.print(sb, v, l, this.f, this.c, this.precision, neg);
            this.trailingSign(sb, neg);
            Formatter.this.a.append(this.justify(sb.toString()));
        }

        private void print(StringBuilder sb, BigDecimal value, Locale l, Flags f, char c, int precision, boolean neg) throws IOException {
            if (c == 'e') {
                int compPrec;
                int prec = precision == -1 ? 6 : precision;
                int scale = value.scale();
                int origPrec = value.precision();
                int nzeros = 0;
                if (prec > origPrec - 1) {
                    compPrec = origPrec;
                    nzeros = prec - (origPrec - 1);
                } else {
                    compPrec = prec + 1;
                }
                MathContext mc = new MathContext(compPrec);
                BigDecimal v = new BigDecimal(value.unscaledValue(), scale, mc);
                BigDecimalLayout bdl = new BigDecimalLayout(v.unscaledValue(), v.scale(), BigDecimalLayoutForm.SCIENTIFIC);
                char[] mant = bdl.mantissa();
                if (!(origPrec != 1 && bdl.hasDot() || nzeros <= 0 && !f.contains(Flags.ALTERNATE))) {
                    mant = this.addDot(mant);
                }
                mant = this.trailingZeros(mant, nzeros);
                char[] exp = bdl.exponent();
                int newW = this.width;
                if (this.width != -1) {
                    newW = this.adjustWidth(this.width - exp.length - 1, f, neg);
                }
                this.localizedMagnitude(sb, mant, f, newW, l);
                sb.append(f.contains(Flags.UPPERCASE) ? (char)'E' : 'e');
                Flags flags = f.dup().remove(Flags.GROUP);
                char sign = exp[0];
                assert (sign == '+' || sign == '-');
                sb.append(exp[0]);
                char[] tmp = new char[exp.length - 1];
                System.arraycopy(exp, 1, tmp, 0, exp.length - 1);
                sb.append((CharSequence)this.localizedMagnitude(null, tmp, flags, -1, l));
            } else if (c == 'f') {
                int nzeros;
                int prec = precision == -1 ? 6 : precision;
                int scale = value.scale();
                if (scale > prec) {
                    int compPrec = value.precision();
                    value = compPrec <= scale ? value.setScale(prec, RoundingMode.HALF_UP) : new BigDecimal(value.unscaledValue(), scale, new MathContext(compPrec -= scale - prec));
                }
                BigDecimalLayout bdl = new BigDecimalLayout(value.unscaledValue(), value.scale(), BigDecimalLayoutForm.DECIMAL_FLOAT);
                char[] mant = bdl.mantissa();
                int n = nzeros = bdl.scale() < prec ? prec - bdl.scale() : 0;
                if (bdl.scale() == 0 && (f.contains(Flags.ALTERNATE) || nzeros > 0)) {
                    mant = this.addDot(bdl.mantissa());
                }
                mant = this.trailingZeros(mant, nzeros);
                this.localizedMagnitude(sb, mant, f, this.adjustWidth(this.width, f, neg), l);
            } else if (c == 'g') {
                int prec = precision;
                if (precision == -1) {
                    prec = 6;
                } else if (precision == 0) {
                    prec = 1;
                }
                BigDecimal tenToTheNegFour = BigDecimal.valueOf(1L, 4);
                BigDecimal tenToThePrec = BigDecimal.valueOf(1L, -prec);
                if (value.equals(BigDecimal.ZERO) || value.compareTo(tenToTheNegFour) != -1 && value.compareTo(tenToThePrec) == -1) {
                    int e = -value.scale() + (value.unscaledValue().toString().length() - 1);
                    prec = prec - e - 1;
                    this.print(sb, value, l, f, 'f', prec, neg);
                } else {
                    this.print(sb, value, l, f, 'e', prec - 1, neg);
                }
            } else if (c == 'a') assert (false);
        }

        private int adjustWidth(int width, Flags f, boolean neg) {
            int newW = width;
            if (newW != -1 && neg && f.contains(Flags.PARENTHESES)) {
                --newW;
            }
            return newW;
        }

        private char[] addDot(char[] mant) {
            char[] tmp = mant;
            tmp = new char[mant.length + 1];
            System.arraycopy(mant, 0, tmp, 0, mant.length);
            tmp[tmp.length - 1] = 46;
            return tmp;
        }

        private char[] trailingZeros(char[] mant, int nzeros) {
            char[] tmp = mant;
            if (nzeros > 0) {
                tmp = new char[mant.length + nzeros];
                System.arraycopy(mant, 0, tmp, 0, mant.length);
                for (int i = mant.length; i < tmp.length; ++i) {
                    tmp[i] = 48;
                }
            }
            return tmp;
        }

        private void print(Calendar t, char c, Locale l) throws IOException {
            StringBuilder sb = new StringBuilder();
            this.print(sb, t, c, l);
            String s = this.justify(sb.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            Formatter.this.a.append(s);
        }

        private Appendable print(StringBuilder sb, Calendar t, char c, Locale l) throws IOException {
            if (sb == null) {
                sb = new StringBuilder();
            }
            switch (c) {
                case 'H': 
                case 'I': 
                case 'k': 
                case 'l': {
                    int i = t.get(11);
                    if (c == 'I' || c == 'l') {
                        i = i == 0 || i == 12 ? 12 : i % 12;
                    }
                    Flags flags = c == 'H' || c == 'I' ? Flags.ZERO_PAD : Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                    break;
                }
                case 'M': {
                    int i = t.get(12);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                    break;
                }
                case 'N': {
                    int i = t.get(14) * 1000000;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 9, l));
                    break;
                }
                case 'L': {
                    int i = t.get(14);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3, l));
                    break;
                }
                case 'Q': {
                    long i = t.getTimeInMillis();
                    Flags flags = Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width, l));
                    break;
                }
                case 'p': {
                    String[] ampm = new String[]{"AM", "PM"};
                    if (l != null && l != Locale.US) {
                        DateFormatSymbols dfs = DateFormatSymbols.getInstance(l);
                        ampm = dfs.getAmPmStrings();
                    }
                    String s = ampm[t.get(9)];
                    sb.append(s.toLowerCase(l != null ? l : Locale.US));
                    break;
                }
                case 's': {
                    long i = t.getTimeInMillis() / 1000L;
                    Flags flags = Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width, l));
                    break;
                }
                case 'S': {
                    int i = t.get(13);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                    break;
                }
                case 'z': {
                    int i = t.get(15) + t.get(16);
                    boolean neg = i < 0;
                    sb.append(neg ? (char)'-' : '+');
                    if (neg) {
                        i = -i;
                    }
                    int min = i / 60000;
                    int offset = min / 60 * 100 + min % 60;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, offset, flags, 4, l));
                    break;
                }
                case 'Z': {
                    TimeZone tz = t.getTimeZone();
                    sb.append(tz.getDisplayName(t.get(16) != 0, 0, l == null ? Locale.US : l));
                    break;
                }
                case 'A': 
                case 'a': {
                    int i = t.get(7);
                    Locale lt = l == null ? Locale.US : l;
                    DateFormatSymbols dfs = DateFormatSymbols.getInstance(lt);
                    if (c == 'A') {
                        sb.append(dfs.getWeekdays()[i]);
                        break;
                    }
                    sb.append(dfs.getShortWeekdays()[i]);
                    break;
                }
                case 'B': 
                case 'b': 
                case 'h': {
                    int i = t.get(2);
                    Locale lt = l == null ? Locale.US : l;
                    DateFormatSymbols dfs = DateFormatSymbols.getInstance(lt);
                    if (c == 'B') {
                        sb.append(dfs.getMonths()[i]);
                        break;
                    }
                    sb.append(dfs.getShortMonths()[i]);
                    break;
                }
                case 'C': 
                case 'Y': 
                case 'y': {
                    int i = t.get(1);
                    int size = 2;
                    switch (c) {
                        case 'C': {
                            i /= 100;
                            break;
                        }
                        case 'y': {
                            i %= 100;
                            break;
                        }
                        case 'Y': {
                            size = 4;
                        }
                    }
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, size, l));
                    break;
                }
                case 'd': 
                case 'e': {
                    int i = t.get(5);
                    Flags flags = c == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                    break;
                }
                case 'j': {
                    int i = t.get(6);
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3, l));
                    break;
                }
                case 'm': {
                    int i = t.get(2) + 1;
                    Flags flags = Flags.ZERO_PAD;
                    sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                    break;
                }
                case 'R': 
                case 'T': {
                    char sep = ':';
                    this.print(sb, t, 'H', l).append(sep);
                    this.print(sb, t, 'M', l);
                    if (c != 'T') break;
                    sb.append(sep);
                    this.print(sb, t, 'S', l);
                    break;
                }
                case 'r': {
                    char sep = ':';
                    this.print(sb, t, 'I', l).append(sep);
                    this.print(sb, t, 'M', l).append(sep);
                    this.print(sb, t, 'S', l).append(' ');
                    StringBuilder tsb = new StringBuilder();
                    this.print(tsb, t, 'p', l);
                    sb.append(tsb.toString().toUpperCase(l != null ? l : Locale.US));
                    break;
                }
                case 'c': {
                    char sep = ' ';
                    this.print(sb, t, 'a', l).append(sep);
                    this.print(sb, t, 'b', l).append(sep);
                    this.print(sb, t, 'd', l).append(sep);
                    this.print(sb, t, 'T', l).append(sep);
                    this.print(sb, t, 'Z', l).append(sep);
                    this.print(sb, t, 'Y', l);
                    break;
                }
                case 'D': {
                    char sep = '/';
                    this.print(sb, t, 'm', l).append(sep);
                    this.print(sb, t, 'd', l).append(sep);
                    this.print(sb, t, 'y', l);
                    break;
                }
                case 'F': {
                    char sep = '-';
                    this.print(sb, t, 'Y', l).append(sep);
                    this.print(sb, t, 'm', l).append(sep);
                    this.print(sb, t, 'd', l);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            return sb;
        }

        private void print(TemporalAccessor t, char c, Locale l) throws IOException {
            StringBuilder sb = new StringBuilder();
            this.print(sb, t, c, l);
            String s = this.justify(sb.toString());
            if (this.f.contains(Flags.UPPERCASE)) {
                s = s.toUpperCase();
            }
            Formatter.this.a.append(s);
        }

        private Appendable print(StringBuilder sb, TemporalAccessor t, char c, Locale l) throws IOException {
            if (sb == null) {
                sb = new StringBuilder();
            }
            try {
                switch (c) {
                    case 'H': {
                        int i = t.get(ChronoField.HOUR_OF_DAY);
                        sb.append((CharSequence)this.localizedMagnitude(null, i, Flags.ZERO_PAD, 2, l));
                        break;
                    }
                    case 'k': {
                        int i = t.get(ChronoField.HOUR_OF_DAY);
                        sb.append((CharSequence)this.localizedMagnitude(null, i, Flags.NONE, 2, l));
                        break;
                    }
                    case 'I': {
                        int i = t.get(ChronoField.CLOCK_HOUR_OF_AMPM);
                        sb.append((CharSequence)this.localizedMagnitude(null, i, Flags.ZERO_PAD, 2, l));
                        break;
                    }
                    case 'l': {
                        int i = t.get(ChronoField.CLOCK_HOUR_OF_AMPM);
                        sb.append((CharSequence)this.localizedMagnitude(null, i, Flags.NONE, 2, l));
                        break;
                    }
                    case 'M': {
                        int i = t.get(ChronoField.MINUTE_OF_HOUR);
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                        break;
                    }
                    case 'N': {
                        int i = t.get(ChronoField.MILLI_OF_SECOND) * 1000000;
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 9, l));
                        break;
                    }
                    case 'L': {
                        int i = t.get(ChronoField.MILLI_OF_SECOND);
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3, l));
                        break;
                    }
                    case 'Q': {
                        long i = t.getLong(ChronoField.INSTANT_SECONDS) * 1000L + t.getLong(ChronoField.MILLI_OF_SECOND);
                        Flags flags = Flags.NONE;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width, l));
                        break;
                    }
                    case 'p': {
                        String[] ampm = new String[]{"AM", "PM"};
                        if (l != null && l != Locale.US) {
                            DateFormatSymbols dfs = DateFormatSymbols.getInstance(l);
                            ampm = dfs.getAmPmStrings();
                        }
                        String s = ampm[t.get(ChronoField.AMPM_OF_DAY)];
                        sb.append(s.toLowerCase(l != null ? l : Locale.US));
                        break;
                    }
                    case 's': {
                        long i = t.getLong(ChronoField.INSTANT_SECONDS);
                        Flags flags = Flags.NONE;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, this.width, l));
                        break;
                    }
                    case 'S': {
                        int i = t.get(ChronoField.SECOND_OF_MINUTE);
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                        break;
                    }
                    case 'z': {
                        int i = t.get(ChronoField.OFFSET_SECONDS);
                        boolean neg = i < 0;
                        sb.append(neg ? (char)'-' : '+');
                        if (neg) {
                            i = -i;
                        }
                        int min = i / 60;
                        int offset = min / 60 * 100 + min % 60;
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, offset, flags, 4, l));
                        break;
                    }
                    case 'Z': {
                        ZoneId zid = t.query(TemporalQueries.zone());
                        if (zid == null) {
                            throw new IllegalFormatConversionException(c, t.getClass());
                        }
                        if (!(zid instanceof ZoneOffset) && t.isSupported(ChronoField.INSTANT_SECONDS)) {
                            Instant instant = Instant.from(t);
                            sb.append(TimeZone.getTimeZone(zid.getId()).getDisplayName(zid.getRules().isDaylightSavings(instant), 0, l == null ? Locale.US : l));
                            break;
                        }
                        sb.append(zid.getId());
                        break;
                    }
                    case 'A': 
                    case 'a': {
                        int i = t.get(ChronoField.DAY_OF_WEEK) % 7 + 1;
                        Locale lt = l == null ? Locale.US : l;
                        DateFormatSymbols dfs = DateFormatSymbols.getInstance(lt);
                        if (c == 'A') {
                            sb.append(dfs.getWeekdays()[i]);
                            break;
                        }
                        sb.append(dfs.getShortWeekdays()[i]);
                        break;
                    }
                    case 'B': 
                    case 'b': 
                    case 'h': {
                        int i = t.get(ChronoField.MONTH_OF_YEAR) - 1;
                        Locale lt = l == null ? Locale.US : l;
                        DateFormatSymbols dfs = DateFormatSymbols.getInstance(lt);
                        if (c == 'B') {
                            sb.append(dfs.getMonths()[i]);
                            break;
                        }
                        sb.append(dfs.getShortMonths()[i]);
                        break;
                    }
                    case 'C': 
                    case 'Y': 
                    case 'y': {
                        int i = t.get(ChronoField.YEAR_OF_ERA);
                        int size = 2;
                        switch (c) {
                            case 'C': {
                                i /= 100;
                                break;
                            }
                            case 'y': {
                                i %= 100;
                                break;
                            }
                            case 'Y': {
                                size = 4;
                            }
                        }
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, size, l));
                        break;
                    }
                    case 'd': 
                    case 'e': {
                        int i = t.get(ChronoField.DAY_OF_MONTH);
                        Flags flags = c == 'd' ? Flags.ZERO_PAD : Flags.NONE;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                        break;
                    }
                    case 'j': {
                        int i = t.get(ChronoField.DAY_OF_YEAR);
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 3, l));
                        break;
                    }
                    case 'm': {
                        int i = t.get(ChronoField.MONTH_OF_YEAR);
                        Flags flags = Flags.ZERO_PAD;
                        sb.append((CharSequence)this.localizedMagnitude(null, i, flags, 2, l));
                        break;
                    }
                    case 'R': 
                    case 'T': {
                        char sep = ':';
                        this.print(sb, t, 'H', l).append(sep);
                        this.print(sb, t, 'M', l);
                        if (c == 'T') {
                            sb.append(sep);
                            this.print(sb, t, 'S', l);
                        }
                        break;
                    }
                    case 'r': {
                        char sep = ':';
                        this.print(sb, t, 'I', l).append(sep);
                        this.print(sb, t, 'M', l).append(sep);
                        this.print(sb, t, 'S', l).append(' ');
                        StringBuilder tsb = new StringBuilder();
                        this.print(tsb, t, 'p', l);
                        sb.append(tsb.toString().toUpperCase(l != null ? l : Locale.US));
                        break;
                    }
                    case 'c': {
                        char sep = ' ';
                        this.print(sb, t, 'a', l).append(sep);
                        this.print(sb, t, 'b', l).append(sep);
                        this.print(sb, t, 'd', l).append(sep);
                        this.print(sb, t, 'T', l).append(sep);
                        this.print(sb, t, 'Z', l).append(sep);
                        this.print(sb, t, 'Y', l);
                        break;
                    }
                    case 'D': {
                        char sep = '/';
                        this.print(sb, t, 'm', l).append(sep);
                        this.print(sb, t, 'd', l).append(sep);
                        this.print(sb, t, 'y', l);
                        break;
                    }
                    case 'F': {
                        char sep = '-';
                        this.print(sb, t, 'Y', l).append(sep);
                        this.print(sb, t, 'm', l).append(sep);
                        this.print(sb, t, 'd', l);
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            catch (DateTimeException x) {
                throw new IllegalFormatConversionException(c, t.getClass());
            }
            return sb;
        }

        private void failMismatch(Flags f, char c) {
            String fs = f.toString();
            throw new FormatFlagsConversionMismatchException(fs, c);
        }

        private void failConversion(char c, Object arg) {
            throw new IllegalFormatConversionException(c, arg.getClass());
        }

        private char getZero(Locale l) {
            if (l != null && !l.equals(Formatter.this.locale())) {
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(l);
                return dfs.getZeroDigit();
            }
            return Formatter.this.zero;
        }

        private StringBuilder localizedMagnitude(StringBuilder sb, long value, Flags f, int width, Locale l) {
            char[] va = Long.toString(value, 10).toCharArray();
            return this.localizedMagnitude(sb, va, f, width, l);
        }

        private StringBuilder localizedMagnitude(StringBuilder sb, char[] value, Flags f, int width, Locale l) {
            int j;
            int len;
            if (sb == null) {
                sb = new StringBuilder();
            }
            int begin = sb.length();
            char zero = this.getZero(l);
            char grpSep = '\u0000';
            int grpSize = -1;
            char decSep = '\u0000';
            int dot = len = value.length;
            for (j = 0; j < len; ++j) {
                if (value[j] != '.') continue;
                dot = j;
                break;
            }
            if (dot < len) {
                if (l == null || l.equals(Locale.US)) {
                    decSep = '.';
                } else {
                    DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(l);
                    decSep = dfs.getDecimalSeparator();
                }
            }
            if (f.contains(Flags.GROUP)) {
                if (l == null || l.equals(Locale.US)) {
                    grpSep = ',';
                    grpSize = 3;
                } else {
                    DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(l);
                    grpSep = dfs.getGroupingSeparator();
                    DecimalFormat df = (DecimalFormat)NumberFormat.getIntegerInstance(l);
                    grpSize = df.getGroupingSize();
                }
            }
            for (j = 0; j < len; ++j) {
                if (j == dot) {
                    sb.append(decSep);
                    grpSep = '\u0000';
                    continue;
                }
                char c = value[j];
                sb.append((char)(c - 48 + zero));
                if (grpSep == '\u0000' || j == dot - 1 || (dot - j) % grpSize != 1) continue;
                sb.append(grpSep);
            }
            len = sb.length();
            if (width > len && f.contains(Flags.ZERO_PAD)) {
                char[] zeros = new char[width - len];
                Arrays.fill(zeros, zero);
                sb.insert(begin, zeros);
            }
            return sb;
        }

        private class BigDecimalLayout {
            private StringBuilder mant;
            private StringBuilder exp;
            private boolean dot = false;
            private int scale;

            public BigDecimalLayout(BigInteger intVal, int scale, BigDecimalLayoutForm form) {
                this.layout(intVal, scale, form);
            }

            public boolean hasDot() {
                return this.dot;
            }

            public int scale() {
                return this.scale;
            }

            public char[] layoutChars() {
                StringBuilder sb = new StringBuilder(this.mant);
                if (this.exp != null) {
                    sb.append('E');
                    sb.append((CharSequence)this.exp);
                }
                return this.toCharArray(sb);
            }

            public char[] mantissa() {
                return this.toCharArray(this.mant);
            }

            public char[] exponent() {
                return this.toCharArray(this.exp);
            }

            private char[] toCharArray(StringBuilder sb) {
                if (sb == null) {
                    return null;
                }
                char[] result = new char[sb.length()];
                sb.getChars(0, result.length, result, 0);
                return result;
            }

            private void layout(BigInteger intVal, int scale, BigDecimalLayoutForm form) {
                char[] coeff = intVal.toString().toCharArray();
                this.scale = scale;
                this.mant = new StringBuilder(coeff.length + 14);
                if (scale == 0) {
                    int len = coeff.length;
                    if (len > 1) {
                        this.mant.append(coeff[0]);
                        if (form == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.mant.append('.');
                            this.dot = true;
                            this.mant.append(coeff, 1, len - 1);
                            this.exp = new StringBuilder("+");
                            if (len < 10) {
                                this.exp.append("0").append(len - 1);
                            } else {
                                this.exp.append(len - 1);
                            }
                        } else {
                            this.mant.append(coeff, 1, len - 1);
                        }
                    } else {
                        this.mant.append(coeff);
                        if (form == BigDecimalLayoutForm.SCIENTIFIC) {
                            this.exp = new StringBuilder("+00");
                        }
                    }
                    return;
                }
                long adjusted = -((long)scale) + (long)(coeff.length - 1);
                if (form == BigDecimalLayoutForm.DECIMAL_FLOAT) {
                    int pad = scale - coeff.length;
                    if (pad >= 0) {
                        this.mant.append("0.");
                        this.dot = true;
                        while (pad > 0) {
                            this.mant.append('0');
                            --pad;
                        }
                        this.mant.append(coeff);
                    } else if (-pad < coeff.length) {
                        this.mant.append(coeff, 0, -pad);
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(coeff, -pad, scale);
                    } else {
                        this.mant.append(coeff, 0, coeff.length);
                        for (int i = 0; i < -scale; ++i) {
                            this.mant.append('0');
                        }
                        this.scale = 0;
                    }
                } else {
                    this.mant.append(coeff[0]);
                    if (coeff.length > 1) {
                        this.mant.append('.');
                        this.dot = true;
                        this.mant.append(coeff, 1, coeff.length - 1);
                    }
                    this.exp = new StringBuilder();
                    if (adjusted != 0L) {
                        long abs = Math.abs(adjusted);
                        this.exp.append(adjusted < 0L ? (char)'-' : '+');
                        if (abs < 10L) {
                            this.exp.append('0');
                        }
                        this.exp.append(abs);
                    } else {
                        this.exp.append("+00");
                    }
                }
            }
        }
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }

    private class FixedString
    implements FormatString {
        private String s;

        FixedString(String s) {
            this.s = s;
        }

        @Override
        public int index() {
            return -2;
        }

        @Override
        public void print(Object arg, Locale l) throws IOException {
            Formatter.this.a.append(this.s);
        }

        @Override
        public String toString() {
            return this.s;
        }
    }

    private static interface FormatString {
        public int index();

        public void print(Object var1, Locale var2) throws IOException;

        public String toString();
    }
}

