/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;

public class AtomicReferenceArray<E>
implements Serializable {
    private static final long serialVersionUID = -6209656149925076980L;
    private static final Unsafe unsafe;
    private static final int base;
    private static final int shift;
    private static final long arrayFieldOffset;
    private final Object[] array;

    private long checkedByteOffset(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException("index " + i);
        }
        return AtomicReferenceArray.byteOffset(i);
    }

    private static long byteOffset(int i) {
        return ((long)i << shift) + (long)base;
    }

    public AtomicReferenceArray(int length) {
        this.array = new Object[length];
    }

    public AtomicReferenceArray(E[] array) {
        this.array = Arrays.copyOf(array, array.length, Object[].class);
    }

    public final int length() {
        return this.array.length;
    }

    public final E get(int i) {
        return this.getRaw(this.checkedByteOffset(i));
    }

    private E getRaw(long offset) {
        return (E)unsafe.getObjectVolatile(this.array, offset);
    }

    public final void set(int i, E newValue) {
        unsafe.putObjectVolatile(this.array, this.checkedByteOffset(i), newValue);
    }

    public final void lazySet(int i, E newValue) {
        unsafe.putOrderedObject(this.array, this.checkedByteOffset(i), newValue);
    }

    public final E getAndSet(int i, E newValue) {
        return (E)unsafe.getAndSetObject(this.array, this.checkedByteOffset(i), newValue);
    }

    public final boolean compareAndSet(int i, E expect, E update) {
        return this.compareAndSetRaw(this.checkedByteOffset(i), expect, update);
    }

    private boolean compareAndSetRaw(long offset, E expect, E update) {
        return unsafe.compareAndSwapObject(this.array, offset, expect, update);
    }

    public final boolean weakCompareAndSet(int i, E expect, E update) {
        return this.compareAndSet(i, expect, update);
    }

    public final E getAndUpdate(int i, UnaryOperator<E> updateFunction) {
        Object next;
        E prev;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, prev = this.getRaw(offset), next = updateFunction.apply(prev))) {
        }
        return prev;
    }

    public final E updateAndGet(int i, UnaryOperator<E> updateFunction) {
        Object next;
        E prev;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, prev = this.getRaw(offset), next = updateFunction.apply(prev))) {
        }
        return (E)next;
    }

    public final E getAndAccumulate(int i, E x, BinaryOperator<E> accumulatorFunction) {
        Object next;
        E prev;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, prev = this.getRaw(offset), next = accumulatorFunction.apply(prev, x))) {
        }
        return prev;
    }

    public final E accumulateAndGet(int i, E x, BinaryOperator<E> accumulatorFunction) {
        Object next;
        E prev;
        long offset = this.checkedByteOffset(i);
        while (!this.compareAndSetRaw(offset, prev = this.getRaw(offset), next = accumulatorFunction.apply(prev, x))) {
        }
        return (E)next;
    }

    public String toString() {
        int iMax = this.array.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.getRaw(AtomicReferenceArray.byteOffset(i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException, InvalidObjectException {
        T[] a = s.readFields().get("array", null);
        if (a == null || !a.getClass().isArray()) {
            throw new InvalidObjectException("Not array type");
        }
        if (a.getClass() != Object[].class) {
            a = Arrays.copyOf((Object[])a, Array.getLength(a), Object[].class);
        }
        unsafe.putObjectVolatile(this, arrayFieldOffset, a);
    }

    static {
        try {
            unsafe = Unsafe.getUnsafe();
            arrayFieldOffset = unsafe.objectFieldOffset(AtomicReferenceArray.class.getDeclaredField("array"));
            base = unsafe.arrayBaseOffset(Object[].class);
            int scale = unsafe.arrayIndexScale(Object[].class);
            if ((scale & scale - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            shift = 31 - Integer.numberOfLeadingZeros(scale);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }
}

