/*
 * Decompiled with CFR 0.152.
 */
package sun.net.ftp.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.TelnetInputStream;
import sun.net.TelnetOutputStream;
import sun.net.ftp.FtpClient;
import sun.net.ftp.FtpDirEntry;
import sun.net.ftp.FtpDirParser;
import sun.net.ftp.FtpProtocolException;
import sun.net.ftp.FtpReplyCode;
import sun.net.util.IPAddressUtil;
import sun.net.util.ProxyUtil;
import sun.util.logging.PlatformLogger;

public class FtpClient
extends sun.net.ftp.FtpClient {
    private static int defaultSoTimeout;
    private static int defaultConnectTimeout;
    private static final PlatformLogger logger;
    private Proxy proxy;
    private Socket server;
    private PrintStream out;
    private InputStream in;
    private int readTimeout = -1;
    private int connectTimeout = -1;
    private static String encoding;
    private InetSocketAddress serverAddr;
    private boolean replyPending = false;
    private boolean loggedIn = false;
    private boolean useCrypto = false;
    private SSLSocketFactory sslFact;
    private Socket oldSocket;
    private Vector<String> serverResponse = new Vector(1);
    private FtpReplyCode lastReplyCode = null;
    private String welcomeMsg;
    private final boolean passiveMode = true;
    private FtpClient.TransferType type = FtpClient.TransferType.BINARY;
    private long restartOffset = 0L;
    private long lastTransSize = -1L;
    private String lastFileName;
    private static String[] patStrings;
    private static int[][] patternGroups;
    private static Pattern[] patterns;
    private static Pattern linkp;
    private DateFormat df = DateFormat.getDateInstance(2, Locale.US);
    private static final boolean acceptPasvAddressVal;
    private FtpDirParser parser = new DefaultParser();
    private FtpDirParser mlsxParser = new MLSxParser();
    private static Pattern transPat;
    private static Pattern epsvPat;
    private static Pattern pasvPat;
    static final String ERROR_MSG = "Address should be the same as originating server";
    private static String[] MDTMformats;
    private static SimpleDateFormat[] dateFormats;

    private static boolean isASCIISuperset(String encoding) throws Exception {
        String chkS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'();/?:@&=+$,";
        byte[] chkB = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 45, 95, 46, 33, 126, 42, 39, 40, 41, 59, 47, 63, 58, 64, 38, 61, 43, 36, 44};
        byte[] b = chkS.getBytes(encoding);
        return Arrays.equals(b, chkB);
    }

    private void getTransferSize() {
        Matcher m;
        this.lastTransSize = -1L;
        String response = this.getLastResponseString();
        if (transPat == null) {
            transPat = Pattern.compile("150 Opening .*\\((\\d+) bytes\\).");
        }
        if ((m = transPat.matcher(response)).find()) {
            String s = m.group(1);
            this.lastTransSize = Long.parseLong(s);
        }
    }

    private void getTransferName() {
        this.lastFileName = null;
        String response = this.getLastResponseString();
        int i = response.indexOf("unique file name:");
        int e = response.lastIndexOf(41);
        if (i >= 0) {
            this.lastFileName = response.substring(i += 17, e);
        }
    }

    private int readServerResponse() throws IOException {
        int code;
        StringBuffer replyBuf = new StringBuffer(32);
        int continuingCode = -1;
        this.serverResponse.setSize(0);
        while (true) {
            int c;
            if ((c = this.in.read()) != -1) {
                if (c == 13 && (c = this.in.read()) != 10) {
                    replyBuf.append('\r');
                }
                replyBuf.append((char)c);
                if (c != 10) continue;
            }
            String response = replyBuf.toString();
            replyBuf.setLength(0);
            if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
                logger.finest("Server [" + this.serverAddr + "] --> " + response);
            }
            if (response.length() == 0) {
                code = -1;
            } else {
                try {
                    code = Integer.parseInt(response.substring(0, 3));
                }
                catch (NumberFormatException e) {
                    code = -1;
                }
                catch (StringIndexOutOfBoundsException e) {
                    continue;
                }
            }
            this.serverResponse.addElement(response);
            if (continuingCode != -1) {
                if (code != continuingCode || response.length() >= 4 && response.charAt(3) == '-') continue;
                continuingCode = -1;
                break;
            }
            if (response.length() < 4 || response.charAt(3) != '-') break;
            continuingCode = code;
        }
        return code;
    }

    private void sendServer(String cmd) {
        this.out.print(cmd);
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("Server [" + this.serverAddr + "] <-- " + cmd);
        }
    }

    private String getResponseString() {
        return this.serverResponse.elementAt(0);
    }

    private Vector<String> getResponseStrings() {
        return this.serverResponse;
    }

    private boolean readReply() throws IOException {
        this.lastReplyCode = FtpReplyCode.find(this.readServerResponse());
        if (this.lastReplyCode.isPositivePreliminary()) {
            this.replyPending = true;
            return true;
        }
        if (this.lastReplyCode.isPositiveCompletion() || this.lastReplyCode.isPositiveIntermediate()) {
            if (this.lastReplyCode == FtpReplyCode.CLOSING_DATA_CONNECTION) {
                this.getTransferName();
            }
            return true;
        }
        return false;
    }

    private boolean issueCommand(String cmd) throws IOException, FtpProtocolException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        if (this.replyPending) {
            try {
                this.completePending();
            }
            catch (FtpProtocolException ftpProtocolException) {
                // empty catch block
            }
        }
        if (cmd.indexOf(10) != -1) {
            FtpProtocolException ex = new FtpProtocolException("Illegal FTP command");
            ex.initCause(new IllegalArgumentException("Illegal carriage return"));
            throw ex;
        }
        this.sendServer(cmd + "\r\n");
        return this.readReply();
    }

    private void issueCommandCheck(String cmd) throws FtpProtocolException, IOException {
        if (!this.issueCommand(cmd)) {
            throw new FtpProtocolException(cmd + ":" + this.getResponseString(), this.getLastReplyCode());
        }
    }

    private Socket openPassiveDataConnection(String cmd) throws FtpProtocolException, IOException {
        String s;
        Matcher m;
        InetSocketAddress dest = null;
        if (this.issueCommand("EPSV ALL")) {
            this.issueCommandCheck("EPSV");
            String serverAnswer = this.getResponseString();
            if (epsvPat == null) {
                epsvPat = Pattern.compile("^229 .* \\(\\|\\|\\|(\\d+)\\|\\)");
            }
            if (!(m = epsvPat.matcher(serverAnswer)).find()) {
                throw new FtpProtocolException("EPSV failed : " + serverAnswer);
            }
            s = m.group(1);
            int port = Integer.parseInt(s);
            InetAddress add = this.server.getInetAddress();
            dest = add != null ? new InetSocketAddress(add, port) : InetSocketAddress.createUnresolved(this.serverAddr.getHostName(), port);
        } else {
            this.issueCommandCheck("PASV");
            String serverAnswer = this.getResponseString();
            if (pasvPat == null) {
                pasvPat = Pattern.compile("227 .* \\(?(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})\\)?");
            }
            if (!(m = pasvPat.matcher(serverAnswer)).find()) {
                throw new FtpProtocolException("PASV failed : " + serverAnswer);
            }
            int port = Integer.parseInt(m.group(3)) + (Integer.parseInt(m.group(2)) << 8);
            s = m.group(1).replace(',', '.');
            if (!IPAddressUtil.isIPv4LiteralAddress(s)) {
                throw new FtpProtocolException("PASV failed : " + serverAnswer);
            }
            dest = acceptPasvAddressVal ? new InetSocketAddress(s, port) : this.validatePasvAddress(port, s, this.server.getInetAddress());
        }
        Socket s2 = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? AccessController.doPrivileged(new PrivilegedAction<Socket>(){

            @Override
            public Socket run() {
                return new Socket(FtpClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        InetAddress serverAddress = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

            @Override
            public InetAddress run() {
                return FtpClient.this.server.getLocalAddress();
            }
        });
        s2.bind(new InetSocketAddress(serverAddress, 0));
        if (this.connectTimeout >= 0) {
            s2.connect(dest, this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            s2.connect(dest, defaultConnectTimeout);
        } else {
            s2.connect(dest);
        }
        if (this.readTimeout >= 0) {
            s2.setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            s2.setSoTimeout(defaultSoTimeout);
        }
        if (this.useCrypto) {
            try {
                s2 = this.sslFact.createSocket(s2, dest.getHostName(), dest.getPort(), true);
            }
            catch (Exception e) {
                throw new FtpProtocolException("Can't open secure data channel: " + e);
            }
        }
        if (!this.issueCommand(cmd)) {
            s2.close();
            if (this.getLastReplyCode() == FtpReplyCode.FILE_UNAVAILABLE) {
                throw new FileNotFoundException(cmd);
            }
            throw new FtpProtocolException(cmd + ":" + this.getResponseString(), this.getLastReplyCode());
        }
        return s2;
    }

    private InetSocketAddress validatePasvAddress(int port, String s, InetAddress address) throws FtpProtocolException {
        if (address == null) {
            return InetSocketAddress.createUnresolved(this.serverAddr.getHostName(), port);
        }
        String serverAddress = address.getHostAddress();
        if (serverAddress.equals(s)) {
            return new InetSocketAddress(s, port);
        }
        if (address.isLoopbackAddress() && s.startsWith("127.")) {
            return new InetSocketAddress(s, port);
        }
        if (address.isLoopbackAddress()) {
            if (FtpClient.privilegedLocalHost().getHostAddress().equals(s)) {
                return new InetSocketAddress(s, port);
            }
            throw new FtpProtocolException(ERROR_MSG);
        }
        if (s.startsWith("127.")) {
            if (FtpClient.privilegedLocalHost().equals(address)) {
                return new InetSocketAddress(s, port);
            }
            throw new FtpProtocolException(ERROR_MSG);
        }
        String hostName = address.getHostName();
        if (!IPAddressUtil.isIPv4LiteralAddress(hostName) && !IPAddressUtil.isIPv6LiteralAddress(hostName)) {
            InetAddress[] names = FtpClient.privilegedGetAllByName(hostName);
            String resAddress = Arrays.stream(names).map(InetAddress::getHostAddress).filter(s::equalsIgnoreCase).findFirst().orElse(null);
            if (resAddress != null) {
                return new InetSocketAddress(s, port);
            }
        }
        throw new FtpProtocolException(ERROR_MSG);
    }

    private static InetAddress privilegedLocalHost() throws FtpProtocolException {
        PrivilegedExceptionAction<InetAddress> action = InetAddress::getLocalHost;
        try {
            return AccessController.doPrivileged(action);
        }
        catch (Exception e) {
            FtpProtocolException ftpEx = new FtpProtocolException(ERROR_MSG);
            ftpEx.initCause(e);
            throw ftpEx;
        }
    }

    private static InetAddress[] privilegedGetAllByName(String hostName) throws FtpProtocolException {
        PrivilegedExceptionAction<InetAddress[]> pAction = () -> InetAddress.getAllByName(hostName);
        try {
            return AccessController.doPrivileged(pAction);
        }
        catch (Exception e) {
            FtpProtocolException ftpEx = new FtpProtocolException(ERROR_MSG);
            ftpEx.initCause(e);
            throw ftpEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket openDataConnection(String cmd) throws FtpProtocolException, IOException {
        try {
            return this.openPassiveDataConnection(cmd);
        }
        catch (FtpProtocolException e) {
            Socket clientSocket;
            String errmsg = e.getMessage();
            if (!errmsg.startsWith("PASV") && !errmsg.startsWith("EPSV")) {
                throw e;
            }
            if (this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS) {
                throw new FtpProtocolException("Passive mode failed");
            }
            try (ServerSocket portSocket = new ServerSocket(0, 1, this.server.getLocalAddress());){
                String portCmd;
                InetAddress myAddress = portSocket.getInetAddress();
                if (myAddress.isAnyLocalAddress()) {
                    myAddress = this.server.getLocalAddress();
                }
                if (!this.issueCommand(portCmd = "EPRT |" + (myAddress instanceof Inet6Address ? "2" : "1") + "|" + myAddress.getHostAddress() + "|" + portSocket.getLocalPort() + "|") || !this.issueCommand(cmd)) {
                    portCmd = "PORT ";
                    byte[] addr = myAddress.getAddress();
                    for (int i = 0; i < addr.length; ++i) {
                        portCmd = portCmd + (addr[i] & 0xFF) + ",";
                    }
                    portCmd = portCmd + (portSocket.getLocalPort() >>> 8 & 0xFF) + "," + (portSocket.getLocalPort() & 0xFF);
                    this.issueCommandCheck(portCmd);
                    this.issueCommandCheck(cmd);
                }
                if (this.connectTimeout >= 0) {
                    portSocket.setSoTimeout(this.connectTimeout);
                } else if (defaultConnectTimeout > 0) {
                    portSocket.setSoTimeout(defaultConnectTimeout);
                }
                clientSocket = portSocket.accept();
                if (this.readTimeout >= 0) {
                    clientSocket.setSoTimeout(this.readTimeout);
                } else if (defaultSoTimeout > 0) {
                    clientSocket.setSoTimeout(defaultSoTimeout);
                }
            }
            if (this.useCrypto) {
                try {
                    clientSocket = this.sslFact.createSocket(clientSocket, this.serverAddr.getHostName(), this.serverAddr.getPort(), true);
                }
                catch (Exception ex) {
                    throw new IOException(ex.getLocalizedMessage());
                }
            }
            return clientSocket;
        }
    }

    private InputStream createInputStream(InputStream in) {
        if (this.type == FtpClient.TransferType.ASCII) {
            return new TelnetInputStream(in, false);
        }
        return in;
    }

    private OutputStream createOutputStream(OutputStream out) {
        if (this.type == FtpClient.TransferType.ASCII) {
            return new TelnetOutputStream(out, false);
        }
        return out;
    }

    protected FtpClient() {
    }

    public static sun.net.ftp.FtpClient create() {
        return new FtpClient();
    }

    @Override
    public sun.net.ftp.FtpClient enablePassiveMode(boolean passive) {
        return this;
    }

    @Override
    public boolean isPassiveModeEnabled() {
        return true;
    }

    @Override
    public sun.net.ftp.FtpClient setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public sun.net.ftp.FtpClient setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public sun.net.ftp.FtpClient setProxy(Proxy p) {
        this.proxy = ProxyUtil.copyProxy(p);
        return this;
    }

    @Override
    public Proxy getProxy() {
        return this.proxy;
    }

    private void tryConnect(InetSocketAddress dest, int timeout) throws IOException {
        if (this.isConnected()) {
            this.disconnect();
        }
        this.server = this.doConnect(dest, timeout);
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + "encoding not found", e);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
    }

    private Socket doConnect(InetSocketAddress dest, int timeout) throws IOException {
        Socket s = this.proxy != null ? (this.proxy.type() == Proxy.Type.SOCKS ? AccessController.doPrivileged(new PrivilegedAction<Socket>(){

            @Override
            public Socket run() {
                return new Socket(FtpClient.this.proxy);
            }
        }) : new Socket(Proxy.NO_PROXY)) : new Socket();
        if (timeout >= 0) {
            s.connect(dest, timeout);
        } else if (this.connectTimeout >= 0) {
            s.connect(dest, this.connectTimeout);
        } else if (defaultConnectTimeout > 0) {
            s.connect(dest, defaultConnectTimeout);
        } else {
            s.connect(dest);
        }
        if (this.readTimeout >= 0) {
            s.setSoTimeout(this.readTimeout);
        } else if (defaultSoTimeout > 0) {
            s.setSoTimeout(defaultSoTimeout);
        }
        return s;
    }

    private void disconnect() throws IOException {
        if (this.isConnected()) {
            this.server.close();
        }
        this.server = null;
        this.in = null;
        this.out = null;
        this.lastTransSize = -1L;
        this.lastFileName = null;
        this.restartOffset = 0L;
        this.welcomeMsg = null;
        this.lastReplyCode = null;
        this.serverResponse.setSize(0);
    }

    @Override
    public boolean isConnected() {
        return this.server != null;
    }

    @Override
    public SocketAddress getServerAddress() {
        return this.server == null ? null : this.server.getRemoteSocketAddress();
    }

    @Override
    public sun.net.ftp.FtpClient connect(SocketAddress dest) throws FtpProtocolException, IOException {
        return this.connect(dest, -1);
    }

    @Override
    public sun.net.ftp.FtpClient connect(SocketAddress dest, int timeout) throws FtpProtocolException, IOException {
        if (!(dest instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Wrong address type");
        }
        this.serverAddr = (InetSocketAddress)dest;
        this.tryConnect(this.serverAddr, timeout);
        if (!this.readReply()) {
            throw new FtpProtocolException("Welcome message: " + this.getResponseString(), this.lastReplyCode);
        }
        this.welcomeMsg = this.getResponseString().substring(4);
        return this;
    }

    private void tryLogin(String user, char[] password) throws FtpProtocolException, IOException {
        this.issueCommandCheck("USER " + user);
        if (this.lastReplyCode == FtpReplyCode.NEED_PASSWORD && password != null && password.length > 0) {
            this.issueCommandCheck("PASS " + String.valueOf(password));
        }
    }

    @Override
    public sun.net.ftp.FtpClient login(String user, char[] password) throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (user == null || user.length() == 0) {
            throw new IllegalArgumentException("User name can't be null or empty");
        }
        this.tryLogin(user, password);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.serverResponse.size(); ++i) {
            String l = this.serverResponse.elementAt(i);
            if (l == null) continue;
            if (l.length() >= 4 && l.startsWith("230")) {
                l = l.substring(4);
            }
            sb.append(l);
        }
        this.welcomeMsg = sb.toString();
        this.loggedIn = true;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient login(String user, char[] password, String account) throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (user == null || user.length() == 0) {
            throw new IllegalArgumentException("User name can't be null or empty");
        }
        this.tryLogin(user, password);
        if (this.lastReplyCode == FtpReplyCode.NEED_ACCOUNT) {
            this.issueCommandCheck("ACCT " + account);
        }
        StringBuffer sb = new StringBuffer();
        if (this.serverResponse != null) {
            for (String l : this.serverResponse) {
                if (l == null) continue;
                if (l.length() >= 4 && l.startsWith("230")) {
                    l = l.substring(4);
                }
                sb.append(l);
            }
        }
        this.welcomeMsg = sb.toString();
        this.loggedIn = true;
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.isConnected()) {
            try {
                this.issueCommand("QUIT");
            }
            catch (FtpProtocolException ftpProtocolException) {
                // empty catch block
            }
            this.loggedIn = false;
        }
        this.disconnect();
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public sun.net.ftp.FtpClient changeDirectory(String remoteDirectory) throws FtpProtocolException, IOException {
        if (remoteDirectory == null || "".equals(remoteDirectory)) {
            throw new IllegalArgumentException("directory can't be null or empty");
        }
        this.issueCommandCheck("CWD " + remoteDirectory);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient changeToParentDirectory() throws FtpProtocolException, IOException {
        this.issueCommandCheck("CDUP");
        return this;
    }

    @Override
    public String getWorkingDirectory() throws FtpProtocolException, IOException {
        this.issueCommandCheck("PWD");
        String answ = this.getResponseString();
        if (!answ.startsWith("257")) {
            return null;
        }
        return answ.substring(5, answ.lastIndexOf(34));
    }

    @Override
    public sun.net.ftp.FtpClient setRestartOffset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("offset can't be negative");
        }
        this.restartOffset = offset;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public sun.net.ftp.FtpClient getFile(String name, OutputStream local) throws FtpProtocolException, IOException {
        int mtu = 1500;
        if (this.restartOffset > 0L) {
            int l;
            Socket s;
            try {
                s = this.openDataConnection("REST " + this.restartOffset);
            }
            finally {
                this.restartOffset = 0L;
            }
            this.issueCommandCheck("RETR " + name);
            this.getTransferSize();
            InputStream remote = this.createInputStream(s.getInputStream());
            byte[] buf = new byte[mtu * 10];
            while ((l = remote.read(buf)) >= 0) {
                if (l <= 0) continue;
                local.write(buf, 0, l);
            }
            remote.close();
        } else {
            int l;
            Socket s = this.openDataConnection("RETR " + name);
            this.getTransferSize();
            InputStream remote = this.createInputStream(s.getInputStream());
            byte[] buf = new byte[mtu * 10];
            while ((l = remote.read(buf)) >= 0) {
                if (l <= 0) continue;
                local.write(buf, 0, l);
            }
            remote.close();
        }
        return this.completePending();
    }

    @Override
    public InputStream getFileStream(String name) throws FtpProtocolException, IOException {
        if (this.restartOffset > 0L) {
            Socket s;
            try {
                s = this.openDataConnection("REST " + this.restartOffset);
            }
            finally {
                this.restartOffset = 0L;
            }
            if (s == null) {
                return null;
            }
            this.issueCommandCheck("RETR " + name);
            this.getTransferSize();
            return this.createInputStream(s.getInputStream());
        }
        Socket s = this.openDataConnection("RETR " + name);
        if (s == null) {
            return null;
        }
        this.getTransferSize();
        return this.createInputStream(s.getInputStream());
    }

    @Override
    public OutputStream putFileStream(String name, boolean unique) throws FtpProtocolException, IOException {
        String cmd = unique ? "STOU " : "STOR ";
        Socket s = this.openDataConnection(cmd + name);
        if (s == null) {
            return null;
        }
        boolean bm = this.type == FtpClient.TransferType.BINARY;
        return new TelnetOutputStream(s.getOutputStream(), bm);
    }

    @Override
    public sun.net.ftp.FtpClient putFile(String name, InputStream local, boolean unique) throws FtpProtocolException, IOException {
        String cmd = unique ? "STOU " : "STOR ";
        int mtu = 1500;
        if (this.type == FtpClient.TransferType.BINARY) {
            int l;
            Socket s = this.openDataConnection(cmd + name);
            OutputStream remote = this.createOutputStream(s.getOutputStream());
            byte[] buf = new byte[mtu * 10];
            while ((l = local.read(buf)) >= 0) {
                if (l <= 0) continue;
                remote.write(buf, 0, l);
            }
            remote.close();
        }
        return this.completePending();
    }

    @Override
    public sun.net.ftp.FtpClient appendFile(String name, InputStream local) throws FtpProtocolException, IOException {
        int l;
        int mtu = 1500;
        Socket s = this.openDataConnection("APPE " + name);
        OutputStream remote = this.createOutputStream(s.getOutputStream());
        byte[] buf = new byte[mtu * 10];
        while ((l = local.read(buf)) >= 0) {
            if (l <= 0) continue;
            remote.write(buf, 0, l);
        }
        remote.close();
        return this.completePending();
    }

    @Override
    public sun.net.ftp.FtpClient rename(String from, String to) throws FtpProtocolException, IOException {
        this.issueCommandCheck("RNFR " + from);
        this.issueCommandCheck("RNTO " + to);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient deleteFile(String name) throws FtpProtocolException, IOException {
        this.issueCommandCheck("DELE " + name);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient makeDirectory(String name) throws FtpProtocolException, IOException {
        this.issueCommandCheck("MKD " + name);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient removeDirectory(String name) throws FtpProtocolException, IOException {
        this.issueCommandCheck("RMD " + name);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient noop() throws FtpProtocolException, IOException {
        this.issueCommandCheck("NOOP");
        return this;
    }

    @Override
    public String getStatus(String name) throws FtpProtocolException, IOException {
        this.issueCommandCheck(name == null ? "STAT" : "STAT " + name);
        Vector<String> resp = this.getResponseStrings();
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < resp.size() - 1; ++i) {
            sb.append(resp.get(i));
        }
        return sb.toString();
    }

    @Override
    public List<String> getFeatures() throws FtpProtocolException, IOException {
        ArrayList<String> features = new ArrayList<String>();
        this.issueCommandCheck("FEAT");
        Vector<String> resp = this.getResponseStrings();
        for (int i = 1; i < resp.size() - 1; ++i) {
            String s = resp.get(i);
            features.add(s.substring(1, s.length() - 1));
        }
        return features;
    }

    @Override
    public sun.net.ftp.FtpClient abort() throws FtpProtocolException, IOException {
        this.issueCommandCheck("ABOR");
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient completePending() throws FtpProtocolException, IOException {
        while (this.replyPending) {
            this.replyPending = false;
            if (this.readReply()) continue;
            throw new FtpProtocolException(this.getLastResponseString(), this.lastReplyCode);
        }
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient reInit() throws FtpProtocolException, IOException {
        this.issueCommandCheck("REIN");
        this.loggedIn = false;
        if (this.useCrypto && this.server instanceof SSLSocket) {
            SSLSession session = ((SSLSocket)this.server).getSession();
            session.invalidate();
            this.server = this.oldSocket;
            this.oldSocket = null;
            try {
                this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalError(encoding + "encoding not found", e);
            }
            this.in = new BufferedInputStream(this.server.getInputStream());
        }
        this.useCrypto = false;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient setType(FtpClient.TransferType type) throws FtpProtocolException, IOException {
        String cmd = "NOOP";
        this.type = type;
        if (type == FtpClient.TransferType.ASCII) {
            cmd = "TYPE A";
        }
        if (type == FtpClient.TransferType.BINARY) {
            cmd = "TYPE I";
        }
        if (type == FtpClient.TransferType.EBCDIC) {
            cmd = "TYPE E";
        }
        this.issueCommandCheck(cmd);
        return this;
    }

    @Override
    public InputStream list(String path) throws FtpProtocolException, IOException {
        Socket s = this.openDataConnection(path == null ? "LIST" : "LIST " + path);
        if (s != null) {
            return this.createInputStream(s.getInputStream());
        }
        return null;
    }

    @Override
    public InputStream nameList(String path) throws FtpProtocolException, IOException {
        Socket s = this.openDataConnection(path == null ? "NLST" : "NLST " + path);
        if (s != null) {
            return this.createInputStream(s.getInputStream());
        }
        return null;
    }

    @Override
    public long getSize(String path) throws FtpProtocolException, IOException {
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException("path can't be null or empty");
        }
        this.issueCommandCheck("SIZE " + path);
        if (this.lastReplyCode == FtpReplyCode.FILE_STATUS) {
            String s = this.getResponseString();
            s = s.substring(4, s.length() - 1);
            return Long.parseLong(s);
        }
        return -1L;
    }

    @Override
    public Date getLastModified(String path) throws FtpProtocolException, IOException {
        this.issueCommandCheck("MDTM " + path);
        if (this.lastReplyCode == FtpReplyCode.FILE_STATUS) {
            String s = this.getResponseString().substring(4);
            Date d = null;
            for (SimpleDateFormat dateFormat : dateFormats) {
                try {
                    d = dateFormat.parse(s);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (d == null) continue;
                return d;
            }
        }
        return null;
    }

    @Override
    public sun.net.ftp.FtpClient setDirParser(FtpDirParser p) {
        this.parser = p;
        return this;
    }

    @Override
    public Iterator<FtpDirEntry> listFiles(String path) throws FtpProtocolException, IOException {
        Socket s = null;
        BufferedReader sin = null;
        try {
            s = this.openDataConnection(path == null ? "MLSD" : "MLSD " + path);
        }
        catch (FtpProtocolException ftpProtocolException) {
            // empty catch block
        }
        if (s != null) {
            sin = new BufferedReader(new InputStreamReader(s.getInputStream()));
            return new FtpFileIterator(this.mlsxParser, sin);
        }
        s = this.openDataConnection(path == null ? "LIST" : "LIST " + path);
        if (s != null) {
            sin = new BufferedReader(new InputStreamReader(s.getInputStream()));
            return new FtpFileIterator(this.parser, sin);
        }
        return null;
    }

    private boolean sendSecurityData(byte[] buf) throws IOException, FtpProtocolException {
        BASE64Encoder encoder = new BASE64Encoder();
        String s = encoder.encode(buf);
        return this.issueCommand("ADAT " + s);
    }

    private byte[] getSecurityData() {
        String s = this.getLastResponseString();
        if (s.substring(4, 9).equalsIgnoreCase("ADAT=")) {
            BASE64Decoder decoder = new BASE64Decoder();
            try {
                return decoder.decodeBuffer(s.substring(9, s.length() - 1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public sun.net.ftp.FtpClient useKerberos() throws FtpProtocolException, IOException {
        return this;
    }

    @Override
    public String getWelcomeMsg() {
        return this.welcomeMsg;
    }

    @Override
    public FtpReplyCode getLastReplyCode() {
        return this.lastReplyCode;
    }

    @Override
    public String getLastResponseString() {
        StringBuffer sb = new StringBuffer();
        if (this.serverResponse != null) {
            for (String l : this.serverResponse) {
                if (l == null) continue;
                sb.append(l);
            }
        }
        return sb.toString();
    }

    @Override
    public long getLastTransferSize() {
        return this.lastTransSize;
    }

    @Override
    public String getLastFileName() {
        return this.lastFileName;
    }

    @Override
    public sun.net.ftp.FtpClient startSecureSession() throws FtpProtocolException, IOException {
        if (!this.isConnected()) {
            throw new FtpProtocolException("Not connected yet", FtpReplyCode.BAD_SEQUENCE);
        }
        if (this.sslFact == null) {
            try {
                this.sslFact = (SSLSocketFactory)SSLSocketFactory.getDefault();
            }
            catch (Exception e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        this.issueCommandCheck("AUTH TLS");
        Socket s = null;
        try {
            s = this.sslFact.createSocket(this.server, this.serverAddr.getHostName(), this.serverAddr.getPort(), true);
        }
        catch (SSLException ssle) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ssle;
        }
        this.oldSocket = this.server;
        this.server = s;
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + "encoding not found", e);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
        this.issueCommandCheck("PBSZ 0");
        this.issueCommandCheck("PROT P");
        this.useCrypto = true;
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient endSecureSession() throws FtpProtocolException, IOException {
        if (!this.useCrypto) {
            return this;
        }
        this.issueCommandCheck("CCC");
        this.issueCommandCheck("PROT C");
        this.useCrypto = false;
        this.server = this.oldSocket;
        this.oldSocket = null;
        try {
            this.out = new PrintStream(new BufferedOutputStream(this.server.getOutputStream()), true, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(encoding + "encoding not found", e);
        }
        this.in = new BufferedInputStream(this.server.getInputStream());
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient allocate(long size) throws FtpProtocolException, IOException {
        this.issueCommandCheck("ALLO " + size);
        return this;
    }

    @Override
    public sun.net.ftp.FtpClient structureMount(String struct) throws FtpProtocolException, IOException {
        this.issueCommandCheck("SMNT " + struct);
        return this;
    }

    @Override
    public String getSystem() throws FtpProtocolException, IOException {
        this.issueCommandCheck("SYST");
        String resp = this.getResponseString();
        return resp.substring(4);
    }

    @Override
    public String getHelp(String cmd) throws FtpProtocolException, IOException {
        this.issueCommandCheck("HELP " + cmd);
        Vector<String> resp = this.getResponseStrings();
        if (resp.size() == 1) {
            return resp.get(0).substring(4);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 1; i < resp.size() - 1; ++i) {
            sb.append(resp.get(i).substring(3));
        }
        return sb.toString();
    }

    @Override
    public sun.net.ftp.FtpClient siteCmd(String cmd) throws FtpProtocolException, IOException {
        this.issueCommandCheck("SITE " + cmd);
        return this;
    }

    static {
        logger = PlatformLogger.getLogger("sun.net.ftp.FtpClient");
        encoding = "ISO8859_1";
        patStrings = new String[]{"([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*(\\d\\d:\\d\\d)\\s*(\\p{Print}*)", "([\\-ld](?:[r\\-][w\\-][x\\-]){3})\\s*\\d+ (\\w+)\\s*(\\w+)\\s*(\\d+)\\s*([A-Z][a-z][a-z]\\s*\\d+)\\s*(\\d{4})\\s*(\\p{Print}*)", "(\\d{2}/\\d{2}/\\d{4})\\s*(\\d{2}:\\d{2}[ap])\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)", "(\\d{2}-\\d{2}-\\d{2})\\s*(\\d{2}:\\d{2}[AP]M)\\s*((?:[0-9,]+)|(?:<DIR>))\\s*(\\p{Graph}*)"};
        patternGroups = new int[][]{{7, 4, 5, 6, 0, 1, 2, 3}, {7, 4, 5, 0, 6, 1, 2, 3}, {4, 3, 1, 2, 0, 0, 0, 0}, {4, 3, 1, 2, 0, 0, 0, 0}};
        linkp = Pattern.compile("(\\p{Print}+) \\-\\> (\\p{Print}+)$");
        final int[] vals = new int[]{0, 0};
        final String[] encs = new String[]{null};
        final String[] acceptPasvAddress = new String[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                acceptPasvAddress[0] = System.getProperty("jdk.net.ftp.trustPasvAddress", "false");
                vals[0] = Integer.getInteger("sun.net.client.defaultReadTimeout", 300000);
                vals[1] = Integer.getInteger("sun.net.client.defaultConnectTimeout", 300000);
                encs[0] = System.getProperty("file.encoding", "ISO8859_1");
                return null;
            }
        });
        defaultSoTimeout = vals[0] == 0 ? -1 : vals[0];
        defaultConnectTimeout = vals[1] == 0 ? -1 : vals[1];
        encoding = encs[0];
        try {
            if (!FtpClient.isASCIISuperset(encoding)) {
                encoding = "ISO8859_1";
            }
        }
        catch (Exception e) {
            encoding = "ISO8859_1";
        }
        patterns = new Pattern[patStrings.length];
        for (int i = 0; i < patStrings.length; ++i) {
            FtpClient.patterns[i] = Pattern.compile(patStrings[i]);
        }
        acceptPasvAddressVal = Boolean.parseBoolean(acceptPasvAddress[0]);
        transPat = null;
        epsvPat = null;
        pasvPat = null;
        MDTMformats = new String[]{"yyyyMMddHHmmss.SSS", "yyyyMMddHHmmss"};
        dateFormats = new SimpleDateFormat[MDTMformats.length];
        for (int i = 0; i < MDTMformats.length; ++i) {
            FtpClient.dateFormats[i] = new SimpleDateFormat(MDTMformats[i]);
            dateFormats[i].setTimeZone(TimeZone.getTimeZone("GMT"));
        }
    }

    private class FtpFileIterator
    implements Iterator<FtpDirEntry>,
    Closeable {
        private BufferedReader in = null;
        private FtpDirEntry nextFile = null;
        private FtpDirParser fparser = null;
        private boolean eof = false;

        public FtpFileIterator(FtpDirParser p, BufferedReader in) {
            this.in = in;
            this.fparser = p;
            this.readNext();
        }

        private void readNext() {
            this.nextFile = null;
            if (this.eof) {
                return;
            }
            String line = null;
            try {
                do {
                    if ((line = this.in.readLine()) == null) continue;
                    this.nextFile = this.fparser.parseLine(line);
                    if (this.nextFile == null) continue;
                    return;
                } while (line != null);
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.eof = true;
        }

        @Override
        public boolean hasNext() {
            return this.nextFile != null;
        }

        @Override
        public FtpDirEntry next() {
            FtpDirEntry ret = this.nextFile;
            this.readNext();
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void close() throws IOException {
            if (this.in != null && !this.eof) {
                this.in.close();
            }
            this.eof = true;
            this.nextFile = null;
        }
    }

    private class MLSxParser
    implements FtpDirParser {
        private SimpleDateFormat df = new SimpleDateFormat("yyyyMMddhhmmss");

        private MLSxParser() {
        }

        @Override
        public FtpDirEntry parseLine(String line) {
            Date d;
            String s;
            String name = null;
            int i = line.lastIndexOf(";");
            if (i > 0) {
                name = line.substring(i + 1).trim();
                line = line.substring(0, i);
            } else {
                name = line.trim();
                line = "";
            }
            FtpDirEntry file = new FtpDirEntry(name);
            while (!line.isEmpty()) {
                i = line.indexOf(";");
                if (i > 0) {
                    s = line.substring(0, i);
                    line = line.substring(i + 1);
                } else {
                    s = line;
                    line = "";
                }
                if ((i = s.indexOf("=")) <= 0) continue;
                String fact = s.substring(0, i);
                String value = s.substring(i + 1);
                file.addFact(fact, value);
            }
            s = file.getFact("Size");
            if (s != null) {
                file.setSize(Long.parseLong(s));
            }
            if ((s = file.getFact("Modify")) != null) {
                d = null;
                try {
                    d = this.df.parse(s);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (d != null) {
                    file.setLastModified(d);
                }
            }
            if ((s = file.getFact("Create")) != null) {
                d = null;
                try {
                    d = this.df.parse(s);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (d != null) {
                    file.setCreated(d);
                }
            }
            if ((s = file.getFact("Type")) != null) {
                if (s.equalsIgnoreCase("file")) {
                    file.setType(FtpDirEntry.Type.FILE);
                }
                if (s.equalsIgnoreCase("dir")) {
                    file.setType(FtpDirEntry.Type.DIR);
                }
                if (s.equalsIgnoreCase("cdir")) {
                    file.setType(FtpDirEntry.Type.CDIR);
                }
                if (s.equalsIgnoreCase("pdir")) {
                    file.setType(FtpDirEntry.Type.PDIR);
                }
            }
            return file;
        }
    }

    private class DefaultParser
    implements FtpDirParser {
        private DefaultParser() {
        }

        @Override
        public FtpDirEntry parseLine(String line) {
            String fdate = null;
            String fsize = null;
            String time = null;
            String filename = null;
            String permstring = null;
            String username = null;
            String groupname = null;
            boolean dir = false;
            Calendar now = Calendar.getInstance();
            int year = now.get(1);
            Matcher m = null;
            for (int j = 0; j < patterns.length; ++j) {
                m = patterns[j].matcher(line);
                if (!m.find()) continue;
                filename = m.group(patternGroups[j][0]);
                fsize = m.group(patternGroups[j][1]);
                fdate = m.group(patternGroups[j][2]);
                if (patternGroups[j][4] > 0) {
                    fdate = fdate + ", " + m.group(patternGroups[j][4]);
                } else if (patternGroups[j][3] > 0) {
                    fdate = fdate + ", " + String.valueOf(year);
                }
                if (patternGroups[j][3] > 0) {
                    time = m.group(patternGroups[j][3]);
                }
                if (patternGroups[j][5] > 0) {
                    permstring = m.group(patternGroups[j][5]);
                    dir = permstring.startsWith("d");
                }
                if (patternGroups[j][6] > 0) {
                    username = m.group(patternGroups[j][6]);
                }
                if (patternGroups[j][7] > 0) {
                    groupname = m.group(patternGroups[j][7]);
                }
                if (!"<DIR>".equals(fsize)) continue;
                dir = true;
                fsize = null;
            }
            if (filename != null) {
                Matcher m2;
                Date d;
                try {
                    d = FtpClient.this.df.parse(fdate);
                }
                catch (Exception e) {
                    d = null;
                }
                if (d != null && time != null) {
                    int c = time.indexOf(":");
                    now.setTime(d);
                    now.set(10, Integer.parseInt(time.substring(0, c)));
                    now.set(12, Integer.parseInt(time.substring(c + 1)));
                    d = now.getTime();
                }
                if ((m2 = linkp.matcher(filename)).find()) {
                    filename = m2.group(1);
                }
                boolean[][] perms = new boolean[3][3];
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        perms[i][j] = permstring.charAt(i * 3 + j) != '-';
                    }
                }
                FtpDirEntry file = new FtpDirEntry(filename);
                file.setUser(username).setGroup(groupname);
                file.setSize(Long.parseLong(fsize)).setLastModified(d);
                file.setPermissions(perms);
                file.setType(dir ? FtpDirEntry.Type.DIR : (line.charAt(0) == 'l' ? FtpDirEntry.Type.LINK : FtpDirEntry.Type.FILE));
                return file;
            }
            return null;
        }
    }
}

