/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.Objects;
import javax.security.auth.kerberos.KeyTab;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbKdcRep;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.ASRep;
import sun.security.krb5.internal.ASReq;
import sun.security.krb5.internal.EncASRepPart;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.crypto.EType;
import sun.security.util.DerValue;

class KrbAsRep
extends KrbKdcRep {
    private ASRep rep;
    private Credentials creds;
    private boolean DEBUG = Krb5.DEBUG;

    KrbAsRep(byte[] ibuf) throws KrbException, Asn1Exception, IOException {
        DerValue encoding = new DerValue(ibuf);
        try {
            this.rep = new ASRep(encoding);
        }
        catch (Asn1Exception e) {
            KrbException ke;
            this.rep = null;
            KRBError err = new KRBError(encoding);
            String errStr = err.getErrorString();
            String eText = null;
            if (errStr != null && errStr.length() > 0) {
                eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            }
            if (eText == null) {
                ke = new KrbException(err);
            } else {
                if (this.DEBUG) {
                    System.out.println("KRBError received: " + eText);
                }
                ke = new KrbException(err, eText);
            }
            ke.initCause(e);
            throw ke;
        }
    }

    PAData[] getPA() {
        return this.rep.pAData;
    }

    void decryptUsingKeyTab(KeyTab ktab, KrbAsReq asReq, PrincipalName cname) throws KrbException, Asn1Exception, IOException {
        Integer encPartKvno;
        int encPartKeyType;
        EncryptionKey dkey;
        block3: {
            dkey = null;
            encPartKeyType = this.rep.encPart.getEType();
            encPartKvno = this.rep.encPart.kvno;
            try {
                dkey = EncryptionKey.findKey(encPartKeyType, encPartKvno, Krb5Util.keysFromJavaxKeyTab(ktab, cname));
            }
            catch (KrbException ke) {
                if (ke.returnCode() != 44) break block3;
                dkey = EncryptionKey.findKey(encPartKeyType, Krb5Util.keysFromJavaxKeyTab(ktab, cname));
            }
        }
        if (dkey == null) {
            throw new KrbException(400, "Cannot find key for type/kvno to decrypt AS REP - " + EType.toString(encPartKeyType) + "/" + encPartKvno);
        }
        this.decrypt(dkey, asReq, cname);
    }

    void decryptUsingPassword(char[] password, KrbAsReq asReq, PrincipalName cname) throws KrbException, Asn1Exception, IOException {
        int encPartKeyType = this.rep.encPart.getEType();
        EncryptionKey dkey = EncryptionKey.acquireSecretKey(cname, password, encPartKeyType, PAData.getSaltAndParams(encPartKeyType, this.rep.pAData));
        this.decrypt(dkey, asReq, cname);
    }

    private void decrypt(EncryptionKey dkey, KrbAsReq asReq, PrincipalName cname) throws KrbException, Asn1Exception, IOException {
        byte[] enc_as_rep_bytes = this.rep.encPart.decrypt(dkey, 3);
        byte[] enc_as_rep_part = this.rep.encPart.reset(enc_as_rep_bytes);
        DerValue encoding = new DerValue(enc_as_rep_part);
        EncASRepPart enc_part = new EncASRepPart(encoding);
        this.rep.encKDCRepPart = enc_part;
        ASReq req = asReq.getMessage();
        KrbAsRep.check(true, req, this.rep, dkey);
        PrincipalName clientAlias = cname;
        if (clientAlias.equals(this.rep.cname)) {
            clientAlias = null;
        }
        this.creds = new Credentials(this.rep.ticket, this.rep.cname, clientAlias, enc_part.sname, null, enc_part.key, enc_part.flags, enc_part.authtime, enc_part.starttime, enc_part.endtime, enc_part.renewTill, enc_part.caddr);
        if (this.DEBUG) {
            System.out.println(">>> KrbAsRep cons in KrbAsReq.getReply " + req.reqBody.cname.getNameString());
        }
    }

    Credentials getCreds() {
        return Objects.requireNonNull(this.creds, "Creds not available yet.");
    }

    sun.security.krb5.internal.ccache.Credentials getCCreds() {
        return new sun.security.krb5.internal.ccache.Credentials(this.rep);
    }
}

