/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.util.KerberosFlags;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PaPacOptions {
    private static final int CLAIMS = 0;
    private static final int BRANCH_AWARE = 1;
    private static final int FORWARD_TO_FULL_DC = 2;
    private static final int RESOURCE_BASED_CONSTRAINED_DELEGATION = 3;
    private KerberosFlags flags;

    public PaPacOptions() {
        this.flags = new KerberosFlags(32);
    }

    public PaPacOptions(DerValue encoding) throws Asn1Exception, IOException {
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.flags = new KDCOptions(der.getData().getDerValue());
    }

    public PaPacOptions setClaims(boolean value) {
        this.flags.set(0, value);
        return this;
    }

    public boolean getClaims() {
        return this.flags.get(0);
    }

    public PaPacOptions setBranchAware(boolean value) {
        this.flags.set(1, value);
        return this;
    }

    public boolean getBranchAware() {
        return this.flags.get(1);
    }

    public PaPacOptions setForwardToFullDC(boolean value) {
        this.flags.set(2, value);
        return this;
    }

    public boolean getForwardToFullDC() {
        return this.flags.get(2);
    }

    public PaPacOptions setResourceBasedConstrainedDelegation(boolean value) {
        this.flags.set(3, value);
        return this;
    }

    public boolean getResourceBasedConstrainedDelegation() {
        return this.flags.get(3);
    }

    public byte[] asn1Encode() throws IOException {
        byte[] bytes = null;
        try (DerOutputStream temp = new DerOutputStream();){
            temp.write(DerValue.createTag((byte)-128, true, (byte)0), this.flags.asn1Encode());
            bytes = temp.toByteArray();
        }
        temp = new DerOutputStream();
        var3_3 = null;
        try {
            temp.write((byte)48, bytes);
            byte[] byArray = temp.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (temp != null) {
                if (var3_3 != null) {
                    try {
                        temp.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    temp.close();
                }
            }
        }
    }

    public String toString() {
        return this.flags.toString();
    }
}

