/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import sun.security.pkcs.PKCS8Key;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPrivateKeyImpl;
import sun.security.rsa.RSAUtil;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public final class RSAPrivateCrtKeyImpl
extends PKCS8Key
implements RSAPrivateCrtKey {
    private static final long serialVersionUID = -1326088454257084918L;
    private BigInteger n;
    private BigInteger e;
    private BigInteger d;
    private BigInteger p;
    private BigInteger q;
    private BigInteger pe;
    private BigInteger qe;
    private BigInteger coeff;
    private AlgorithmParameterSpec keyParams;

    public static RSAPrivateKey newKey(byte[] encoded) throws InvalidKeyException {
        RSAPrivateCrtKeyImpl key = new RSAPrivateCrtKeyImpl(encoded);
        if (RSAPrivateCrtKeyImpl.checkComponents(key)) {
            return key;
        }
        return new RSAPrivateKeyImpl(key.algid, key.getModulus(), key.getPrivateExponent());
    }

    static boolean checkComponents(RSAPrivateCrtKey key) {
        return key.getPublicExponent().signum() != 0 && key.getPrimeExponentP().signum() != 0 && key.getPrimeExponentQ().signum() != 0 && key.getPrimeP().signum() != 0 && key.getPrimeQ().signum() != 0 && key.getCrtCoefficient().signum() != 0;
    }

    public static RSAPrivateKey newKey(RSAUtil.KeyType type, AlgorithmParameterSpec params, BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) throws InvalidKeyException {
        AlgorithmId rsaId = RSAUtil.createAlgorithmId(type, params);
        if (e.signum() == 0 || p.signum() == 0 || q.signum() == 0 || pe.signum() == 0 || qe.signum() == 0 || coeff.signum() == 0) {
            return new RSAPrivateKeyImpl(rsaId, n, d);
        }
        return new RSAPrivateCrtKeyImpl(rsaId, n, e, d, p, q, pe, qe, coeff);
    }

    RSAPrivateCrtKeyImpl(byte[] encoded) throws InvalidKeyException {
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Missing key encoding");
        }
        this.decode(encoded);
        RSAKeyFactory.checkRSAProviderKeyLengths(this.n.bitLength(), this.e);
        try {
            this.keyParams = RSAUtil.getParamSpec(this.algid);
        }
        catch (ProviderException e) {
            throw new InvalidKeyException(e);
        }
    }

    RSAPrivateCrtKeyImpl(AlgorithmId rsaId, BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger pe, BigInteger qe, BigInteger coeff) throws InvalidKeyException {
        RSAKeyFactory.checkRSAProviderKeyLengths(n.bitLength(), e);
        this.n = n;
        this.e = e;
        this.d = d;
        this.p = p;
        this.q = q;
        this.pe = pe;
        this.qe = qe;
        this.coeff = coeff;
        this.keyParams = RSAUtil.getParamSpec(rsaId);
        this.algid = rsaId;
        try {
            DerOutputStream out = new DerOutputStream();
            out.putInteger(0);
            out.putInteger(n);
            out.putInteger(e);
            out.putInteger(d);
            out.putInteger(p);
            out.putInteger(q);
            out.putInteger(pe);
            out.putInteger(qe);
            out.putInteger(coeff);
            DerValue val = new DerValue(48, out.toByteArray());
            this.key = val.toByteArray();
        }
        catch (IOException exc) {
            throw new InvalidKeyException(exc);
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    @Override
    public BigInteger getModulus() {
        return this.n;
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.e;
    }

    @Override
    public BigInteger getPrivateExponent() {
        return this.d;
    }

    @Override
    public BigInteger getPrimeP() {
        return this.p;
    }

    @Override
    public BigInteger getPrimeQ() {
        return this.q;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        return this.pe;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        return this.qe;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        return this.coeff;
    }

    @Override
    public AlgorithmParameterSpec getParams() {
        return this.keyParams;
    }

    @Override
    protected void parseKeyBits() throws InvalidKeyException {
        try {
            DerInputStream in = new DerInputStream(this.key);
            DerValue derValue = in.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = derValue.data;
            int version = data.getInteger();
            if (version != 0) {
                throw new IOException("Version must be 0");
            }
            this.n = data.getPositiveBigInteger();
            this.e = data.getPositiveBigInteger();
            this.d = data.getPositiveBigInteger();
            this.p = data.getPositiveBigInteger();
            this.q = data.getPositiveBigInteger();
            this.pe = data.getPositiveBigInteger();
            this.qe = data.getPositiveBigInteger();
            this.coeff = data.getPositiveBigInteger();
            if (derValue.data.available() != 0) {
                throw new IOException("Extra data available");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("Invalid RSA private key", e);
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("RSAPrivateCrtKeyImpl keys are not directly deserializable");
    }
}

