/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Locale;
import sun.misc.SharedSecrets;
import sun.security.rsa.RSAUtil;
import sun.security.util.ECUtil;

public class SignatureUtil {
    private static String checkName(String algName) throws ProviderException {
        if (algName.indexOf(".") == -1) {
            return algName;
        }
        try {
            return Signature.getInstance(algName).getAlgorithm();
        }
        catch (Exception e) {
            throw new ProviderException("Error mapping algorithm name", e);
        }
    }

    private static AlgorithmParameters createAlgorithmParameters(String algName, byte[] paramBytes) throws ProviderException {
        try {
            algName = SignatureUtil.checkName(algName);
            AlgorithmParameters result = AlgorithmParameters.getInstance(algName);
            result.init(paramBytes);
            return result;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
    }

    public static AlgorithmParameterSpec getParamSpec(String sigName, AlgorithmParameters params) throws ProviderException {
        sigName = SignatureUtil.checkName(sigName).toUpperCase(Locale.ENGLISH);
        AlgorithmParameterSpec paramSpec = null;
        if (params != null) {
            if (params.getAlgorithm().indexOf(".") != -1) {
                try {
                    params = SignatureUtil.createAlgorithmParameters(sigName, params.getEncoded());
                }
                catch (IOException e) {
                    throw new ProviderException(e);
                }
            }
            if (sigName.indexOf("RSA") != -1) {
                paramSpec = RSAUtil.getParamSpec(params);
            } else if (sigName.indexOf("ECDSA") != -1) {
                try {
                    paramSpec = params.getParameterSpec(ECParameterSpec.class);
                }
                catch (Exception e) {
                    throw new ProviderException("Error handling EC parameters", e);
                }
            } else {
                throw new ProviderException("Unrecognized algorithm for signature parameters " + sigName);
            }
        }
        return paramSpec;
    }

    public static AlgorithmParameterSpec getParamSpec(String sigName, byte[] paramBytes) throws ProviderException {
        sigName = SignatureUtil.checkName(sigName).toUpperCase(Locale.ENGLISH);
        AlgorithmParameterSpec paramSpec = null;
        if (paramBytes != null) {
            if (sigName.indexOf("RSA") != -1) {
                AlgorithmParameters params = SignatureUtil.createAlgorithmParameters(sigName, paramBytes);
                paramSpec = RSAUtil.getParamSpec(params);
            } else if (sigName.indexOf("ECDSA") != -1) {
                try {
                    Provider p = Signature.getInstance(sigName).getProvider();
                    paramSpec = ECUtil.getECParameterSpec(p, paramBytes);
                }
                catch (Exception e) {
                    throw new ProviderException("Error handling EC parameters", e);
                }
                if (paramSpec == null) {
                    throw new ProviderException("Error handling EC parameters");
                }
            } else {
                throw new ProviderException("Unrecognized algorithm for signature parameters " + sigName);
            }
        }
        return paramSpec;
    }

    public static void initVerifyWithParam(Signature s, PublicKey key, AlgorithmParameterSpec params) throws ProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initVerify(s, key, params);
    }

    public static void initVerifyWithParam(Signature s, Certificate cert, AlgorithmParameterSpec params) throws ProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initVerify(s, cert, params);
    }

    public static void initSignWithParam(Signature s, PrivateKey key, AlgorithmParameterSpec params, SecureRandom sr) throws ProviderException, InvalidAlgorithmParameterException, InvalidKeyException {
        SharedSecrets.getJavaSecuritySignatureAccess().initSign(s, key, params, sr);
    }
}

