/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.util.Objects;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.GeneralNames;
import sun.security.x509.RDN;

public class DistributionPointName {
    private static final byte TAG_FULL_NAME = 0;
    private static final byte TAG_RELATIVE_NAME = 1;
    private GeneralNames fullName = null;
    private RDN relativeName = null;
    private volatile int hashCode;

    public DistributionPointName(GeneralNames fullName) {
        if (fullName == null) {
            throw new IllegalArgumentException("fullName must not be null");
        }
        this.fullName = fullName;
    }

    public DistributionPointName(RDN relativeName) {
        if (relativeName == null) {
            throw new IllegalArgumentException("relativeName must not be null");
        }
        this.relativeName = relativeName;
    }

    public DistributionPointName(DerValue encoding) throws IOException {
        if (encoding.isContextSpecific((byte)0) && encoding.isConstructed()) {
            encoding.resetTag((byte)48);
            this.fullName = new GeneralNames(encoding);
        } else if (encoding.isContextSpecific((byte)1) && encoding.isConstructed()) {
            encoding.resetTag((byte)49);
            this.relativeName = new RDN(encoding);
        } else {
            throw new IOException("Invalid encoding for DistributionPointName");
        }
    }

    public GeneralNames getFullName() {
        return this.fullName;
    }

    public RDN getRelativeName() {
        return this.relativeName;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream theChoice = new DerOutputStream();
        if (this.fullName != null) {
            this.fullName.encode(theChoice);
            out.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), theChoice);
        } else {
            this.relativeName.encode(theChoice);
            out.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), theChoice);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DistributionPointName)) {
            return false;
        }
        DistributionPointName other = (DistributionPointName)obj;
        return Objects.equals(this.fullName, other.fullName) && Objects.equals(this.relativeName, other.relativeName);
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = 1;
            hash = this.fullName != null ? (hash += this.fullName.hashCode()) : (hash += this.relativeName.hashCode());
            this.hashCode = hash;
        }
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.fullName != null) {
            sb.append("DistributionPointName:\n     " + this.fullName + "\n");
        } else {
            sb.append("DistributionPointName:\n     " + this.relativeName + "\n");
        }
        return sb.toString();
    }
}

