/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.SimpleClientId;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;
import javax.naming.ldap.Control;

class DigestClientId
extends SimpleClientId {
    private static final String[] SASL_PROPS = new String[]{"java.naming.security.sasl.authorizationId", "java.naming.security.sasl.realm", "javax.security.sasl.qop", "javax.security.sasl.strength", "javax.security.sasl.reuse", "javax.security.sasl.server.authentication", "javax.security.sasl.maxbuffer", "javax.security.sasl.policy.noplaintext", "javax.security.sasl.policy.noactive", "javax.security.sasl.policy.nodictionary", "javax.security.sasl.policy.noanonymous", "javax.security.sasl.policy.forward", "javax.security.sasl.policy.credentials"};
    private final String[] propvals;
    private final int myHash;

    DigestClientId(int version, String hostname, int port, String protocol, Control[] bindCtls, OutputStream trace, String socketFactory, String username, Object passwd, Hashtable<?, ?> env) {
        super(version, hostname, port, protocol, bindCtls, trace, socketFactory, username, passwd);
        if (env == null) {
            this.propvals = null;
        } else {
            this.propvals = new String[SASL_PROPS.length];
            for (int i = 0; i < SASL_PROPS.length; ++i) {
                this.propvals[i] = (String)env.get(SASL_PROPS[i]);
            }
        }
        this.myHash = super.hashCode() ^ Arrays.hashCode(this.propvals);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DigestClientId)) {
            return false;
        }
        DigestClientId other = (DigestClientId)obj;
        return this.myHash == other.myHash && super.equals(obj) && Arrays.equals(this.propvals, other.propvals);
    }

    @Override
    public int hashCode() {
        return this.myHash;
    }

    @Override
    public String toString() {
        if (this.propvals != null) {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.propvals.length; ++i) {
                buf.append(':');
                if (this.propvals[i] == null) continue;
                buf.append(this.propvals[i]);
            }
            return super.toString() + buf.toString();
        }
        return super.toString();
    }
}

