/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.reflect.annotation.AnnotationSupport;
import sun.reflect.annotation.AnnotationType;

public interface AnnotatedElement {
    default public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> var1);

    public Annotation[] getAnnotations();

    default public <T extends Annotation> T[] getAnnotationsByType(Class<T> annotationClass) {
        Class superClass;
        Annotation[] result = this.getDeclaredAnnotationsByType(annotationClass);
        if (result.length == 0 && this instanceof Class && AnnotationType.getInstance(annotationClass).isInherited() && (superClass = ((Class)this).getSuperclass()) != null) {
            result = superClass.getAnnotationsByType(annotationClass);
        }
        return result;
    }

    default public <T extends Annotation> T getDeclaredAnnotation(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        for (Annotation annotation : this.getDeclaredAnnotations()) {
            if (!annotationClass.equals(annotation.annotationType())) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    default public <T extends Annotation> T[] getDeclaredAnnotationsByType(Class<T> annotationClass) {
        Objects.requireNonNull(annotationClass);
        return AnnotationSupport.getDirectlyAndIndirectlyPresent((Map)Arrays.stream(this.getDeclaredAnnotations()).collect(Collectors.toMap(Annotation::annotationType, Function.identity(), (first, second) -> first, LinkedHashMap::new)), annotationClass);
    }

    public Annotation[] getDeclaredAnnotations();
}

