/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.JTextComponent;
import sun.swing.SwingUtilities2;

public class BasicBorders {
    public static Border getButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource buttonBorder = new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.darkShadow"), table.getColor("Button.light"), table.getColor("Button.highlight")), new MarginBorder());
        return buttonBorder;
    }

    public static Border getRadioButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource radioButtonBorder = new BorderUIResource.CompoundBorderUIResource(new RadioButtonBorder(table.getColor("RadioButton.shadow"), table.getColor("RadioButton.darkShadow"), table.getColor("RadioButton.light"), table.getColor("RadioButton.highlight")), new MarginBorder());
        return radioButtonBorder;
    }

    public static Border getToggleButtonBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(new ToggleButtonBorder(table.getColor("ToggleButton.shadow"), table.getColor("ToggleButton.darkShadow"), table.getColor("ToggleButton.light"), table.getColor("ToggleButton.highlight")), new MarginBorder());
        return toggleButtonBorder;
    }

    public static Border getMenuBarBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        MenuBarBorder menuBarBorder = new MenuBarBorder(table.getColor("MenuBar.shadow"), table.getColor("MenuBar.highlight"));
        return menuBarBorder;
    }

    public static Border getSplitPaneBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        SplitPaneBorder splitPaneBorder = new SplitPaneBorder(table.getColor("SplitPane.highlight"), table.getColor("SplitPane.darkShadow"));
        return splitPaneBorder;
    }

    public static Border getSplitPaneDividerBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        SplitPaneDividerBorder splitPaneBorder = new SplitPaneDividerBorder(table.getColor("SplitPane.highlight"), table.getColor("SplitPane.darkShadow"));
        return splitPaneBorder;
    }

    public static Border getTextFieldBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        FieldBorder textFieldBorder = new FieldBorder(table.getColor("TextField.shadow"), table.getColor("TextField.darkShadow"), table.getColor("TextField.light"), table.getColor("TextField.highlight"));
        return textFieldBorder;
    }

    public static Border getProgressBarBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.LineBorderUIResource progressBarBorder = new BorderUIResource.LineBorderUIResource(Color.green, 2);
        return progressBarBorder;
    }

    public static Border getInternalFrameBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        BorderUIResource.CompoundBorderUIResource internalFrameBorder = new BorderUIResource.CompoundBorderUIResource(new BevelBorder(0, table.getColor("InternalFrame.borderLight"), table.getColor("InternalFrame.borderHighlight"), table.getColor("InternalFrame.borderDarkShadow"), table.getColor("InternalFrame.borderShadow")), BorderFactory.createLineBorder(table.getColor("InternalFrame.borderColor"), 1));
        return internalFrameBorder;
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        protected Color highlight;
        protected Color shadow;

        public SplitPaneBorder(Color highlight, Color shadow) {
            this.highlight = highlight;
            this.shadow = shadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(c instanceof JSplitPane)) {
                return;
            }
            JSplitPane splitPane = (JSplitPane)c;
            Component child = splitPane.getLeftComponent();
            g.setColor(c.getBackground());
            g.drawRect(x, y, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                Rectangle cBounds;
                if (child != null) {
                    cBounds = child.getBounds();
                    g.setColor(this.shadow);
                    g.drawLine(0, 0, cBounds.width + 1, 0);
                    g.drawLine(0, 1, 0, cBounds.height + 1);
                    g.setColor(this.highlight);
                    g.drawLine(0, cBounds.height + 1, cBounds.width + 1, cBounds.height + 1);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    cBounds = child.getBounds();
                    int maxX = cBounds.x + cBounds.width;
                    int maxY = cBounds.y + cBounds.height;
                    g.setColor(this.shadow);
                    g.drawLine(cBounds.x - 1, 0, maxX, 0);
                    g.setColor(this.highlight);
                    g.drawLine(cBounds.x - 1, maxY, maxX, maxY);
                    g.drawLine(maxX, 0, maxX, maxY + 1);
                }
            } else {
                Rectangle cBounds;
                if (child != null) {
                    cBounds = child.getBounds();
                    g.setColor(this.shadow);
                    g.drawLine(0, 0, cBounds.width + 1, 0);
                    g.drawLine(0, 1, 0, cBounds.height);
                    g.setColor(this.highlight);
                    g.drawLine(1 + cBounds.width, 0, 1 + cBounds.width, cBounds.height + 1);
                    g.drawLine(0, cBounds.height + 1, 0, cBounds.height + 1);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    cBounds = child.getBounds();
                    int maxX = cBounds.x + cBounds.width;
                    int maxY = cBounds.y + cBounds.height;
                    g.setColor(this.shadow);
                    g.drawLine(0, cBounds.y - 1, 0, maxY);
                    g.drawLine(maxX, cBounds.y - 1, maxX, cBounds.y - 1);
                    g.setColor(this.highlight);
                    g.drawLine(0, maxY, cBounds.width + 1, maxY);
                    g.drawLine(maxX, cBounds.y, maxX, maxY);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    static class SplitPaneDividerBorder
    implements Border,
    UIResource {
        Color highlight;
        Color shadow;

        SplitPaneDividerBorder(Color highlight, Color shadow) {
            this.highlight = highlight;
            this.shadow = shadow;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!(c instanceof BasicSplitPaneDivider)) {
                return;
            }
            JSplitPane splitPane = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI().getSplitPane();
            Dimension size = c.getSize();
            Component child = splitPane.getLeftComponent();
            g.setColor(c.getBackground());
            g.drawRect(x, y, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                if (child != null) {
                    g.setColor(this.highlight);
                    g.drawLine(0, 0, 0, size.height);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    g.setColor(this.shadow);
                    g.drawLine(size.width - 1, 0, size.width - 1, size.height);
                }
            } else {
                if (child != null) {
                    g.setColor(this.highlight);
                    g.drawLine(0, 0, size.width, 0);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    g.setColor(this.shadow);
                    g.drawLine(0, size.height - 1, size.width, size.height - 1);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            JSplitPane splitPane;
            BasicSplitPaneUI bspui;
            Insets insets = new Insets(0, 0, 0, 0);
            if (c instanceof BasicSplitPaneDivider && (bspui = ((BasicSplitPaneDivider)c).getBasicSplitPaneUI()) != null && (splitPane = bspui.getSplitPane()) != null) {
                if (splitPane.getOrientation() == 1) {
                    insets.bottom = 0;
                    insets.top = 0;
                    insets.right = 1;
                    insets.left = 1;
                    return insets;
                }
                insets.bottom = 1;
                insets.top = 1;
                insets.right = 0;
                insets.left = 0;
                return insets;
            }
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class FieldBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public FieldBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            this.shadow = shadow;
            this.highlight = highlight;
            this.darkShadow = darkShadow;
            this.lightHighlight = lightHighlight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicGraphicsUtils.drawEtchedRect(g, x, y, width, height, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            }
            insets.top = margin != null ? 2 + margin.top : 2;
            insets.left = margin != null ? 2 + margin.left : 2;
            insets.bottom = margin != null ? 2 + margin.bottom : 2;
            insets.right = margin != null ? 2 + margin.right : 2;
            return insets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            } else if (c instanceof JToolBar) {
                JToolBar t = (JToolBar)c;
                margin = t.getMargin();
            } else if (c instanceof JTextComponent) {
                JTextComponent t = (JTextComponent)c;
                margin = t.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private Color shadow;
        private Color highlight;

        public MenuBarBorder(Color shadow, Color highlight) {
            this.shadow = shadow;
            this.highlight = highlight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.translate(x, y);
            g.setColor(this.shadow);
            SwingUtilities2.drawHLine(g, 0, width - 1, height - 2);
            g.setColor(this.highlight);
            SwingUtilities2.drawHLine(g, 0, width - 1, height - 1);
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(0, 0, 2, 0);
            return insets;
        }
    }

    public static class RadioButtonBorder
    extends ButtonBorder {
        public RadioButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                if (model.isArmed() && model.isPressed() || model.isSelected()) {
                    BasicGraphicsUtils.drawLoweredBezel(g, x, y, width, height, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                } else {
                    BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, b.isFocusPainted() && b.hasFocus(), this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
                }
            } else {
                BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
            }
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public ToggleButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BasicGraphicsUtils.drawBezel(g, x, y, width, height, false, false, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(2, 2, 2, 2);
            return insets;
        }
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Color shadow;
        protected Color darkShadow;
        protected Color highlight;
        protected Color lightHighlight;

        public ButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            this.shadow = shadow;
            this.darkShadow = darkShadow;
            this.highlight = highlight;
            this.lightHighlight = lightHighlight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            boolean isPressed = false;
            boolean isDefault = false;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                ButtonModel model = b.getModel();
                boolean bl = isPressed = model.isPressed() && model.isArmed();
                if (c instanceof JButton) {
                    isDefault = ((JButton)c).isDefaultButton();
                }
            }
            BasicGraphicsUtils.drawBezel(g, x, y, width, height, isPressed, isDefault, this.shadow, this.darkShadow, this.highlight, this.lightHighlight);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.set(2, 3, 3, 3);
            return insets;
        }
    }

    static class RolloverMarginBorder
    extends EmptyBorder {
        public RolloverMarginBorder() {
            super(3, 3, 3, 3);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            }
            if (margin == null || margin instanceof UIResource) {
                insets.left = this.left;
                insets.top = this.top;
                insets.right = this.right;
                insets.bottom = this.bottom;
            } else {
                insets.left = margin.left;
                insets.top = margin.top;
                insets.right = margin.right;
                insets.bottom = margin.bottom;
            }
            return insets;
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public RolloverButtonBorder(Color shadow, Color darkShadow, Color highlight, Color lightHighlight) {
            super(shadow, darkShadow, highlight, lightHighlight);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Color shade = this.shadow;
            Container p = b.getParent();
            if (p != null && p.getBackground().equals(this.shadow)) {
                shade = this.darkShadow;
            }
            if (model.isRollover() && (!model.isPressed() || model.isArmed()) || model.isSelected()) {
                Color oldColor = g.getColor();
                g.translate(x, y);
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g.setColor(shade);
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(this.lightHighlight);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    g.drawLine(0, h - 1, w - 1, h - 1);
                } else {
                    g.setColor(this.lightHighlight);
                    g.drawRect(0, 0, w - 1, h - 1);
                    g.setColor(shade);
                    g.drawLine(w - 1, 0, w - 1, h - 1);
                    g.drawLine(0, h - 1, w - 1, h - 1);
                }
                g.translate(-x, -y);
                g.setColor(oldColor);
            }
        }
    }
}

