/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.nimbus;

import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ImageCache {
    private final LinkedHashMap<Integer, PixelCountSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private final int maxSingleImagePixelSize;
    private int currentPixelCount = 0;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private static final ImageCache instance = new ImageCache();

    static ImageCache getInstance() {
        return instance;
    }

    public ImageCache() {
        this.maxPixelCount = 0x200000;
        this.maxSingleImagePixelSize = 90000;
    }

    public ImageCache(int maxPixelCount, int maxSingleImagePixelSize) {
        this.maxPixelCount = maxPixelCount;
        this.maxSingleImagePixelSize = maxSingleImagePixelSize;
    }

    public void flush() {
        this.lock.readLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isImageCachable(int w, int h) {
        return w * h < this.maxSingleImagePixelSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(GraphicsConfiguration config, int w, int h, Object ... args) {
        this.lock.readLock().lock();
        try {
            PixelCountSoftReference ref = this.map.get(this.hash(config, w, h, args));
            if (ref != null && ref.equals(config, w, h, args)) {
                Image image = (Image)ref.get();
                return image;
            }
            Image image = null;
            return image;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setImage(Image image, GraphicsConfiguration config, int w, int h, Object ... args) {
        if (!this.isImageCachable(w, h)) {
            return false;
        }
        int hash = this.hash(config, w, h, args);
        this.lock.writeLock().lock();
        try {
            PixelCountSoftReference ref = this.map.get(hash);
            if (ref != null && ref.get() == image) {
                boolean bl = true;
                return bl;
            }
            if (ref != null) {
                this.currentPixelCount -= ref.pixelCount;
                this.map.remove(hash);
            }
            int newPixelCount = image.getWidth(null) * image.getHeight(null);
            this.currentPixelCount += newPixelCount;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((ref = (PixelCountSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(ref.hash);
                    this.currentPixelCount -= ref.pixelCount;
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator<Map.Entry<Integer, PixelCountSoftReference>> mapIter = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && mapIter.hasNext()) {
                    Map.Entry<Integer, PixelCountSoftReference> entry = mapIter.next();
                    mapIter.remove();
                    Image img = (Image)entry.getValue().get();
                    if (img != null) {
                        img.flush();
                    }
                    this.currentPixelCount -= entry.getValue().pixelCount;
                }
            }
            this.map.put(hash, new PixelCountSoftReference(image, this.referenceQueue, newPixelCount, hash, config, w, h, args));
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private int hash(GraphicsConfiguration config, int w, int h, Object ... args) {
        int hash = config != null ? config.hashCode() : 0;
        hash = 31 * hash + w;
        hash = 31 * hash + h;
        hash = 31 * hash + Arrays.deepHashCode(args);
        return hash;
    }

    private static class PixelCountSoftReference
    extends SoftReference<Image> {
        private final int pixelCount;
        private final int hash;
        private final GraphicsConfiguration config;
        private final int w;
        private final int h;
        private final Object[] args;

        public PixelCountSoftReference(Image referent, ReferenceQueue<? super Image> q, int pixelCount, int hash, GraphicsConfiguration config, int w, int h, Object[] args) {
            super(referent, q);
            this.pixelCount = pixelCount;
            this.hash = hash;
            this.config = config;
            this.w = w;
            this.h = h;
            this.args = args;
        }

        public boolean equals(GraphicsConfiguration config, int w, int h, Object[] args) {
            return config == this.config && w == this.w && h == this.h && Arrays.equals(args, this.args);
        }
    }
}

