/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.ToDoubleFunction;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;
import sun.management.BaseOperatingSystemImpl;
import sun.management.VMManagement;

class OperatingSystemImpl
extends BaseOperatingSystemImpl
implements UnixOperatingSystemMXBean {
    private static final int MAX_ATTEMPTS_NUMBER = 10;
    private final Metrics containerMetrics;
    private ContainerCpuTicks systemLoadTicks = new SystemCpuTicks();
    private ContainerCpuTicks processLoadTicks = new ProcessCpuTicks();

    OperatingSystemImpl(VMManagement vm) {
        super(vm);
        this.containerMetrics = Container.metrics();
    }

    @Override
    public long getCommittedVirtualMemorySize() {
        return this.getCommittedVirtualMemorySize0();
    }

    @Override
    public long getTotalSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long limit = this.containerMetrics.getMemoryAndSwapLimit();
            long memLimit = this.containerMetrics.getMemoryLimit();
            if (limit >= 0L && memLimit >= 0L) {
                return limit - memLimit;
            }
        }
        return this.getTotalSwapSpaceSize0();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long memSwapLimit = this.containerMetrics.getMemoryAndSwapLimit();
            long memLimit = this.containerMetrics.getMemoryLimit();
            if (memSwapLimit >= 0L && memLimit >= 0L) {
                long deltaLimit = memSwapLimit - memLimit;
                if (deltaLimit <= 0L) {
                    return 0L;
                }
                for (int attempt = 0; attempt < 10; ++attempt) {
                    long freeSwap;
                    long deltaUsage;
                    long memSwapUsage = this.containerMetrics.getMemoryAndSwapUsage();
                    long memUsage = this.containerMetrics.getMemoryUsage();
                    if (memSwapUsage <= 0L || memUsage <= 0L || (deltaUsage = memSwapUsage - memUsage) < 0L || (freeSwap = deltaLimit - deltaUsage) < 0L) continue;
                    return freeSwap;
                }
            }
        }
        return this.getFreeSwapSpaceSize0();
    }

    @Override
    public long getProcessCpuTime() {
        return this.getProcessCpuTime0();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        if (this.containerMetrics != null) {
            long usage = this.containerMetrics.getMemoryUsage();
            long limit = this.containerMetrics.getMemoryLimit();
            if (usage > 0L && limit >= 0L) {
                return limit - usage;
            }
        }
        return this.getFreePhysicalMemorySize0();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        long limit;
        if (this.containerMetrics != null && (limit = this.containerMetrics.getMemoryLimit()) >= 0L) {
            return limit;
        }
        return this.getTotalPhysicalMemorySize0();
    }

    @Override
    public long getOpenFileDescriptorCount() {
        return this.getOpenFileDescriptorCount0();
    }

    @Override
    public long getMaxFileDescriptorCount() {
        return this.getMaxFileDescriptorCount0();
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.containerMetrics != null) {
            return this.systemLoadTicks.getContainerCpuLoad();
        }
        return this.getSystemCpuLoad0();
    }

    @Override
    public double getProcessCpuLoad() {
        if (this.containerMetrics != null) {
            return this.processLoadTicks.getContainerCpuLoad();
        }
        return this.getProcessCpuLoad0();
    }

    private boolean isCpuSetSameAsHostCpuSet() {
        if (this.containerMetrics != null && this.containerMetrics.getCpuSetCpus() != null) {
            return this.containerMetrics.getCpuSetCpus().length == this.getHostOnlineCpuCount0();
        }
        return false;
    }

    private native long getCommittedVirtualMemorySize0();

    private native long getFreePhysicalMemorySize0();

    private native long getFreeSwapSpaceSize0();

    private native long getMaxFileDescriptorCount0();

    private native long getOpenFileDescriptorCount0();

    private native long getProcessCpuTime0();

    private native double getProcessCpuLoad0();

    private native double getSystemCpuLoad0();

    private native long getTotalPhysicalMemorySize0();

    private native long getTotalSwapSpaceSize0();

    private native double getSingleCpuLoad0(int var1);

    private native int getHostConfiguredCpuCount0();

    private native int getHostOnlineCpuCount0();

    private native long getHostTotalCpuTicks0();

    private static native void initialize0();

    static {
        OperatingSystemImpl.initialize0();
    }

    private class SystemCpuTicks
    extends ContainerCpuTicks {
        private SystemCpuTicks() {
        }

        @Override
        protected DoubleSupplier defaultCpuLoadSupplier() {
            return () -> OperatingSystemImpl.this.getSystemCpuLoad0();
        }

        @Override
        protected ToDoubleFunction<int[]> cpuSetCalc() {
            return cpuSet -> {
                double systemLoad = 0.0;
                for (int cpu : cpuSet) {
                    double cpuLoad = OperatingSystemImpl.this.getSingleCpuLoad0(cpu);
                    if (cpuLoad < 0.0) {
                        return -1.0;
                    }
                    systemLoad += cpuLoad;
                }
                return systemLoad / (double)((int[])cpuSet).length;
            };
        }

        @Override
        protected LongSupplier cpuUsageSupplier() {
            return () -> OperatingSystemImpl.this.containerMetrics.getCpuUsage();
        }
    }

    private class ProcessCpuTicks
    extends ContainerCpuTicks {
        private ProcessCpuTicks() {
        }

        @Override
        protected DoubleSupplier defaultCpuLoadSupplier() {
            return () -> OperatingSystemImpl.this.getProcessCpuLoad0();
        }

        @Override
        protected ToDoubleFunction<int[]> cpuSetCalc() {
            return cpuSet -> {
                int totalCPUs = OperatingSystemImpl.this.getHostOnlineCpuCount0();
                int containerCPUs = OperatingSystemImpl.this.getAvailableProcessors();
                return Math.min(1.0, OperatingSystemImpl.this.getProcessCpuLoad0() * (double)totalCPUs / (double)containerCPUs);
            };
        }

        @Override
        protected LongSupplier cpuUsageSupplier() {
            return () -> OperatingSystemImpl.this.getProcessCpuTime();
        }
    }

    private abstract class ContainerCpuTicks {
        private long usageTicks = 0L;
        private long totalTicks = 0L;

        private ContainerCpuTicks() {
        }

        private double getUsageDividesTotal(long usageTicks, long totalTicks) {
            if (usageTicks < 0L || totalTicks <= 0L) {
                return -1.0;
            }
            long distance = usageTicks - this.usageTicks;
            this.usageTicks = usageTicks;
            long totalDistance = totalTicks - this.totalTicks;
            this.totalTicks = totalTicks;
            double systemLoad = 0.0;
            if (distance > 0L && totalDistance > 0L) {
                systemLoad = (double)distance / (double)totalDistance;
            }
            systemLoad = Math.max(0.0, systemLoad);
            systemLoad = Math.min(1.0, systemLoad);
            return systemLoad;
        }

        public double getContainerCpuLoad() {
            assert (OperatingSystemImpl.this.containerMetrics != null);
            long quota = OperatingSystemImpl.this.containerMetrics.getCpuQuota();
            long share = OperatingSystemImpl.this.containerMetrics.getCpuShares();
            if (quota > 0L) {
                long numPeriods = OperatingSystemImpl.this.containerMetrics.getCpuNumPeriods();
                long quotaNanos = TimeUnit.MICROSECONDS.toNanos(quota * numPeriods);
                return this.getUsageDividesTotal(this.cpuUsageSupplier().getAsLong(), quotaNanos);
            }
            if (share > 0L) {
                long hostTicks = OperatingSystemImpl.this.getHostTotalCpuTicks0();
                int totalCPUs = OperatingSystemImpl.this.getHostOnlineCpuCount0();
                int containerCPUs = OperatingSystemImpl.this.getAvailableProcessors();
                double scaleFactor = (double)containerCPUs / (double)totalCPUs;
                hostTicks = (long)((double)hostTicks * scaleFactor);
                return this.getUsageDividesTotal(this.cpuUsageSupplier().getAsLong(), hostTicks);
            }
            if (OperatingSystemImpl.this.isCpuSetSameAsHostCpuSet()) {
                return this.defaultCpuLoadSupplier().getAsDouble();
            }
            int[] cpuSet = OperatingSystemImpl.this.containerMetrics.getEffectiveCpuSetCpus();
            if (cpuSet == null || cpuSet.length <= 0) {
                cpuSet = OperatingSystemImpl.this.containerMetrics.getCpuSetCpus();
            }
            if (cpuSet == null) {
                return this.defaultCpuLoadSupplier().getAsDouble();
            }
            if (cpuSet.length > 0) {
                return this.cpuSetCalc().applyAsDouble(cpuSet);
            }
            return -1.0;
        }

        protected abstract DoubleSupplier defaultCpuLoadSupplier();

        protected abstract ToDoubleFunction<int[]> cpuSetCalc();

        protected abstract LongSupplier cpuUsageSupplier();
    }
}

