/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class PKCS9Attributes {
    private final Hashtable<ObjectIdentifier, PKCS9Attribute> attributes = new Hashtable(3);
    private final Hashtable<ObjectIdentifier, ObjectIdentifier> permittedAttributes;
    private final byte[] derEncoding;
    private boolean ignoreUnsupportedAttributes = false;

    public PKCS9Attributes(ObjectIdentifier[] permittedAttributes, DerInputStream in) throws IOException {
        if (permittedAttributes != null) {
            this.permittedAttributes = new Hashtable(permittedAttributes.length);
            for (int i = 0; i < permittedAttributes.length; ++i) {
                this.permittedAttributes.put(permittedAttributes[i], permittedAttributes[i]);
            }
        } else {
            this.permittedAttributes = null;
        }
        this.derEncoding = this.decode(in);
    }

    public PKCS9Attributes(DerInputStream in) throws IOException {
        this(in, false);
    }

    public PKCS9Attributes(DerInputStream in, boolean ignoreUnsupportedAttributes) throws IOException {
        this.ignoreUnsupportedAttributes = ignoreUnsupportedAttributes;
        this.derEncoding = this.decode(in);
        this.permittedAttributes = null;
    }

    public PKCS9Attributes(PKCS9Attribute[] attribs) throws IllegalArgumentException, IOException {
        for (int i = 0; i < attribs.length; ++i) {
            ObjectIdentifier oid = attribs[i].getOID();
            if (this.attributes.containsKey(oid)) {
                throw new IllegalArgumentException("PKCSAttribute " + attribs[i].getOID() + " duplicated while constructing PKCS9Attributes.");
            }
            this.attributes.put(oid, attribs[i]);
        }
        this.derEncoding = this.generateDerEncoding();
        this.permittedAttributes = null;
    }

    private byte[] decode(DerInputStream in) throws IOException {
        DerValue val = in.getDerValue();
        byte[] derEncoding = val.toByteArray();
        derEncoding[0] = 49;
        DerInputStream derIn = new DerInputStream(derEncoding);
        DerValue[] derVals = derIn.getSet(3, true);
        boolean reuseEncoding = true;
        for (int i = 0; i < derVals.length; ++i) {
            PKCS9Attribute attrib;
            try {
                attrib = new PKCS9Attribute(derVals[i]);
            }
            catch (ParsingException e) {
                if (this.ignoreUnsupportedAttributes) {
                    reuseEncoding = false;
                    continue;
                }
                throw e;
            }
            ObjectIdentifier oid = attrib.getOID();
            if (this.attributes.get(oid) != null) {
                throw new IOException("Duplicate PKCS9 attribute: " + oid);
            }
            if (this.permittedAttributes != null && !this.permittedAttributes.containsKey(oid)) {
                throw new IOException("Attribute " + oid + " not permitted in this attribute set");
            }
            this.attributes.put(oid, attrib);
        }
        return reuseEncoding ? derEncoding : this.generateDerEncoding();
    }

    public void encode(byte tag, OutputStream out) throws IOException {
        out.write(tag);
        out.write(this.derEncoding, 1, this.derEncoding.length - 1);
    }

    private byte[] generateDerEncoding() throws IOException {
        DerOutputStream out = new DerOutputStream();
        Object[] attribVals = this.attributes.values().toArray();
        out.putOrderedSetOf((byte)49, PKCS9Attributes.castToDerEncoder(attribVals));
        return out.toByteArray();
    }

    public byte[] getDerEncoding() throws IOException {
        return (byte[])this.derEncoding.clone();
    }

    public PKCS9Attribute getAttribute(ObjectIdentifier oid) {
        return this.attributes.get(oid);
    }

    public PKCS9Attribute getAttribute(String name) {
        return this.attributes.get(PKCS9Attribute.getOID(name));
    }

    public PKCS9Attribute[] getAttributes() {
        PKCS9Attribute[] attribs = new PKCS9Attribute[this.attributes.size()];
        int j = 0;
        for (int i = 1; i < PKCS9Attribute.PKCS9_OIDS.length && j < attribs.length; ++i) {
            if (PKCS9Attribute.PKCS9_OIDS[i] == null) continue;
            attribs[j] = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i]);
            if (attribs[j] == null) continue;
            ++j;
        }
        return attribs;
    }

    public Object getAttributeValue(ObjectIdentifier oid) throws IOException {
        try {
            Object value = this.getAttribute(oid).getValue();
            return value;
        }
        catch (NullPointerException ex) {
            throw new IOException("No value found for attribute " + oid);
        }
    }

    public Object getAttributeValue(String name) throws IOException {
        ObjectIdentifier oid = PKCS9Attribute.getOID(name);
        if (oid == null) {
            throw new IOException("Attribute name " + name + " not recognized or not supported.");
        }
        return this.getAttributeValue(oid);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(200);
        buf.append("PKCS9 Attributes: [\n\t");
        boolean first = true;
        for (int i = 1; i < PKCS9Attribute.PKCS9_OIDS.length; ++i) {
            PKCS9Attribute value;
            if (PKCS9Attribute.PKCS9_OIDS[i] == null || (value = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i])) == null) continue;
            if (first) {
                first = false;
            } else {
                buf.append(";\n\t");
            }
            buf.append(value);
        }
        buf.append("\n\t] (end PKCS9 Attributes)");
        return buf.toString();
    }

    static DerEncoder[] castToDerEncoder(Object[] objs) {
        DerEncoder[] encoders = new DerEncoder[objs.length];
        for (int i = 0; i < encoders.length; ++i) {
            encoders[i] = (DerEncoder)objs[i];
        }
        return encoders;
    }
}

