/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.security.URIParameter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.ConfigurationSpi;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;
import sun.security.util.ResourcesMgr;

public final class ConfigFile
extends Configuration {
    private final Spi spi = new Spi();

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String appName) {
        return this.spi.engineGetAppConfigurationEntry(appName);
    }

    @Override
    public synchronized void refresh() {
        this.spi.engineRefresh();
    }

    public static final class Spi
    extends ConfigurationSpi {
        private URL url;
        private boolean expandProp = true;
        private Map<String, List<AppConfigurationEntry>> configuration;
        private int linenum;
        private StreamTokenizer st;
        private int lookahead;
        private static Debug debugConfig = Debug.getInstance("configfile");
        private static Debug debugParser = Debug.getInstance("configparser");

        public Spi() {
            try {
                this.init();
            }
            catch (IOException ioe) {
                throw new SecurityException(ioe);
            }
        }

        public Spi(URI uri) {
            try {
                this.url = uri.toURL();
                this.init();
            }
            catch (IOException ioe) {
                throw new SecurityException(ioe);
            }
        }

        public Spi(final Configuration.Parameters params) throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws IOException {
                        if (params == null) {
                            this.init();
                        } else {
                            if (!(params instanceof URIParameter)) {
                                throw new IllegalArgumentException("Unrecognized parameter: " + params);
                            }
                            URIParameter uriParam = (URIParameter)params;
                            url = uriParam.getURI().toURL();
                            this.init();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (IOException)pae.getException();
            }
        }

        private void init() throws IOException {
            String config_url;
            String extra_config;
            boolean initialized = false;
            String expand = Security.getProperty("policy.expandProperties");
            if (expand == null) {
                expand = System.getProperty("policy.expandProperties");
            }
            if ("false".equals(expand)) {
                this.expandProp = false;
            }
            HashMap<String, List<AppConfigurationEntry>> newConfig = new HashMap<String, List<AppConfigurationEntry>>();
            if (this.url != null) {
                if (debugConfig != null) {
                    debugConfig.println("reading " + this.url);
                }
                this.init(this.url, newConfig);
                this.configuration = newConfig;
                return;
            }
            String allowSys = Security.getProperty("policy.allowSystemProperty");
            if ("true".equalsIgnoreCase(allowSys) && (extra_config = System.getProperty("java.security.auth.login.config")) != null) {
                boolean overrideAll = false;
                if (extra_config.startsWith("=")) {
                    overrideAll = true;
                    extra_config = extra_config.substring(1);
                }
                try {
                    extra_config = PropertyExpander.expand(extra_config);
                }
                catch (PropertyExpander.ExpandException peee) {
                    throw this.ioException("Unable.to.properly.expand.config", extra_config);
                }
                URL configURL = null;
                try {
                    configURL = new URL(extra_config);
                }
                catch (MalformedURLException mue) {
                    File configFile = new File(extra_config);
                    if (configFile.exists()) {
                        configURL = configFile.toURI().toURL();
                    }
                    throw this.ioException("extra.config.No.such.file.or.directory.", extra_config);
                }
                if (debugConfig != null) {
                    debugConfig.println("reading " + configURL);
                }
                this.init(configURL, newConfig);
                initialized = true;
                if (overrideAll) {
                    if (debugConfig != null) {
                        debugConfig.println("overriding other policies!");
                    }
                    this.configuration = newConfig;
                    return;
                }
            }
            int n = 1;
            while ((config_url = Security.getProperty("login.config.url." + n)) != null) {
                try {
                    config_url = PropertyExpander.expand(config_url).replace(File.separatorChar, '/');
                    if (debugConfig != null) {
                        debugConfig.println("\tReading config: " + config_url);
                    }
                    this.init(new URL(config_url), newConfig);
                    initialized = true;
                }
                catch (PropertyExpander.ExpandException peee) {
                    throw this.ioException("Unable.to.properly.expand.config", config_url);
                }
                ++n;
            }
            if (!initialized && n == 1 && config_url == null) {
                String userConfigFile;
                if (debugConfig != null) {
                    debugConfig.println("\tReading Policy from ~/.java.login.config");
                }
                if (new File(userConfigFile = (config_url = System.getProperty("user.home")) + File.separatorChar + ".java.login.config").exists()) {
                    this.init(new File(userConfigFile).toURI().toURL(), newConfig);
                }
            }
            this.configuration = newConfig;
        }

        private void init(URL config, Map<String, List<AppConfigurationEntry>> newConfig) throws IOException {
            try (InputStreamReader isr = new InputStreamReader(this.getInputStream(config), "UTF-8");){
                this.readConfig(isr, newConfig);
            }
            catch (FileNotFoundException fnfe) {
                if (debugConfig != null) {
                    debugConfig.println(fnfe.toString());
                }
                throw new IOException(ResourcesMgr.getString("Configuration.Error.No.such.file.or.directory", "sun.security.util.AuthResources"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppConfigurationEntry[] engineGetAppConfigurationEntry(String applicationName) {
            List<AppConfigurationEntry> list = null;
            Map<String, List<AppConfigurationEntry>> map = this.configuration;
            synchronized (map) {
                list = this.configuration.get(applicationName);
            }
            if (list == null || list.size() == 0) {
                return null;
            }
            AppConfigurationEntry[] entries = new AppConfigurationEntry[list.size()];
            Iterator<AppConfigurationEntry> iterator = list.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                AppConfigurationEntry e = iterator.next();
                entries[i] = new AppConfigurationEntry(e.getLoginModuleName(), e.getControlFlag(), e.getOptions());
                ++i;
            }
            return entries;
        }

        @Override
        public synchronized void engineRefresh() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new AuthPermission("refreshLoginConfiguration"));
            }
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        this.init();
                    }
                    catch (IOException ioe) {
                        throw new SecurityException(ioe.getLocalizedMessage(), ioe);
                    }
                    return null;
                }
            });
        }

        private void readConfig(Reader reader, Map<String, List<AppConfigurationEntry>> newConfig) throws IOException {
            this.linenum = 1;
            if (!(reader instanceof BufferedReader)) {
                reader = new BufferedReader(reader);
            }
            this.st = new StreamTokenizer(reader);
            this.st.quoteChar(34);
            this.st.wordChars(36, 36);
            this.st.wordChars(95, 95);
            this.st.wordChars(45, 45);
            this.st.wordChars(42, 42);
            this.st.lowerCaseMode(false);
            this.st.slashSlashComments(true);
            this.st.slashStarComments(true);
            this.st.eolIsSignificant(true);
            this.lookahead = this.nextToken();
            while (this.lookahead != -1) {
                this.parseLoginEntry(newConfig);
            }
        }

        private void parseLoginEntry(Map<String, List<AppConfigurationEntry>> newConfig) throws IOException {
            LinkedList<AppConfigurationEntry> configEntries = new LinkedList<AppConfigurationEntry>();
            String appName = this.st.sval;
            this.lookahead = this.nextToken();
            if (debugParser != null) {
                debugParser.println("\tReading next config entry: " + appName);
            }
            this.match("{");
            while (!this.peek("}")) {
                AppConfigurationEntry.LoginModuleControlFlag controlFlag;
                String sflag;
                String moduleClass = this.match("module class name");
                switch (sflag = this.match("controlFlag").toUpperCase(Locale.ENGLISH)) {
                    case "REQUIRED": {
                        controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                        break;
                    }
                    case "REQUISITE": {
                        controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                        break;
                    }
                    case "SUFFICIENT": {
                        controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                        break;
                    }
                    case "OPTIONAL": {
                        controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                        break;
                    }
                    default: {
                        throw this.ioException("Configuration.Error.Invalid.control.flag.flag", sflag);
                    }
                }
                HashMap<String, String> options = new HashMap<String, String>();
                while (!this.peek(";")) {
                    String key = this.match("option key");
                    this.match("=");
                    try {
                        options.put(key, this.expand(this.match("option value")));
                    }
                    catch (PropertyExpander.ExpandException peee) {
                        throw new IOException(peee.getLocalizedMessage());
                    }
                }
                this.lookahead = this.nextToken();
                if (debugParser != null) {
                    debugParser.println("\t\t" + moduleClass + ", " + sflag);
                    for (String key : options.keySet()) {
                        debugParser.println("\t\t\t" + key + "=" + (String)options.get(key));
                    }
                }
                configEntries.add(new AppConfigurationEntry(moduleClass, controlFlag, options));
            }
            this.match("}");
            this.match(";");
            if (newConfig.containsKey(appName)) {
                throw this.ioException("Configuration.Error.Can.not.specify.multiple.entries.for.appName", appName);
            }
            newConfig.put(appName, configEntries);
        }

        private String match(String expect) throws IOException {
            String value = null;
            switch (this.lookahead) {
                case -1: {
                    throw this.ioException("Configuration.Error.expected.expect.read.end.of.file.", expect);
                }
                case -3: 
                case 34: {
                    if (expect.equalsIgnoreCase("module class name") || expect.equalsIgnoreCase("controlFlag") || expect.equalsIgnoreCase("option key") || expect.equalsIgnoreCase("option value")) {
                        value = this.st.sval;
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.found.value.", new Integer(this.linenum), expect, this.st.sval);
                }
                case 123: {
                    if (expect.equalsIgnoreCase("{")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), expect, this.st.sval);
                }
                case 59: {
                    if (expect.equalsIgnoreCase(";")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), expect, this.st.sval);
                }
                case 125: {
                    if (expect.equalsIgnoreCase("}")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), expect, this.st.sval);
                }
                case 61: {
                    if (expect.equalsIgnoreCase("=")) {
                        this.lookahead = this.nextToken();
                        break;
                    }
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.", new Integer(this.linenum), expect, this.st.sval);
                }
                default: {
                    throw this.ioException("Configuration.Error.Line.line.expected.expect.found.value.", new Integer(this.linenum), expect, this.st.sval);
                }
            }
            return value;
        }

        private boolean peek(String expect) {
            switch (this.lookahead) {
                case 44: {
                    return expect.equalsIgnoreCase(",");
                }
                case 59: {
                    return expect.equalsIgnoreCase(";");
                }
                case 123: {
                    return expect.equalsIgnoreCase("{");
                }
                case 125: {
                    return expect.equalsIgnoreCase("}");
                }
            }
            return false;
        }

        private int nextToken() throws IOException {
            int tok;
            while ((tok = this.st.nextToken()) == 10) {
                ++this.linenum;
            }
            return tok;
        }

        private InputStream getInputStream(URL url) throws IOException {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                try {
                    return url.openStream();
                }
                catch (Exception e) {
                    String file = url.getPath();
                    if (url.getHost().length() > 0) {
                        file = "//" + url.getHost() + file;
                    }
                    if (debugConfig != null) {
                        debugConfig.println("cannot read " + url + ", try " + file);
                    }
                    return new FileInputStream(file);
                }
            }
            return url.openStream();
        }

        private String expand(String value) throws PropertyExpander.ExpandException, IOException {
            if (value.isEmpty()) {
                return value;
            }
            if (!this.expandProp) {
                return value;
            }
            String s = PropertyExpander.expand(value);
            if (s == null || s.length() == 0) {
                throw this.ioException("Configuration.Error.Line.line.system.property.value.expanded.to.empty.value", new Integer(this.linenum), value);
            }
            return s;
        }

        private IOException ioException(String resourceKey, Object ... args) {
            MessageFormat form = new MessageFormat(ResourcesMgr.getString(resourceKey, "sun.security.util.AuthResources"));
            return new IOException(form.format(args));
        }
    }
}

