/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.text.Collator;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.security.util.SecurityProperties;

public class KeyStoreUtil {
    private static final String JKS = "jks";
    private static final String SYSTEM_CA_CERTS_PROP = "security.systemCACerts";

    private KeyStoreUtil() {
    }

    public static boolean isSelfSigned(X509Certificate cert) {
        return KeyStoreUtil.signedBy(cert, cert);
    }

    public static boolean signedBy(X509Certificate end, X509Certificate ca) {
        if (!ca.getSubjectX500Principal().equals(end.getIssuerX500Principal())) {
            return false;
        }
        try {
            end.verify(ca.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindowsKeyStore(String storetype) {
        return storetype != null && (storetype.equalsIgnoreCase("Windows-MY") || storetype.equalsIgnoreCase("Windows-ROOT"));
    }

    public static String niceStoreTypeName(String storetype) {
        if (storetype.equalsIgnoreCase("Windows-MY")) {
            return "Windows-MY";
        }
        if (storetype.equalsIgnoreCase("Windows-ROOT")) {
            return "Windows-ROOT";
        }
        return storetype.toUpperCase(Locale.ENGLISH);
    }

    public static String getCacertsKeyStorePath() {
        String systemDB = SecurityProperties.privilegedGetOverridable(SYSTEM_CA_CERTS_PROP);
        if (systemDB != null && !"".equals(systemDB) && new File(systemDB).isFile()) {
            return systemDB;
        }
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts";
    }

    public static KeyStore getCacertsKeyStore() throws Exception {
        File file = new File(KeyStoreUtil.getCacertsKeyStorePath());
        if (!file.exists()) {
            return null;
        }
        KeyStore caks = null;
        try (FileInputStream fis = new FileInputStream(file);){
            caks = KeyStore.getInstance(JKS);
            caks.load(fis, null);
        }
        return caks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getPassWithModifier(String modifier, String arg, ResourceBundle rb, Collator collator) {
        if (modifier == null) {
            return arg.toCharArray();
        }
        if (collator.compare(modifier, "env") == 0) {
            String value2 = System.getenv(arg);
            if (value2 != null) return value2.toCharArray();
            System.err.println(rb.getString("Cannot.find.environment.variable.") + arg);
            return null;
        }
        if (collator.compare(modifier, "file") != 0) {
            System.err.println(rb.getString("Unknown.password.type.") + modifier);
            return null;
        }
        try {
            URL url = null;
            try {
                url = new URL(arg);
            }
            catch (MalformedURLException mue) {
                File f = new File(arg);
                if (!f.exists()) {
                    System.err.println(rb.getString("Cannot.find.file.") + arg);
                    return null;
                }
                url = f.toURI().toURL();
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));){
                String value = br.readLine();
                if (value == null) {
                    char[] cArray2 = new char[]{};
                    return cArray2;
                }
                char[] cArray = value.toCharArray();
                return cArray;
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe);
            return null;
        }
    }
}

