/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.gif;

import com.sun.imageio.plugins.common.ReaderUtil;
import com.sun.imageio.plugins.gif.GIFImageMetadata;
import com.sun.imageio.plugins.gif.GIFStreamMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class GIFImageReader
extends ImageReader {
    ImageInputStream stream = null;
    boolean gotHeader = false;
    GIFStreamMetadata streamMetadata = null;
    int currIndex = -1;
    GIFImageMetadata imageMetadata = null;
    List imageStartPosition = new ArrayList();
    int imageMetadataLength;
    int numImages = -1;
    byte[] block = new byte[255];
    int blockLength = 0;
    int bitPos = 0;
    int nextByte = 0;
    int initCodeSize;
    int clearCode;
    int eofCode;
    int next32Bits = 0;
    boolean lastBlockFound = false;
    BufferedImage theImage = null;
    WritableRaster theTile = null;
    int width = -1;
    int height = -1;
    int streamX = -1;
    int streamY = -1;
    int rowsDone = 0;
    int interlacePass = 0;
    private byte[] fallbackColorTable = null;
    static final int[] interlaceIncrement = new int[]{8, 8, 4, 2, -1};
    static final int[] interlaceOffset = new int[]{0, 4, 2, 1, -1};
    Rectangle sourceRegion;
    int sourceXSubsampling;
    int sourceYSubsampling;
    int sourceMinProgressivePass;
    int sourceMaxProgressivePass;
    Point destinationOffset;
    Rectangle destinationRegion;
    int updateMinY;
    int updateYStep;
    boolean decodeThisRow = true;
    int destY = 0;
    byte[] rowBuf;
    private static byte[] defaultPalette = null;

    public GIFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        if (input != null) {
            if (!(input instanceof ImageInputStream)) {
                throw new IllegalArgumentException("input not an ImageInputStream!");
            }
            this.stream = (ImageInputStream)input;
        } else {
            this.stream = null;
        }
        this.resetStreamSettings();
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        if (this.seekForwardOnly && allowSearch) {
            throw new IllegalStateException("seekForwardOnly and allowSearch can't both be true!");
        }
        if (this.numImages > 0) {
            return this.numImages;
        }
        if (allowSearch) {
            this.numImages = this.locateImage(Integer.MAX_VALUE) + 1;
        }
        return this.numImages;
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex < this.minIndex) {
            throw new IndexOutOfBoundsException("imageIndex < minIndex!");
        }
        if (this.seekForwardOnly) {
            this.minIndex = imageIndex;
        }
    }

    @Override
    public int getWidth(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageWidth;
    }

    @Override
    public int getHeight(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        return this.imageMetadata.imageHeight;
    }

    private ImageTypeSpecifier createIndexed(byte[] r, byte[] g, byte[] b, int bits) {
        SampleModel sampleModel;
        IndexColorModel colorModel;
        if (this.imageMetadata.transparentColorFlag) {
            int idx = Math.min(this.imageMetadata.transparentColorIndex, r.length - 1);
            colorModel = new IndexColorModel(bits, r.length, r, g, b, idx);
        } else {
            colorModel = new IndexColorModel(bits, r.length, r, g, b);
        }
        if (bits == 8) {
            int[] bandOffsets = new int[]{0};
            sampleModel = new PixelInterleavedSampleModel(0, 1, 1, 1, 1, bandOffsets);
        } else {
            sampleModel = new MultiPixelPackedSampleModel(0, 1, 1, bits);
        }
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    public Iterator getImageTypes(int imageIndex) throws IIOException {
        int length;
        byte[] colorTable;
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException();
        }
        this.readMetadata();
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>(1);
        if (this.imageMetadata.localColorTable != null) {
            colorTable = this.imageMetadata.localColorTable;
            this.fallbackColorTable = this.imageMetadata.localColorTable;
        } else {
            colorTable = this.streamMetadata.globalColorTable;
        }
        if (colorTable == null) {
            if (this.fallbackColorTable == null) {
                this.processWarningOccurred("Use default color table.");
                this.fallbackColorTable = GIFImageReader.getDefaultPalette();
            }
            colorTable = this.fallbackColorTable;
        }
        int bits = (length = colorTable.length / 3) == 2 ? 1 : (length == 4 ? 2 : (length == 8 || length == 16 ? 4 : 8));
        int lutLength = 1 << bits;
        byte[] r = new byte[lutLength];
        byte[] g = new byte[lutLength];
        byte[] b = new byte[lutLength];
        int rgbIndex = 0;
        for (int i = 0; i < length; ++i) {
            r[i] = colorTable[rgbIndex++];
            g[i] = colorTable[rgbIndex++];
            b[i] = colorTable[rgbIndex++];
        }
        l.add(this.createIndexed(r, g, b, bits));
        return l.iterator();
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IIOException {
        this.readHeader();
        return this.streamMetadata;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IIOException {
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException("Bad image index!");
        }
        this.readMetadata();
        return this.imageMetadata;
    }

    private void initNext32Bits() {
        this.next32Bits = this.block[0] & 0xFF;
        this.next32Bits |= (this.block[1] & 0xFF) << 8;
        this.next32Bits |= (this.block[2] & 0xFF) << 16;
        this.next32Bits |= this.block[3] << 24;
        this.nextByte = 4;
    }

    private int getCode(int codeSize, int codeMask) throws IOException {
        if (this.bitPos + codeSize > 32) {
            return this.eofCode;
        }
        int code = this.next32Bits >> this.bitPos & codeMask;
        this.bitPos += codeSize;
        while (this.bitPos >= 8 && !this.lastBlockFound) {
            this.next32Bits >>>= 8;
            this.bitPos -= 8;
            if (this.nextByte >= this.blockLength) {
                int nbytes;
                this.blockLength = this.stream.readUnsignedByte();
                if (this.blockLength == 0) {
                    this.lastBlockFound = true;
                    return code;
                }
                int off = 0;
                for (int left = this.blockLength; left > 0; left -= nbytes) {
                    nbytes = this.stream.read(this.block, off, left);
                    off += nbytes;
                }
                this.nextByte = 0;
            }
            this.next32Bits |= this.block[this.nextByte++] << 24;
        }
        return code;
    }

    public void initializeStringTable(int[] prefix, byte[] suffix, byte[] initial, int[] length) {
        int i;
        int numEntries = 1 << this.initCodeSize;
        for (i = 0; i < numEntries; ++i) {
            prefix[i] = -1;
            suffix[i] = (byte)i;
            initial[i] = (byte)i;
            length[i] = 1;
        }
        for (i = numEntries; i < 4096; ++i) {
            prefix[i] = -1;
            length[i] = 1;
        }
    }

    private void outputRow() {
        int width = Math.min(this.sourceRegion.width, this.destinationRegion.width * this.sourceXSubsampling);
        int destX = this.destinationRegion.x;
        if (this.sourceXSubsampling == 1) {
            this.theTile.setDataElements(destX, this.destY, width, 1, this.rowBuf);
        } else {
            int x = 0;
            while (x < width) {
                this.theTile.setSample(destX, this.destY, 0, this.rowBuf[x] & 0xFF);
                x += this.sourceXSubsampling;
                ++destX;
            }
        }
        if (this.updateListeners != null) {
            int[] bands = new int[]{0};
            this.processImageUpdate(this.theImage, destX, this.destY, width, 1, 1, this.updateYStep, bands);
        }
    }

    private void computeDecodeThisRow() {
        this.decodeThisRow = this.destY < this.destinationRegion.y + this.destinationRegion.height && this.streamY >= this.sourceRegion.y && this.streamY < this.sourceRegion.y + this.sourceRegion.height && (this.streamY - this.sourceRegion.y) % this.sourceYSubsampling == 0;
    }

    private void outputPixels(byte[] string, int len) {
        if (this.interlacePass < this.sourceMinProgressivePass || this.interlacePass > this.sourceMaxProgressivePass) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            if (this.streamX >= this.sourceRegion.x) {
                this.rowBuf[this.streamX - this.sourceRegion.x] = string[i];
            }
            ++this.streamX;
            if (this.streamX != this.width) continue;
            ++this.rowsDone;
            this.processImageProgress(100.0f * (float)this.rowsDone / (float)this.height);
            if (this.decodeThisRow) {
                this.outputRow();
            }
            this.streamX = 0;
            if (this.imageMetadata.interlaceFlag) {
                this.streamY += interlaceIncrement[this.interlacePass];
                if (this.streamY >= this.height) {
                    if (this.updateListeners != null) {
                        this.processPassComplete(this.theImage);
                    }
                    ++this.interlacePass;
                    if (this.interlacePass > this.sourceMaxProgressivePass) {
                        return;
                    }
                    this.streamY = interlaceOffset[this.interlacePass];
                    this.startPass(this.interlacePass);
                }
            } else {
                ++this.streamY;
            }
            this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
            this.computeDecodeThisRow();
        }
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.streamMetadata = new GIFStreamMetadata();
        try {
            this.stream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            byte[] signature = new byte[6];
            this.stream.readFully(signature);
            StringBuffer version = new StringBuffer(3);
            version.append((char)signature[3]);
            version.append((char)signature[4]);
            version.append((char)signature[5]);
            this.streamMetadata.version = version.toString();
            this.streamMetadata.logicalScreenWidth = this.stream.readUnsignedShort();
            this.streamMetadata.logicalScreenHeight = this.stream.readUnsignedShort();
            int packedFields = this.stream.readUnsignedByte();
            boolean globalColorTableFlag = (packedFields & 0x80) != 0;
            this.streamMetadata.colorResolution = (packedFields >> 4 & 7) + 1;
            this.streamMetadata.sortFlag = (packedFields & 8) != 0;
            int numGCTEntries = 1 << (packedFields & 7) + 1;
            this.streamMetadata.backgroundColorIndex = this.stream.readUnsignedByte();
            this.streamMetadata.pixelAspectRatio = this.stream.readUnsignedByte();
            if (globalColorTableFlag) {
                this.streamMetadata.globalColorTable = new byte[3 * numGCTEntries];
                this.stream.readFully(this.streamMetadata.globalColorTable);
            } else {
                this.streamMetadata.globalColorTable = null;
            }
            this.imageStartPosition.add(this.stream.getStreamPosition());
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading header!", e);
        }
        this.gotHeader = true;
    }

    private boolean skipImage() throws IIOException {
        try {
            while (true) {
                int length;
                int blockType;
                if ((blockType = this.stream.readUnsignedByte()) == 44) {
                    this.stream.skipBytes(8);
                    int packedFields = this.stream.readUnsignedByte();
                    if ((packedFields & 0x80) != 0) {
                        int bits = (packedFields & 7) + 1;
                        this.stream.skipBytes(3 * (1 << bits));
                    }
                    this.stream.skipBytes(1);
                    length = 0;
                    do {
                        length = this.stream.readUnsignedByte();
                        this.stream.skipBytes(length);
                    } while (length > 0);
                    return true;
                }
                if (blockType == 59) {
                    return false;
                }
                if (blockType == 33) {
                    int label = this.stream.readUnsignedByte();
                    length = 0;
                    do {
                        length = this.stream.readUnsignedByte();
                        this.stream.skipBytes(length);
                    } while (length > 0);
                    continue;
                }
                if (blockType == 0) {
                    return false;
                }
                int length2 = 0;
                do {
                    length2 = this.stream.readUnsignedByte();
                    this.stream.skipBytes(length2);
                } while (length2 > 0);
            }
        }
        catch (EOFException e) {
            return false;
        }
        catch (IOException e) {
            throw new IIOException("I/O error locating image!", e);
        }
    }

    private int locateImage(int imageIndex) throws IIOException {
        this.readHeader();
        try {
            int index;
            Long l = (Long)this.imageStartPosition.get(index);
            this.stream.seek(l);
            for (index = Math.min(imageIndex, this.imageStartPosition.size() - 1); index < imageIndex; ++index) {
                if (!this.skipImage()) {
                    return --index;
                }
                Long l1 = new Long(this.stream.getStreamPosition());
                this.imageStartPosition.add(l1);
            }
        }
        catch (IOException e) {
            throw new IIOException("Couldn't seek!", e);
        }
        if (this.currIndex != imageIndex) {
            this.imageMetadata = null;
        }
        this.currIndex = imageIndex;
        return imageIndex;
    }

    private byte[] concatenateBlocks() throws IOException {
        int length;
        byte[] data = new byte[]{};
        while ((length = this.stream.readUnsignedByte()) != 0) {
            byte[] newData = new byte[data.length + length];
            System.arraycopy(data, 0, newData, 0, data.length);
            this.stream.readFully(newData, data.length, length);
            data = newData;
        }
        return data;
    }

    private void readMetadata() throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        try {
            int blockType;
            this.imageMetadata = new GIFImageMetadata();
            long startPosition = this.stream.getStreamPosition();
            while (true) {
                if ((blockType = this.stream.readUnsignedByte()) == 44) {
                    this.imageMetadata.imageLeftPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageTopPosition = this.stream.readUnsignedShort();
                    this.imageMetadata.imageWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.imageHeight = this.stream.readUnsignedShort();
                    int idPackedFields = this.stream.readUnsignedByte();
                    boolean localColorTableFlag = (idPackedFields & 0x80) != 0;
                    this.imageMetadata.interlaceFlag = (idPackedFields & 0x40) != 0;
                    this.imageMetadata.sortFlag = (idPackedFields & 0x20) != 0;
                    int numLCTEntries = 1 << (idPackedFields & 7) + 1;
                    if (localColorTableFlag) {
                        this.imageMetadata.localColorTable = new byte[3 * numLCTEntries];
                        this.stream.readFully(this.imageMetadata.localColorTable);
                    } else {
                        this.imageMetadata.localColorTable = null;
                    }
                    this.imageMetadataLength = (int)(this.stream.getStreamPosition() - startPosition);
                    return;
                }
                if (blockType != 33) break;
                int label = this.stream.readUnsignedByte();
                if (label == 249) {
                    int gceLength = this.stream.readUnsignedByte();
                    int gcePackedFields = this.stream.readUnsignedByte();
                    this.imageMetadata.disposalMethod = gcePackedFields >> 2 & 3;
                    this.imageMetadata.userInputFlag = (gcePackedFields & 2) != 0;
                    this.imageMetadata.transparentColorFlag = (gcePackedFields & 1) != 0;
                    this.imageMetadata.delayTime = this.stream.readUnsignedShort();
                    this.imageMetadata.transparentColorIndex = this.stream.readUnsignedByte();
                    int n = this.stream.readUnsignedByte();
                    continue;
                }
                if (label == 1) {
                    int length = this.stream.readUnsignedByte();
                    this.imageMetadata.hasPlainTextExtension = true;
                    this.imageMetadata.textGridLeft = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridTop = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridWidth = this.stream.readUnsignedShort();
                    this.imageMetadata.textGridHeight = this.stream.readUnsignedShort();
                    this.imageMetadata.characterCellWidth = this.stream.readUnsignedByte();
                    this.imageMetadata.characterCellHeight = this.stream.readUnsignedByte();
                    this.imageMetadata.textForegroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.textBackgroundColor = this.stream.readUnsignedByte();
                    this.imageMetadata.text = this.concatenateBlocks();
                    continue;
                }
                if (label == 254) {
                    byte[] comment = this.concatenateBlocks();
                    if (this.imageMetadata.comments == null) {
                        this.imageMetadata.comments = new ArrayList();
                    }
                    this.imageMetadata.comments.add(comment);
                    continue;
                }
                if (label == 255) {
                    int blockSize = this.stream.readUnsignedByte();
                    byte[] applicationID = new byte[8];
                    byte[] authCode = new byte[3];
                    byte[] blockData = new byte[blockSize];
                    this.stream.readFully(blockData);
                    int offset = this.copyData(blockData, 0, applicationID);
                    offset = this.copyData(blockData, offset, authCode);
                    byte[] applicationData = this.concatenateBlocks();
                    if (offset < blockSize) {
                        int len = blockSize - offset;
                        byte[] data = new byte[len + applicationData.length];
                        System.arraycopy(blockData, offset, data, 0, len);
                        System.arraycopy(applicationData, 0, data, len, applicationData.length);
                        applicationData = data;
                    }
                    if (this.imageMetadata.applicationIDs == null) {
                        this.imageMetadata.applicationIDs = new ArrayList();
                        this.imageMetadata.authenticationCodes = new ArrayList();
                        this.imageMetadata.applicationData = new ArrayList();
                    }
                    this.imageMetadata.applicationIDs.add(applicationID);
                    this.imageMetadata.authenticationCodes.add(authCode);
                    this.imageMetadata.applicationData.add(applicationData);
                    continue;
                }
                int length = 0;
                do {
                    length = this.stream.readUnsignedByte();
                    this.stream.skipBytes(length);
                } while (length > 0);
            }
            if (blockType == 59) {
                throw new IndexOutOfBoundsException("Attempt to read past end of image sequence!");
            }
            throw new IIOException("Unexpected block type " + blockType + "!");
        }
        catch (IIOException iioe) {
            throw iioe;
        }
        catch (IOException ioe) {
            throw new IIOException("I/O error reading image metadata!", ioe);
        }
    }

    private int copyData(byte[] src, int offset, byte[] dst) {
        int len = dst.length;
        int rest = src.length - offset;
        if (len > rest) {
            len = rest;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return offset + len;
    }

    private void startPass(int pass) {
        if (this.updateListeners == null || !this.imageMetadata.interlaceFlag) {
            return;
        }
        int y = interlaceOffset[this.interlacePass];
        int yStep = interlaceIncrement[this.interlacePass];
        int[] vals = ReaderUtil.computeUpdatedPixels(this.sourceRegion, this.destinationOffset, this.destinationRegion.x, this.destinationRegion.y, this.destinationRegion.x + this.destinationRegion.width - 1, this.destinationRegion.y + this.destinationRegion.height - 1, this.sourceXSubsampling, this.sourceYSubsampling, 0, y, this.destinationRegion.width, (this.destinationRegion.height + yStep - 1) / yStep, 1, yStep);
        this.updateMinY = vals[1];
        this.updateYStep = vals[5];
        int[] bands = new int[]{0};
        this.processPassStarted(this.theImage, this.interlacePass, this.sourceMinProgressivePass, this.sourceMaxProgressivePass, 0, this.updateMinY, 1, this.updateYStep, bands);
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IIOException {
        if (this.stream == null) {
            throw new IllegalStateException("Input not set!");
        }
        this.checkIndex(imageIndex);
        int index = this.locateImage(imageIndex);
        if (index != imageIndex) {
            throw new IndexOutOfBoundsException("imageIndex out of bounds!");
        }
        this.clearAbortRequest();
        this.readMetadata();
        if (param == null) {
            param = this.getDefaultReadParam();
        }
        Iterator imageTypes = this.getImageTypes(imageIndex);
        this.theImage = GIFImageReader.getDestination(param, imageTypes, this.imageMetadata.imageWidth, this.imageMetadata.imageHeight);
        this.theTile = this.theImage.getWritableTile(0, 0);
        this.width = this.imageMetadata.imageWidth;
        this.height = this.imageMetadata.imageHeight;
        this.streamX = 0;
        this.streamY = 0;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.sourceRegion = new Rectangle(0, 0, 0, 0);
        this.destinationRegion = new Rectangle(0, 0, 0, 0);
        GIFImageReader.computeRegions(param, this.width, this.height, this.theImage, this.sourceRegion, this.destinationRegion);
        this.destinationOffset = new Point(this.destinationRegion.x, this.destinationRegion.y);
        this.sourceXSubsampling = param.getSourceXSubsampling();
        this.sourceYSubsampling = param.getSourceYSubsampling();
        this.sourceMinProgressivePass = Math.max(param.getSourceMinProgressivePass(), 0);
        this.sourceMaxProgressivePass = Math.min(param.getSourceMaxProgressivePass(), 3);
        this.destY = this.destinationRegion.y + (this.streamY - this.sourceRegion.y) / this.sourceYSubsampling;
        this.computeDecodeThisRow();
        this.processImageStarted(imageIndex);
        this.startPass(0);
        this.rowBuf = new byte[this.width];
        try {
            this.initCodeSize = this.stream.readUnsignedByte();
            if (this.initCodeSize < 1 || this.initCodeSize > 8) {
                throw new IIOException("Bad code size:" + this.initCodeSize);
            }
            int left = this.blockLength = this.stream.readUnsignedByte();
            int off = 0;
            while (left > 0) {
                int nbytes = this.stream.read(this.block, off, left);
                left -= nbytes;
                off += nbytes;
            }
            this.bitPos = 0;
            this.nextByte = 0;
            this.lastBlockFound = false;
            this.interlacePass = 0;
            this.initNext32Bits();
            this.clearCode = 1 << this.initCodeSize;
            this.eofCode = this.clearCode + 1;
            int NULL_CODE = -1;
            int oldCode = -1;
            int[] prefix = new int[4096];
            byte[] suffix = new byte[4096];
            byte[] initial = new byte[4096];
            int[] length = new int[4096];
            byte[] string = new byte[4096];
            this.initializeStringTable(prefix, suffix, initial, length);
            int tableIndex = (1 << this.initCodeSize) + 2;
            int codeSize = this.initCodeSize + 1;
            int codeMask = (1 << codeSize) - 1;
            while (!this.abortRequested()) {
                int code = this.getCode(codeSize, codeMask);
                if (code == this.clearCode) {
                    this.initializeStringTable(prefix, suffix, initial, length);
                    tableIndex = (1 << this.initCodeSize) + 2;
                    codeSize = this.initCodeSize + 1;
                    codeMask = (1 << codeSize) - 1;
                    code = this.getCode(codeSize, codeMask);
                    oldCode = -1;
                    if (code == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                } else {
                    int newSuffixIndex;
                    if (code == this.eofCode) {
                        this.processImageComplete();
                        return this.theImage;
                    }
                    if (code < tableIndex) {
                        newSuffixIndex = code;
                    } else {
                        newSuffixIndex = oldCode;
                        if (code != tableIndex) {
                            this.processWarningOccurred("Out-of-sequence code!");
                        }
                    }
                    if (-1 != oldCode && tableIndex < 4096) {
                        int oc;
                        int ti = tableIndex++;
                        prefix[ti] = oc = oldCode;
                        suffix[ti] = initial[newSuffixIndex];
                        initial[ti] = initial[oc];
                        length[ti] = length[oc] + 1;
                        if (tableIndex == 1 << codeSize && tableIndex < 4096) {
                            codeMask = (1 << ++codeSize) - 1;
                        }
                    }
                }
                int c = code;
                int len = length[c];
                for (int i = len - 1; i >= 0; --i) {
                    string[i] = suffix[c];
                    c = prefix[c];
                }
                this.outputPixels(string, len);
                oldCode = code;
            }
            this.processReadAborted();
            return this.theImage;
        }
        catch (IOException e) {
            throw new IIOException("I/O error reading image!", e);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.resetStreamSettings();
    }

    private void resetStreamSettings() {
        this.gotHeader = false;
        this.streamMetadata = null;
        this.currIndex = -1;
        this.imageMetadata = null;
        this.imageStartPosition = new ArrayList();
        this.numImages = -1;
        this.blockLength = 0;
        this.bitPos = 0;
        this.nextByte = 0;
        this.next32Bits = 0;
        this.lastBlockFound = false;
        this.theImage = null;
        this.theTile = null;
        this.width = -1;
        this.height = -1;
        this.streamX = -1;
        this.streamY = -1;
        this.rowsDone = 0;
        this.interlacePass = 0;
        this.fallbackColorTable = null;
    }

    private static synchronized byte[] getDefaultPalette() {
        if (defaultPalette == null) {
            BufferedImage img = new BufferedImage(1, 1, 13);
            IndexColorModel icm = (IndexColorModel)img.getColorModel();
            int size = icm.getMapSize();
            byte[] r = new byte[size];
            byte[] g = new byte[size];
            byte[] b = new byte[size];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
            defaultPalette = new byte[size * 3];
            for (int i = 0; i < size; ++i) {
                GIFImageReader.defaultPalette[3 * i + 0] = r[i];
                GIFImageReader.defaultPalette[3 * i + 1] = g[i];
                GIFImageReader.defaultPalette[3 * i + 2] = b[i];
            }
        }
        return defaultPalette;
    }
}

