/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.plaf.motif.MotifGraphicsUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class MotifScrollPaneUI
extends BasicScrollPaneUI {
    private static final Border vsbMarginBorderR = new EmptyBorder(0, 4, 0, 0);
    private static final Border vsbMarginBorderL = new EmptyBorder(0, 0, 0, 4);
    private static final Border hsbMarginBorder = new EmptyBorder(4, 0, 0, 0);
    private CompoundBorder vsbBorder;
    private CompoundBorder hsbBorder;
    private PropertyChangeListener propertyChangeHandler;

    @Override
    protected void installListeners(JScrollPane scrollPane) {
        super.installListeners(scrollPane);
        this.propertyChangeHandler = this.createPropertyChangeHandler();
        scrollPane.addPropertyChangeListener(this.propertyChangeHandler);
    }

    @Override
    protected void uninstallListeners(JComponent scrollPane) {
        super.uninstallListeners(scrollPane);
        scrollPane.removePropertyChangeListener(this.propertyChangeHandler);
    }

    private PropertyChangeListener createPropertyChangeHandler() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JScrollPane pane;
                JScrollBar vsb;
                String propertyName = e.getPropertyName();
                if (propertyName.equals("componentOrientation") && (vsb = (pane = (JScrollPane)e.getSource()).getVerticalScrollBar()) != null && MotifScrollPaneUI.this.vsbBorder != null && vsb.getBorder() == MotifScrollPaneUI.this.vsbBorder) {
                    if (MotifGraphicsUtils.isLeftToRight(pane)) {
                        MotifScrollPaneUI.this.vsbBorder = new CompoundBorder(vsbMarginBorderR, MotifScrollPaneUI.this.vsbBorder.getInsideBorder());
                    } else {
                        MotifScrollPaneUI.this.vsbBorder = new CompoundBorder(vsbMarginBorderL, MotifScrollPaneUI.this.vsbBorder.getInsideBorder());
                    }
                    vsb.setBorder(MotifScrollPaneUI.this.vsbBorder);
                }
            }
        };
    }

    @Override
    protected void installDefaults(JScrollPane scrollpane) {
        JScrollBar hsb;
        super.installDefaults(scrollpane);
        JScrollBar vsb = scrollpane.getVerticalScrollBar();
        if (vsb != null) {
            this.vsbBorder = MotifGraphicsUtils.isLeftToRight(scrollpane) ? new CompoundBorder(vsbMarginBorderR, vsb.getBorder()) : new CompoundBorder(vsbMarginBorderL, vsb.getBorder());
            vsb.setBorder(this.vsbBorder);
        }
        if ((hsb = scrollpane.getHorizontalScrollBar()) != null) {
            this.hsbBorder = new CompoundBorder(hsbMarginBorder, hsb.getBorder());
            hsb.setBorder(this.hsbBorder);
        }
    }

    @Override
    protected void uninstallDefaults(JScrollPane c) {
        JScrollBar hsb;
        super.uninstallDefaults(c);
        JScrollBar vsb = this.scrollpane.getVerticalScrollBar();
        if (vsb != null) {
            if (vsb.getBorder() == this.vsbBorder) {
                vsb.setBorder(null);
            }
            this.vsbBorder = null;
        }
        if ((hsb = this.scrollpane.getHorizontalScrollBar()) != null) {
            if (hsb.getBorder() == this.hsbBorder) {
                hsb.setBorder(null);
            }
            this.hsbBorder = null;
        }
    }

    public static ComponentUI createUI(JComponent x) {
        return new MotifScrollPaneUI();
    }
}

