/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.Platform;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public final class Toolkit {
    private Toolkit() {
    }

    static void getUnsigned8(byte[] b, int off, int len) {
        int i = off;
        while (i < off + len) {
            int n = i++;
            b[n] = (byte)(b[n] + 128);
        }
    }

    static void getByteSwapped(byte[] b, int off, int len) {
        for (int i = off; i < off + len; i += 2) {
            byte tempByte = b[i];
            b[i] = b[i + 1];
            b[i + 1] = tempByte;
        }
    }

    static float linearToDB(float linear) {
        float dB = (float)(Math.log((double)linear == 0.0 ? 1.0E-4 : (double)linear) / Math.log(10.0) * 20.0);
        return dB;
    }

    static float dBToLinear(float dB) {
        float linear = (float)Math.pow(10.0, (double)dB / 20.0);
        return linear;
    }

    static long align(long bytes, int blockSize) {
        if (blockSize <= 1) {
            return bytes;
        }
        return bytes - bytes % (long)blockSize;
    }

    static int align(int bytes, int blockSize) {
        if (blockSize <= 1) {
            return bytes;
        }
        return bytes - bytes % blockSize;
    }

    static long millis2bytes(AudioFormat format, long millis) {
        long result = (long)((float)millis * format.getFrameRate() / 1000.0f * (float)format.getFrameSize());
        return Toolkit.align(result, format.getFrameSize());
    }

    static long bytes2millis(AudioFormat format, long bytes) {
        return (long)((float)bytes / format.getFrameRate() * 1000.0f / (float)format.getFrameSize());
    }

    static long micros2bytes(AudioFormat format, long micros) {
        long result = (long)((float)micros * format.getFrameRate() / 1000000.0f * (float)format.getFrameSize());
        return Toolkit.align(result, format.getFrameSize());
    }

    static long bytes2micros(AudioFormat format, long bytes) {
        return (long)((float)bytes / format.getFrameRate() * 1000000.0f / (float)format.getFrameSize());
    }

    static long micros2frames(AudioFormat format, long micros) {
        return (long)((float)micros * format.getFrameRate() / 1000000.0f);
    }

    static long frames2micros(AudioFormat format, long frames) {
        return (long)((double)frames / (double)format.getFrameRate() * 1000000.0);
    }

    static void isFullySpecifiedAudioFormat(AudioFormat format) {
        if (format.getFrameSize() <= 0) {
            throw new IllegalArgumentException("invalid frame size: " + (format.getFrameSize() == -1 ? "NOT_SPECIFIED" : String.valueOf(format.getFrameSize())));
        }
        if (!(format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) || format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) || format.getEncoding().equals(AudioFormat.Encoding.ULAW) || format.getEncoding().equals(AudioFormat.Encoding.ALAW))) {
            return;
        }
        if (format.getFrameRate() <= 0.0f) {
            throw new IllegalArgumentException("invalid frame rate: " + (format.getFrameRate() == -1.0f ? "NOT_SPECIFIED" : String.valueOf(format.getFrameRate())));
        }
        if (format.getSampleRate() <= 0.0f) {
            throw new IllegalArgumentException("invalid sample rate: " + (format.getSampleRate() == -1.0f ? "NOT_SPECIFIED" : String.valueOf(format.getSampleRate())));
        }
        if (format.getSampleSizeInBits() <= 0) {
            throw new IllegalArgumentException("invalid sample size in bits: " + (format.getSampleSizeInBits() == -1 ? "NOT_SPECIFIED" : String.valueOf(format.getSampleSizeInBits())));
        }
        if (format.getChannels() <= 0) {
            throw new IllegalArgumentException("invalid number of channels: " + (format.getChannels() == -1 ? "NOT_SPECIFIED" : String.valueOf(format.getChannels())));
        }
    }

    static boolean isFullySpecifiedPCMFormat(AudioFormat format) {
        if (!format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            return false;
        }
        return !(format.getFrameRate() <= 0.0f) && !(format.getSampleRate() <= 0.0f) && format.getSampleSizeInBits() > 0 && format.getFrameSize() > 0 && format.getChannels() > 0;
    }

    public static AudioInputStream getPCMConvertedAudioInputStream(AudioInputStream ais) {
        AudioFormat af = ais.getFormat();
        if (!af.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && !af.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            try {
                AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, af.getSampleRate(), 16, af.getChannels(), af.getChannels() * 2, af.getSampleRate(), Platform.isBigEndian());
                ais = AudioSystem.getAudioInputStream(newFormat, ais);
            }
            catch (Exception e) {
                ais = null;
            }
        }
        return ais;
    }
}

