/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rmi.rmid;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

public final class ExecOptionPermission
extends Permission {
    private transient boolean wildcard;
    private transient String name;
    private static final long serialVersionUID = 5842294756823092756L;

    public ExecOptionPermission(String name) {
        super(name);
        this.init(name);
    }

    public ExecOptionPermission(String name, String actions) {
        this(name);
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission that = (ExecOptionPermission)p;
        if (this.wildcard) {
            if (that.wildcard) {
                return that.name.startsWith(this.name);
            }
            return that.name.length() > this.name.length() && that.name.startsWith(this.name);
        }
        if (that.wildcard) {
            return false;
        }
        return this.name.equals(that.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ExecOptionPermission that = (ExecOptionPermission)obj;
        return this.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        return "";
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new ExecOptionPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName());
    }

    private void init(String name) {
        if (name == null) {
            throw new NullPointerException("name can't be null");
        }
        if (name.equals("")) {
            throw new IllegalArgumentException("name can't be empty");
        }
        if (name.endsWith(".*") || name.endsWith("=*") || name.equals("*")) {
            this.wildcard = true;
            this.name = name.length() == 1 ? "" : name.substring(0, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    private static class ExecOptionPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private Hashtable<String, Permission> permissions = new Hashtable(11);
        private boolean all_allowed = false;
        private static final long serialVersionUID = -1242475729790124375L;

        @Override
        public void add(Permission permission) {
            if (!(permission instanceof ExecOptionPermission)) {
                throw new IllegalArgumentException("invalid permission: " + permission);
            }
            if (this.isReadOnly()) {
                throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
            }
            ExecOptionPermission p = (ExecOptionPermission)permission;
            this.permissions.put(p.getName(), permission);
            if (!this.all_allowed && p.getName().equals("*")) {
                this.all_allowed = true;
            }
        }

        @Override
        public boolean implies(Permission permission) {
            int last;
            if (!(permission instanceof ExecOptionPermission)) {
                return false;
            }
            ExecOptionPermission p = (ExecOptionPermission)permission;
            if (this.all_allowed) {
                return true;
            }
            String pname = p.getName();
            Permission x = this.permissions.get(pname);
            if (x != null) {
                return x.implies(permission);
            }
            int offset = pname.length() - 1;
            while ((last = pname.lastIndexOf(".", offset)) != -1) {
                x = this.permissions.get(pname = pname.substring(0, last + 1) + "*");
                if (x != null) {
                    return x.implies(permission);
                }
                offset = last - 1;
            }
            pname = p.getName();
            offset = pname.length() - 1;
            while ((last = pname.lastIndexOf("=", offset)) != -1) {
                x = this.permissions.get(pname = pname.substring(0, last + 1) + "*");
                if (x != null) {
                    return x.implies(permission);
                }
                offset = last - 1;
            }
            return false;
        }

        @Override
        public Enumeration<Permission> elements() {
            return this.permissions.elements();
        }
    }
}

