/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import javax.security.auth.kerberos.ServicePermission;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.util.DerValue;

public final class KerberosPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = -7374788026156829911L;
    public static final int KRB_NT_UNKNOWN = 0;
    public static final int KRB_NT_PRINCIPAL = 1;
    public static final int KRB_NT_SRV_INST = 2;
    public static final int KRB_NT_SRV_HST = 3;
    public static final int KRB_NT_SRV_XHST = 4;
    public static final int KRB_NT_UID = 5;
    static final int KRB_NT_ENTERPRISE = 10;
    private transient String fullName;
    private transient String realm;
    private transient int nameType;

    public KerberosPrincipal(String name) {
        this(name, 1);
    }

    public KerberosPrincipal(String name, int nameType) {
        SecurityManager sm;
        PrincipalName krb5Principal = null;
        try {
            krb5Principal = new PrincipalName(name, nameType);
        }
        catch (KrbException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (krb5Principal.isRealmDeduced() && !Realm.AUTODEDUCEREALM && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(new ServicePermission("@" + krb5Principal.getRealmAsString(), "-"));
            }
            catch (SecurityException se) {
                throw new SecurityException("Cannot read realm info");
            }
        }
        this.nameType = nameType;
        this.fullName = krb5Principal.toString();
        this.realm = krb5Principal.getRealmString();
    }

    public String getRealm() {
        return this.realm;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KerberosPrincipal)) {
            return false;
        }
        String myFullName = this.getName();
        String otherFullName = ((KerberosPrincipal)other).getName();
        return myFullName.equals(otherFullName);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        try {
            PrincipalName krb5Principal = new PrincipalName(this.fullName, this.nameType);
            oos.writeObject(krb5Principal.asn1Encode());
            oos.writeObject(krb5Principal.getRealm().asn1Encode());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        byte[] asn1EncPrincipal = (byte[])ois.readObject();
        byte[] encRealm = (byte[])ois.readObject();
        try {
            Realm realmObject = new Realm(new DerValue(encRealm));
            PrincipalName krb5Principal = new PrincipalName(new DerValue(asn1EncPrincipal), realmObject);
            this.realm = realmObject.toString();
            this.fullName = krb5Principal.toString();
            this.nameType = krb5Principal.getNameType();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String getName() {
        return this.fullName;
    }

    public int getNameType() {
        return this.nameType;
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

