/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.peer.ComponentPeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.util.logging.PlatformLogger;

public abstract class KeyboardFocusManagerPeerImpl
implements KeyboardFocusManagerPeer {
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.focus.KeyboardFocusManagerPeerImpl");
    public static final int SNFH_FAILURE = 0;
    public static final int SNFH_SUCCESS_HANDLED = 1;
    public static final int SNFH_SUCCESS_PROCEED = 2;

    @Override
    public void clearGlobalFocusOwner(Window activeWindow) {
        if (activeWindow != null) {
            Component focusOwner = activeWindow.getFocusOwner();
            if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                focusLog.fine("Clearing global focus owner " + focusOwner);
            }
            if (focusOwner != null) {
                CausedFocusEvent fl = new CausedFocusEvent(focusOwner, 1005, false, null, CausedFocusEvent.Cause.CLEAR_GLOBAL_FOCUS_OWNER);
                SunToolkit.postPriorityEvent(fl);
            }
        }
    }

    public static boolean shouldFocusOnClick(Component component) {
        boolean acceptFocusOnClick = false;
        if (component instanceof Canvas || component instanceof Scrollbar) {
            acceptFocusOnClick = true;
        } else if (component instanceof Panel) {
            acceptFocusOnClick = ((Panel)component).getComponentCount() == 0;
        } else {
            ComponentPeer peer = component != null ? component.getPeer() : null;
            acceptFocusOnClick = peer != null ? peer.isFocusable() : false;
        }
        return acceptFocusOnClick && AWTAccessor.getComponentAccessor().canBeFocusOwner(component);
    }

    public static boolean deliverFocus(Component lightweightChild, Component target, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause, Component currentFocusOwner) {
        Component currentOwner;
        if (lightweightChild == null) {
            lightweightChild = target;
        }
        if ((currentOwner = currentFocusOwner) != null && currentOwner.getPeer() == null) {
            currentOwner = null;
        }
        if (currentOwner != null) {
            CausedFocusEvent fl = new CausedFocusEvent(currentOwner, 1005, false, lightweightChild, cause);
            if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                focusLog.finer("Posting focus event: " + fl);
            }
            SunToolkit.postEvent(SunToolkit.targetToAppContext(currentOwner), fl);
        }
        CausedFocusEvent fg = new CausedFocusEvent(lightweightChild, 1004, false, currentOwner, cause);
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer("Posting focus event: " + fg);
        }
        SunToolkit.postEvent(SunToolkit.targetToAppContext(lightweightChild), fg);
        return true;
    }

    public static boolean requestFocusFor(Component target, CausedFocusEvent.Cause cause) {
        return AWTAccessor.getComponentAccessor().requestFocus(target, cause);
    }

    public static int shouldNativelyFocusHeavyweight(Component heavyweight, Component descendant, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return KfmAccessor.instance.shouldNativelyFocusHeavyweight(heavyweight, descendant, temporary, focusedWindowChangeAllowed, time, cause);
    }

    public static void removeLastFocusRequest(Component heavyweight) {
        KfmAccessor.instance.removeLastFocusRequest(heavyweight);
    }

    public static boolean processSynchronousLightweightTransfer(Component heavyweight, Component descendant, boolean temporary, boolean focusedWindowChangeAllowed, long time) {
        return KfmAccessor.instance.processSynchronousLightweightTransfer(heavyweight, descendant, temporary, focusedWindowChangeAllowed, time);
    }

    private static class KfmAccessor {
        private static AWTAccessor.KeyboardFocusManagerAccessor instance = AWTAccessor.getKeyboardFocusManagerAccessor();

        private KfmAccessor() {
        }
    }
}

