/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.xr.XRBackend;
import sun.java2d.xr.XRCompositeManager;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

abstract class XRPaints {
    static XRCompositeManager xrCompMan;
    static final XRGradient xrGradient;
    static final XRLinearGradient xrLinearGradient;
    static final XRRadialGradient xrRadialGradient;
    static final XRTexture xrTexture;

    XRPaints() {
    }

    public static void register(XRCompositeManager xrComp) {
        xrCompMan = xrComp;
    }

    private static XRPaints getXRPaint(SunGraphics2D sg2d) {
        switch (sg2d.paintState) {
            case 2: {
                return xrGradient;
            }
            case 3: {
                return xrLinearGradient;
            }
            case 4: {
                return xrRadialGradient;
            }
            case 5: {
                return xrTexture;
            }
        }
        return null;
    }

    static boolean isValid(SunGraphics2D sg2d) {
        XRPaints impl = XRPaints.getXRPaint(sg2d);
        return impl != null && impl.isPaintValid(sg2d);
    }

    static void setPaint(SunGraphics2D sg2d, Paint paint) {
        XRPaints impl = XRPaints.getXRPaint(sg2d);
        if (impl != null) {
            impl.setXRPaint(sg2d, paint);
        }
    }

    abstract boolean isPaintValid(SunGraphics2D var1);

    abstract void setXRPaint(SunGraphics2D var1, Paint var2);

    public int getGradientLength(Point2D pt1, Point2D pt2) {
        double xDiff = Math.max(pt1.getX(), pt2.getX()) - Math.min(pt1.getX(), pt2.getX());
        double yDiff = Math.max(pt1.getY(), pt2.getY()) - Math.min(pt1.getY(), pt2.getY());
        return (int)Math.ceil(Math.sqrt(xDiff * xDiff + yDiff * yDiff));
    }

    public int[] convertToIntArgbPixels(Color[] colors) {
        int[] pixels = new int[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            pixels[i] = this.colorToIntArgbPixel(colors[i]);
        }
        return pixels;
    }

    public int colorToIntArgbPixel(Color c) {
        int rgb = c.getRGB();
        int a = Math.round(xrCompMan.getExtraAlpha() * (float)(rgb >>> 24));
        return a << 24 | rgb & 0xFFFFFF;
    }

    static {
        xrGradient = new XRGradient();
        xrLinearGradient = new XRLinearGradient();
        xrRadialGradient = new XRRadialGradient();
        xrTexture = new XRTexture();
    }

    private static class XRTexture
    extends XRPaints {
        private XRTexture() {
        }

        private XRSurfaceData getAccSrcSurface(XRSurfaceData dstData, BufferedImage bi) {
            SurfaceData srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null);
            if (!(srcData instanceof XRSurfaceData) && !((srcData = dstData.getSourceSurfaceData(bi, 0, CompositeType.SrcOver, null)) instanceof XRSurfaceData)) {
                throw new InternalError("Surface not cachable");
            }
            return (XRSurfaceData)srcData;
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            TexturePaint paint = (TexturePaint)sg2d.paint;
            BufferedImage bi = paint.getImage();
            XRSurfaceData dstData = (XRSurfaceData)sg2d.getDestSurface();
            return this.getAccSrcSurface(dstData, bi) != null;
        }

        @Override
        void setXRPaint(SunGraphics2D sg2d, Paint pt) {
            TexturePaint paint = (TexturePaint)pt;
            BufferedImage bi = paint.getImage();
            Rectangle2D anchor = paint.getAnchorRect();
            XRSurfaceData dstData = (XRSurfaceData)sg2d.surfaceData;
            XRSurfaceData srcData = this.getAccSrcSurface(dstData, bi);
            AffineTransform at = new AffineTransform();
            at.translate(anchor.getX(), anchor.getY());
            at.scale(anchor.getWidth() / (double)bi.getWidth(), anchor.getHeight() / (double)bi.getHeight());
            try {
                at.invert();
            }
            catch (NoninvertibleTransformException ex) {
                at.setToIdentity();
            }
            srcData.setStaticSrcTx(at);
            srcData.validateAsSource(at, 1, XRUtils.ATransOpToXRQuality(sg2d.interpolationType));
            xrCompMan.setTexturePaint(srcData);
        }
    }

    private static class XRRadialGradient
    extends XRPaints {
        private XRRadialGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            RadialGradientPaint grad = (RadialGradientPaint)sg2d.paint;
            return grad.getFocusPoint().equals(grad.getCenterPoint()) && grad.getColorSpace() == MultipleGradientPaint.ColorSpaceType.SRGB;
        }

        @Override
        void setXRPaint(SunGraphics2D sg2d, Paint pt) {
            RadialGradientPaint paint = (RadialGradientPaint)pt;
            Color[] colors = paint.getColors();
            Point2D center = paint.getCenterPoint();
            int repeat = XRUtils.getRepeatForCycleMethod(paint.getCycleMethod());
            float[] fractions = paint.getFractions();
            int[] pixels = this.convertToIntArgbPixels(colors);
            float radius = paint.getRadius();
            float cx = (float)center.getX();
            float cy = (float)center.getY();
            AffineTransform at = paint.getTransform();
            try {
                at.invert();
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
            XRBackend con = xrCompMan.getBackend();
            int gradient = con.createRadialGradient(cx, cy, 0.0f, radius, fractions, pixels, repeat);
            XRSurfaceData.XRInternalSurfaceData x11sd = new XRSurfaceData.XRInternalSurfaceData(con, gradient);
            x11sd.setStaticSrcTx(at);
            xrCompMan.setGradientPaint(x11sd);
        }
    }

    private static class XRLinearGradient
    extends XRPaints {
        private XRLinearGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            return ((LinearGradientPaint)sg2d.getPaint()).getColorSpace() == MultipleGradientPaint.ColorSpaceType.SRGB;
        }

        @Override
        void setXRPaint(SunGraphics2D sg2d, Paint pt) {
            LinearGradientPaint paint = (LinearGradientPaint)pt;
            Color[] colors = paint.getColors();
            Point2D pt1 = paint.getStartPoint();
            Point2D pt2 = paint.getEndPoint();
            int repeat = XRUtils.getRepeatForCycleMethod(paint.getCycleMethod());
            float[] fractions = paint.getFractions();
            int[] pixels = this.convertToIntArgbPixels(colors);
            AffineTransform at = paint.getTransform();
            try {
                at.invert();
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
            XRBackend con = xrCompMan.getBackend();
            int gradient = con.createLinearGradient(pt1, pt2, fractions, pixels, repeat);
            XRSurfaceData.XRInternalSurfaceData x11sd = new XRSurfaceData.XRInternalSurfaceData(con, gradient);
            x11sd.setStaticSrcTx(at);
            xrCompMan.setGradientPaint(x11sd);
        }
    }

    private static class XRGradient
    extends XRPaints {
        private XRGradient() {
        }

        @Override
        boolean isPaintValid(SunGraphics2D sg2d) {
            return true;
        }

        @Override
        void setXRPaint(SunGraphics2D sg2d, Paint pt) {
            GradientPaint paint = (GradientPaint)pt;
            int repeat = paint.isCyclic() ? 3 : 2;
            float[] fractions = new float[]{0.0f, 1.0f};
            int[] pixels = this.convertToIntArgbPixels(new Color[]{paint.getColor1(), paint.getColor2()});
            Point2D pt1 = paint.getPoint1();
            Point2D pt2 = paint.getPoint2();
            XRBackend con = xrCompMan.getBackend();
            int gradient = con.createLinearGradient(pt1, pt2, fractions, pixels, repeat);
            xrCompMan.setGradientPaint(new XRSurfaceData.XRInternalSurfaceData(con, gradient));
        }
    }
}

