/*
 * Decompiled with CFR 0.152.
 */
package sun.management.jdp;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import sun.management.VMManagement;
import sun.management.jdp.JdpBroadcaster;
import sun.management.jdp.JdpException;
import sun.management.jdp.JdpJmxPacket;

public final class JdpController {
    private static JDPControllerRunner controller = null;

    private JdpController() {
    }

    private static int getInteger(String val, int dflt, String msg) throws JdpException {
        try {
            return val == null ? dflt : Integer.parseInt(val);
        }
        catch (NumberFormatException ex) {
            throw new JdpException(msg);
        }
    }

    private static InetAddress getInetAddress(String val, InetAddress dflt, String msg) throws JdpException {
        try {
            return val == null ? dflt : InetAddress.getByName(val);
        }
        catch (UnknownHostException ex) {
            throw new JdpException(msg);
        }
    }

    private static Integer getProcessId() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            Field jvm = runtime.getClass().getDeclaredField("jvm");
            jvm.setAccessible(true);
            VMManagement mgmt = (VMManagement)jvm.get(runtime);
            Method pid_method = mgmt.getClass().getDeclaredMethod("getProcessId", new Class[0]);
            pid_method.setAccessible(true);
            Integer pid = (Integer)pid_method.invoke(mgmt, new Object[0]);
            return pid;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static synchronized void startDiscoveryService(InetAddress address, int port, String instanceName, String url) throws IOException, JdpException {
        int ttl = JdpController.getInteger(System.getProperty("com.sun.management.jdp.ttl"), 1, "Invalid jdp packet ttl");
        int pause = JdpController.getInteger(System.getProperty("com.sun.management.jdp.pause"), 5, "Invalid jdp pause");
        pause *= 1000;
        InetAddress sourceAddress = JdpController.getInetAddress(System.getProperty("com.sun.management.jdp.source_addr"), null, "Invalid source address provided");
        UUID id = UUID.randomUUID();
        JdpJmxPacket packet = new JdpJmxPacket(id, url);
        String javaCommand = System.getProperty("sun.java.command");
        if (javaCommand != null) {
            String[] arr = javaCommand.split(" ", 2);
            packet.setMainClass(arr[0]);
        }
        packet.setInstanceName(instanceName);
        String rmiHostname = System.getProperty("java.rmi.server.hostname");
        packet.setRmiHostname(rmiHostname);
        packet.setBroadcastInterval(new Integer(pause).toString());
        Integer pid = JdpController.getProcessId();
        if (pid != null) {
            packet.setProcessId(pid.toString());
        }
        JdpBroadcaster bcast = new JdpBroadcaster(address, sourceAddress, port, ttl);
        JdpController.stopDiscoveryService();
        controller = new JDPControllerRunner(bcast, packet, pause);
        Thread t = new Thread((Runnable)controller, "JDP broadcaster");
        t.setDaemon(true);
        t.start();
    }

    public static synchronized void stopDiscoveryService() {
        if (controller != null) {
            controller.stop();
            controller = null;
        }
    }

    private static class JDPControllerRunner
    implements Runnable {
        private final JdpJmxPacket packet;
        private final JdpBroadcaster bcast;
        private final int pause;
        private volatile boolean shutdown = false;

        private JDPControllerRunner(JdpBroadcaster bcast, JdpJmxPacket packet, int pause) {
            this.bcast = bcast;
            this.packet = packet;
            this.pause = pause;
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    this.bcast.sendPacket(this.packet);
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.stop();
                this.bcast.shutdown();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void stop() {
            this.shutdown = true;
        }
    }
}

