/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.nio.fs.AbstractFileTypeDetector;

class MimeTypesFileTypeDetector
extends AbstractFileTypeDetector {
    private final Path mimeTypesFile;
    private Map<String, String> mimeTypeMap;
    private volatile boolean loaded = false;

    public MimeTypesFileTypeDetector(Path filePath) {
        this.mimeTypesFile = filePath;
    }

    @Override
    protected String implProbeContentType(Path path) {
        String mimeType;
        Path fn = path.getFileName();
        if (fn == null) {
            return null;
        }
        String ext = MimeTypesFileTypeDetector.getExtension(fn.toString());
        if (ext.isEmpty()) {
            return null;
        }
        this.loadMimeTypes();
        if (this.mimeTypeMap == null || this.mimeTypeMap.isEmpty()) {
            return null;
        }
        do {
            if ((mimeType = this.mimeTypeMap.get(ext)) != null) continue;
            ext = MimeTypesFileTypeDetector.getExtension(ext);
        } while (mimeType == null && !ext.isEmpty());
        return mimeType;
    }

    private static String getExtension(String name) {
        int dot;
        String ext = "";
        if (name != null && !name.isEmpty() && (dot = name.indexOf(46)) >= 0 && dot < name.length() - 1) {
            ext = name.substring(dot + 1);
        }
        return ext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMimeTypes() {
        if (!this.loaded) {
            MimeTypesFileTypeDetector mimeTypesFileTypeDetector = this;
            synchronized (mimeTypesFileTypeDetector) {
                if (!this.loaded) {
                    List<String> lines = AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

                        @Override
                        public List<String> run() {
                            try {
                                return Files.readAllLines(MimeTypesFileTypeDetector.this.mimeTypesFile, Charset.defaultCharset());
                            }
                            catch (IOException ignore) {
                                return Collections.emptyList();
                            }
                        }
                    });
                    this.mimeTypeMap = new HashMap<String, String>(lines.size());
                    String entry = "";
                    for (String line : lines) {
                        if ((entry = entry + line).endsWith("\\")) {
                            entry = entry.substring(0, entry.length() - 1);
                            continue;
                        }
                        this.parseMimeEntry(entry);
                        entry = "";
                    }
                    if (!entry.isEmpty()) {
                        this.parseMimeEntry(entry);
                    }
                    this.loaded = true;
                }
            }
        }
    }

    private void parseMimeEntry(String entry) {
        block6: {
            block5: {
                String[] extList;
                if ((entry = entry.trim()).isEmpty() || entry.charAt(0) == '#') {
                    return;
                }
                int equalIdx = (entry = entry.replaceAll("\\s*#.*", "")).indexOf(61);
                if (equalIdx <= 0) break block5;
                String TYPEEQUAL = "type=";
                String typeRegex = "\\btype=(\"\\p{Graph}+?/\\p{Graph}+?\"|\\p{Graph}+/\\p{Graph}+\\b)";
                Pattern typePattern = Pattern.compile(typeRegex);
                Matcher typeMatcher = typePattern.matcher(entry);
                if (!typeMatcher.find()) break block6;
                String type = typeMatcher.group().substring("type=".length());
                if (type.charAt(0) == '\"') {
                    type = type.substring(1, type.length() - 1);
                }
                String EXTEQUAL = "exts=";
                String extRegex = "\\bexts=(\"[\\p{Graph}\\p{Blank}]+?\"|\\p{Graph}+\\b)";
                Pattern extPattern = Pattern.compile(extRegex);
                Matcher extMatcher = extPattern.matcher(entry);
                if (!extMatcher.find()) break block6;
                String exts = extMatcher.group().substring("exts=".length());
                if (exts.charAt(0) == '\"') {
                    exts = exts.substring(1, exts.length() - 1);
                }
                for (String ext : extList = exts.split("[\\p{Blank}\\p{Punct}]+")) {
                    this.putIfAbsent(ext, type);
                }
                break block6;
            }
            String[] elements = entry.split("\\s+");
            int i = 1;
            while (i < elements.length) {
                this.putIfAbsent(elements[i++], elements[0]);
            }
        }
    }

    private void putIfAbsent(String key, String value) {
        if (!(key == null || key.isEmpty() || value == null || value.isEmpty() || this.mimeTypeMap.containsKey(key))) {
            this.mimeTypeMap.put(key, value);
        }
    }
}

