/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import sun.security.util.BitArray;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.Gregorian;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    boolean allowBER = true;

    DerInputBuffer(byte[] buf) {
        this(buf, true);
    }

    DerInputBuffer(byte[] buf, boolean allowBER) {
        super(buf);
        this.allowBER = allowBER;
    }

    DerInputBuffer(byte[] buf, int offset, int len, boolean allowBER) {
        super(buf, offset, len);
        this.allowBER = allowBER;
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer retval = (DerInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)other);
        }
        return false;
    }

    boolean equals(DerInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.buf[this.pos + i] == other.buf[other.pos + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p = this.pos;
        for (int i = 0; i < len; ++i) {
            retval += this.buf[p + i] * i;
        }
        return retval;
    }

    void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    BigInteger getBigInteger(int len, boolean makePositive) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of integer");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        if (!this.allowBER && len >= 2 && bytes[0] == 0 && bytes[1] >= 0) {
            throw new IOException("Invalid encoding: redundant leading 0s");
        }
        if (makePositive) {
            return new BigInteger(1, bytes);
        }
        return new BigInteger(bytes);
    }

    public int getInteger(int len) throws IOException {
        BigInteger result = this.getBigInteger(len, false);
        if (result.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (result.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return result.intValue();
    }

    private static int checkPaddedBits(int numOfPadBits, byte[] data, int start, int end, boolean allowBER) throws IOException {
        if (numOfPadBits < 0 || numOfPadBits > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        int lenInBits = (end - start << 3) - numOfPadBits;
        if (lenInBits < 0) {
            throw new IOException("Not enough bytes in BitString");
        }
        if (!allowBER && numOfPadBits != 0 && (data[end - 1] & 255 >>> 8 - numOfPadBits) != 0) {
            throw new IOException("Invalid value of padding bits");
        }
        return lenInBits;
    }

    public byte[] getBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        int start = this.pos;
        int end = start + len;
        this.skip(len);
        byte numOfPadBits = this.buf[start++];
        DerInputBuffer.checkPaddedBits(numOfPadBits, this.buf, start, end, this.allowBER);
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, start, retval, 0, len - 1);
        if (this.allowBER && numOfPadBits != 0) {
            int n = retval.length - 1;
            retval[n] = (byte)(retval[n] & 255 << numOfPadBits);
        }
        return retval;
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    BitArray getUnalignedBitString() throws IOException {
        return this.getUnalignedBitString(this.available());
    }

    BitArray getUnalignedBitString(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (len == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        if (this.pos >= this.count) {
            return null;
        }
        int start = this.pos;
        int end = start + len;
        this.pos = this.count;
        byte numOfPadBits = this.buf[start++];
        int lenInBits = DerInputBuffer.checkPaddedBits(numOfPadBits, this.buf, start, end, this.allowBER);
        return new BitArray(lenInBits, this.buf, start);
    }

    public Date getUTCTime(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (len < 11 || len > 17) {
            throw new IOException("DER UTC Time length error");
        }
        return this.getTime(len, false);
    }

    public Date getGeneralizedTime(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (len < 13) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(len, true);
    }

    private Date getTime(int len, boolean generalized) throws IOException {
        int second;
        int year;
        String type = null;
        if (generalized) {
            type = "Generalized";
            year = 1000 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
            year += 100 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
            year += 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
            year += DerInputBuffer.toDigit(this.buf[this.pos++], type);
            len -= 2;
        } else {
            type = "UTC";
            year = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
            year = (year += DerInputBuffer.toDigit(this.buf[this.pos++], type)) < 50 ? (year += 2000) : (year += 1900);
        }
        int month = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
        month += DerInputBuffer.toDigit(this.buf[this.pos++], type);
        int day = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
        day += DerInputBuffer.toDigit(this.buf[this.pos++], type);
        int hour = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
        hour += DerInputBuffer.toDigit(this.buf[this.pos++], type);
        int minute = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
        minute += DerInputBuffer.toDigit(this.buf[this.pos++], type);
        int millis = 0;
        if ((len -= 10) > 2) {
            second = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
            second += DerInputBuffer.toDigit(this.buf[this.pos++], type);
            len -= 2;
            if (generalized && (this.buf[this.pos] == 46 || this.buf[this.pos] == 44)) {
                if (--len == 0) {
                    throw new IOException("Parse " + type + " time, empty fractional part");
                }
                ++this.pos;
                int precision = 0;
                while (this.buf[this.pos] != 90 && this.buf[this.pos] != 43 && this.buf[this.pos] != 45) {
                    int thisDigit = DerInputBuffer.toDigit(this.buf[this.pos], type);
                    ++precision;
                    if (--len == 0) {
                        throw new IOException("Parse " + type + " time, invalid fractional part");
                    }
                    ++this.pos;
                    switch (precision) {
                        case 1: {
                            millis += 100 * thisDigit;
                            break;
                        }
                        case 2: {
                            millis += 10 * thisDigit;
                            break;
                        }
                        case 3: {
                            millis += thisDigit;
                        }
                    }
                }
                if (precision == 0) {
                    throw new IOException("Parse " + type + " time, empty fractional part");
                }
            }
        } else {
            second = 0;
        }
        if (month == 0 || day == 0 || month > 12 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse " + type + " time, invalid format");
        }
        Gregorian gcal = CalendarSystem.getGregorianCalendar();
        CalendarDate date = ((CalendarSystem)gcal).newCalendarDate(null);
        date.setDate(year, month, day);
        date.setTimeOfDay(hour, minute, second, millis);
        long time = ((CalendarSystem)gcal).getTime(date);
        if (len != 1 && len != 5) {
            throw new IOException("Parse " + type + " time, invalid offset");
        }
        switch (this.buf[this.pos++]) {
            case 43: {
                if (len != 5) {
                    throw new IOException("Parse " + type + " time, invalid offset");
                }
                int hr = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
                int min = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
                if ((hr += DerInputBuffer.toDigit(this.buf[this.pos++], type)) >= 24 || (min += DerInputBuffer.toDigit(this.buf[this.pos++], type)) >= 60) {
                    throw new IOException("Parse " + type + " time, +hhmm");
                }
                time -= (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 45: {
                if (len != 5) {
                    throw new IOException("Parse " + type + " time, invalid offset");
                }
                int hr = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
                int min = 10 * DerInputBuffer.toDigit(this.buf[this.pos++], type);
                if ((hr += DerInputBuffer.toDigit(this.buf[this.pos++], type)) >= 24 || (min += DerInputBuffer.toDigit(this.buf[this.pos++], type)) >= 60) {
                    throw new IOException("Parse " + type + " time, -hhmm");
                }
                time += (long)((hr * 60 + min) * 60 * 1000);
                break;
            }
            case 90: {
                if (len == 1) break;
                throw new IOException("Parse " + type + " time, invalid format");
            }
            default: {
                throw new IOException("Parse " + type + " time, garbage offset");
            }
        }
        return new Date(time);
    }

    private static int toDigit(byte b, String type) throws IOException {
        if (b < 48 || b > 57) {
            throw new IOException("Parse " + type + " time, invalid format");
        }
        return b - 48;
    }
}

