/*
 * Decompiled with CFR 0.152.
 */
package sun.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.util.HashMap;
import java.util.Map;
import sun.swing.ImageCache;

public abstract class CachedPainter {
    private static final Map<Object, ImageCache> cacheMap = new HashMap<Object, ImageCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageCache getCache(Object key) {
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            ImageCache cache = cacheMap.get(key);
            if (cache == null) {
                cache = new ImageCache(1);
                cacheMap.put(key, cache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache;
        }
    }

    public CachedPainter(int cacheCount) {
        CachedPainter.getCache(this.getClass()).setMaxCount(cacheCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Component c, Graphics g, int x, int y, int w, int h, Object ... args) {
        if (w <= 0 || h <= 0) {
            return;
        }
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            this.paint0(c, g, x, y, w, h, args);
            // ** MonitorExit[var8_8] (shouldn't be in output)
            return;
        }
    }

    private void paint0(Component c, Graphics g, int x, int y, int w, int h, Object ... args) {
        Class<?> key = this.getClass();
        GraphicsConfiguration config = this.getGraphicsConfiguration(c);
        ImageCache cache = CachedPainter.getCache(key);
        Image image = cache.getImage(key, config, w, h, args);
        int attempts = 0;
        do {
            boolean draw = false;
            if (image instanceof VolatileImage) {
                switch (((VolatileImage)image).validate(config)) {
                    case 2: {
                        ((VolatileImage)image).flush();
                        image = null;
                        break;
                    }
                    case 1: {
                        draw = true;
                    }
                }
            }
            if (image == null) {
                image = this.createImage(c, w, h, config, args);
                cache.setImage(key, config, w, h, args, image);
                draw = true;
            }
            if (draw) {
                Graphics g2 = image.getGraphics();
                this.paintToImage(c, image, g2, w, h, args);
                g2.dispose();
            }
            this.paintImage(c, g, x, y, w, h, image, args);
        } while (image instanceof VolatileImage && ((VolatileImage)image).contentsLost() && ++attempts < 3);
    }

    protected abstract void paintToImage(Component var1, Image var2, Graphics var3, int var4, int var5, Object[] var6);

    protected void paintImage(Component c, Graphics g, int x, int y, int w, int h, Image image, Object[] args) {
        g.drawImage(image, x, y, null);
    }

    protected Image createImage(Component c, int w, int h, GraphicsConfiguration config, Object[] args) {
        if (config == null) {
            return new BufferedImage(w, h, 1);
        }
        return config.createCompatibleVolatileImage(w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush() {
        Class<CachedPainter> clazz = CachedPainter.class;
        synchronized (CachedPainter.class) {
            CachedPainter.getCache(this.getClass()).flush();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private GraphicsConfiguration getGraphicsConfiguration(Component c) {
        if (c == null) {
            return null;
        }
        return c.getGraphicsConfiguration();
    }
}

