/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Set;
import java.util.spi.LocaleNameProvider;
import sun.util.locale.provider.AvailableLanguageTags;
import sun.util.locale.provider.LocaleProviderAdapter;

public class LocaleNameProviderImpl
extends LocaleNameProvider
implements AvailableLanguageTags {
    private final LocaleProviderAdapter.Type type;
    private final Set<String> langtags;

    public LocaleNameProviderImpl(LocaleProviderAdapter.Type type, Set<String> langtags) {
        this.type = type;
        this.langtags = langtags;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return LocaleProviderAdapter.toLocaleArray(this.langtags);
    }

    @Override
    public boolean isSupportedLocale(Locale locale) {
        return LocaleProviderAdapter.isSupportedLocale(locale, this.type, this.langtags);
    }

    @Override
    public String getDisplayLanguage(String lang, Locale locale) {
        return this.getDisplayString(lang, locale);
    }

    @Override
    public String getDisplayScript(String scriptCode, Locale locale) {
        return this.getDisplayString(scriptCode, locale);
    }

    @Override
    public String getDisplayCountry(String ctry, Locale locale) {
        return this.getDisplayString(ctry, locale);
    }

    @Override
    public String getDisplayVariant(String vrnt, Locale locale) {
        return this.getDisplayString("%%" + vrnt, locale);
    }

    private String getDisplayString(String key, Locale locale) {
        if (key == null || locale == null) {
            throw new NullPointerException();
        }
        return LocaleProviderAdapter.forType(this.type).getLocaleResources(locale).getLocaleName(key);
    }

    @Override
    public Set<String> getAvailableLanguageTags() {
        return this.langtags;
    }
}

