/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import sun.util.locale.provider.JRELocaleProviderAdapter;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.resources.OpenListResourceBundle;
import sun.util.resources.ParallelListResourceBundle;
import sun.util.resources.TimeZoneNamesBundle;

public class LocaleData {
    private final LocaleProviderAdapter.Type type;

    public LocaleData(LocaleProviderAdapter.Type type) {
        this.type = type;
    }

    public ResourceBundle getCalendarData(Locale locale) {
        return LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".CalendarData", locale);
    }

    public OpenListResourceBundle getCurrencyNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".CurrencyNames", locale);
    }

    public OpenListResourceBundle getLocaleNames(Locale locale) {
        return (OpenListResourceBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".LocaleNames", locale);
    }

    public TimeZoneNamesBundle getTimeZoneNames(Locale locale) {
        return (TimeZoneNamesBundle)LocaleData.getBundle(this.type.getUtilResourcesPackage() + ".TimeZoneNames", locale);
    }

    public ResourceBundle getBreakIteratorInfo(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".BreakIteratorInfo", locale);
    }

    public ResourceBundle getCollationData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".CollationData", locale);
    }

    public ResourceBundle getDateFormatData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".FormatData", locale);
    }

    public void setSupplementary(ParallelListResourceBundle formatData) {
        if (!formatData.areParallelContentsComplete()) {
            String suppName = this.type.getTextResourcesPackage() + ".JavaTimeSupplementary";
            this.setSupplementary(suppName, formatData);
        }
    }

    private boolean setSupplementary(String suppName, ParallelListResourceBundle formatData) {
        ParallelListResourceBundle parent = (ParallelListResourceBundle)formatData.getParent();
        boolean resetKeySet = false;
        if (parent != null) {
            resetKeySet = this.setSupplementary(suppName, parent);
        }
        OpenListResourceBundle supp = LocaleData.getSupplementary(suppName, formatData.getLocale());
        formatData.setParallelContents(supp);
        if (resetKeySet |= supp != null) {
            formatData.resetKeySet();
        }
        return resetKeySet;
    }

    public ResourceBundle getNumberFormatData(Locale locale) {
        return LocaleData.getBundle(this.type.getTextResourcesPackage() + ".FormatData", locale);
    }

    public static ResourceBundle getBundle(final String baseName, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                return ResourceBundle.getBundle(baseName, locale, LocaleDataResourceBundleControl.INSTANCE);
            }
        });
    }

    private static OpenListResourceBundle getSupplementary(final String baseName, final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<OpenListResourceBundle>(){

            @Override
            public OpenListResourceBundle run() {
                OpenListResourceBundle rb = null;
                try {
                    rb = (OpenListResourceBundle)ResourceBundle.getBundle(baseName, locale, SupplementaryResourceBundleControl.INSTANCE);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                return rb;
            }
        });
    }

    private static class SupplementaryResourceBundleControl
    extends LocaleDataResourceBundleControl {
        private static final SupplementaryResourceBundleControl INSTANCE = new SupplementaryResourceBundleControl();

        private SupplementaryResourceBundleControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            return Arrays.asList(locale);
        }

        @Override
        public long getTimeToLive(String baseName, Locale locale) {
            assert (baseName.contains("JavaTimeSupplementary"));
            return -1L;
        }
    }

    private static class LocaleDataResourceBundleControl
    extends ResourceBundle.Control {
        private static final LocaleDataResourceBundleControl INSTANCE = new LocaleDataResourceBundleControl();
        private static final String DOTCLDR = ".cldr";

        private LocaleDataResourceBundleControl() {
        }

        @Override
        public List<Locale> getCandidateLocales(String baseName, Locale locale) {
            List<Locale> candidates = super.getCandidateLocales(baseName, locale);
            int lastDot = baseName.lastIndexOf(46);
            String category = lastDot >= 0 ? baseName.substring(lastDot + 1) : baseName;
            LocaleProviderAdapter.Type type = baseName.contains(DOTCLDR) ? LocaleProviderAdapter.Type.CLDR : LocaleProviderAdapter.Type.JRE;
            LocaleProviderAdapter adapter = LocaleProviderAdapter.forType(type);
            Set<String> langtags = ((JRELocaleProviderAdapter)adapter).getLanguageTagSet(category);
            if (!langtags.isEmpty()) {
                Iterator<Locale> itr = candidates.iterator();
                while (itr.hasNext()) {
                    if (LocaleProviderAdapter.isSupportedLocale(itr.next(), type, langtags)) continue;
                    itr.remove();
                }
            }
            if (locale.getLanguage() != "en" && type == LocaleProviderAdapter.Type.CLDR && category.equals("TimeZoneNames")) {
                candidates.add(candidates.size() - 1, Locale.ENGLISH);
            }
            return candidates;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public String toBundleName(String baseName, Locale locale) {
            String newBaseName = baseName;
            String lang = locale.getLanguage();
            if (lang.length() > 0 && (baseName.startsWith(LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage()) || baseName.startsWith(LocaleProviderAdapter.Type.JRE.getTextResourcesPackage()))) {
                assert (LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage().length() == LocaleProviderAdapter.Type.JRE.getTextResourcesPackage().length());
                int index = LocaleProviderAdapter.Type.JRE.getUtilResourcesPackage().length();
                if (baseName.indexOf(DOTCLDR, index) > 0) {
                    index += DOTCLDR.length();
                }
                newBaseName = baseName.substring(0, index + 1) + lang + baseName.substring(index);
            }
            return super.toBundleName(newBaseName, locale);
        }
    }
}

