/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import jdk.jfr.AnnotationElement;
import jdk.jfr.Event;
import jdk.jfr.EventType;
import jdk.jfr.Registered;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.EventClassBuilder;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

public final class EventFactory {
    private static final long REGISTERED_ID = Type.getTypeId(Registered.class);
    private final Class<? extends Event> eventClass;
    private final MethodHandle constructorHandle;
    private final List<AnnotationElement> sanitizedAnnotation;
    private final List<ValueDescriptor> sanitizedFields;

    private EventFactory(Class<? extends Event> eventClass, List<AnnotationElement> sanitizedAnnotation, List<ValueDescriptor> sanitizedFields) throws IllegalAccessException, NoSuchMethodException, SecurityException {
        this.constructorHandle = MethodHandles.lookup().unreflectConstructor(eventClass.getConstructor(new Class[0]));
        this.eventClass = eventClass;
        this.sanitizedAnnotation = sanitizedAnnotation;
        this.sanitizedFields = sanitizedFields;
    }

    public static EventFactory create(List<AnnotationElement> annotationElements, List<ValueDescriptor> fields) {
        Objects.requireNonNull(fields);
        Objects.requireNonNull(annotationElements);
        JVMSupport.ensureWithInternalError();
        Utils.checkRegisterPermission();
        List<AnnotationElement> sanitizedAnnotation = Utils.sanitizeNullFreeList(annotationElements, AnnotationElement.class);
        List<ValueDescriptor> sanitizedFields = Utils.sanitizeNullFreeList(fields, ValueDescriptor.class);
        HashSet<Object> nameSet = new HashSet<Object>();
        for (ValueDescriptor v : sanitizedFields) {
            String name = v.getName();
            if (v.isArray()) {
                throw new IllegalArgumentException("Array types are not allowed for fields");
            }
            if (!Type.isValidJavaFieldType(v.getTypeName())) {
                throw new IllegalArgumentException(v.getTypeName() + " is not a valid type for an event field");
            }
            if (!Type.isValidJavaIdentifier(v.getName())) {
                throw new IllegalArgumentException((String)name + " is not a valid name for an event field");
            }
            if (nameSet.contains(name)) {
                throw new IllegalArgumentException("Name of fields must be unique. Found two instances of " + (String)name);
            }
            nameSet.add(name);
        }
        boolean needRegister = true;
        ArrayList<AnnotationElement> bootAnnotations = new ArrayList<AnnotationElement>();
        for (AnnotationElement ae : sanitizedAnnotation) {
            long id = ae.getTypeId();
            if (!ae.isInBoot()) continue;
            if (id == REGISTERED_ID) {
                if (!Boolean.FALSE.equals(ae.getValue("value"))) continue;
                needRegister = false;
                continue;
            }
            bootAnnotations.add(ae);
        }
        bootAnnotations.add(new AnnotationElement(Registered.class, false));
        EventClassBuilder ecb = new EventClassBuilder(bootAnnotations, sanitizedFields);
        Class<? extends Event> eventClass = ecb.build();
        if (needRegister) {
            MetadataRepository.getInstance().register(eventClass, sanitizedAnnotation, sanitizedFields);
        }
        try {
            return new EventFactory(eventClass, sanitizedAnnotation, sanitizedFields);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError("Could not accees constructor of generated event handler, " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError("Could not find constructor in generated event handler, " + e.getMessage());
        }
    }

    public Event newEvent() {
        try {
            return this.constructorHandle.invoke();
        }
        catch (Throwable e) {
            throw new InstantiationError("Could not instantaite dynamically generated event class " + this.eventClass.getName() + ". " + e.getMessage());
        }
    }

    public EventType getEventType() {
        return EventType.getEventType(this.eventClass);
    }

    public void register() {
        MetadataRepository.getInstance().register(this.eventClass, this.sanitizedAnnotation, this.sanitizedFields);
    }

    public void unregister() {
        MetadataRepository.getInstance().unregister(this.eventClass);
    }
}

