/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.dcmd;

import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.Options;
import jdk.jfr.internal.Repository;
import jdk.jfr.internal.SecuritySupport;
import jdk.jfr.internal.dcmd.AbstractDCmd;
import jdk.jfr.internal.dcmd.DCmdException;

final class DCmdConfigure
extends AbstractDCmd {
    DCmdConfigure() {
    }

    public String execute(String repositoryPath, String dumpPath, Integer stackDepth, Long globalBufferCount, Long globalBufferSize, Long threadBufferSize, Long memorySize, Long maxChunkSize, Boolean sampleThreads) throws DCmdException {
        if (Logger.shouldLog(LogTag.JFR_DCMD, LogLevel.DEBUG)) {
            Logger.log(LogTag.JFR_DCMD, LogLevel.DEBUG, "Executing DCmdConfigure: repositorypath=" + repositoryPath + ", dumppath=" + dumpPath + ", stackdepth=" + stackDepth + ", globalbuffercount=" + globalBufferCount + ", globalbuffersize=" + globalBufferSize + ", thread_buffer_size" + threadBufferSize + ", memorysize" + memorySize + ", maxchunksize=" + maxChunkSize + ", samplethreads" + sampleThreads);
        }
        boolean updated = false;
        if (repositoryPath != null) {
            try {
                SecuritySupport.SafePath s = new SecuritySupport.SafePath(repositoryPath);
                Repository.getRepository().setBasePath(s);
                Logger.log(LogTag.JFR, LogLevel.INFO, "Base repository path set to " + repositoryPath);
            }
            catch (Exception e) {
                throw new DCmdException("Could not use " + repositoryPath + " as repository. " + e.getMessage(), new Object[]{e});
            }
            this.printRepositoryPath();
            updated = true;
        }
        if (dumpPath != null) {
            Options.setDumpPath(new SecuritySupport.SafePath(dumpPath));
            Logger.log(LogTag.JFR, LogLevel.INFO, "Emergency dump path set to " + dumpPath);
            this.printDumpPath();
            updated = true;
        }
        if (stackDepth != null) {
            Options.setStackDepth(stackDepth);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Stack depth set to " + stackDepth);
            this.printStackDepth();
            updated = true;
        }
        if (globalBufferCount != null) {
            Options.setGlobalBufferCount(globalBufferCount);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer count set to " + globalBufferCount);
            this.printGlobalBufferCount();
            updated = true;
        }
        if (globalBufferSize != null) {
            Options.setGlobalBufferSize(globalBufferSize);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Global buffer size set to " + globalBufferSize);
            this.printGlobalBufferSize();
            updated = true;
        }
        if (threadBufferSize != null) {
            Options.setThreadBufferSize(threadBufferSize);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Thread buffer size set to " + threadBufferSize);
            this.printThreadBufferSize();
            updated = true;
        }
        if (memorySize != null) {
            Options.setMemorySize(memorySize);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Memory size set to " + memorySize);
            this.printMemorySize();
            updated = true;
        }
        if (maxChunkSize != null) {
            Options.setMaxChunkSize(maxChunkSize);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Max chunk size set to " + maxChunkSize);
            this.printMaxChunkSize();
            updated = true;
        }
        if (sampleThreads != null) {
            Options.setSampleThreads(sampleThreads);
            Logger.log(LogTag.JFR, LogLevel.INFO, "Sample threads set to " + sampleThreads);
            this.printSampleThreads();
            updated = true;
        }
        if (!updated) {
            this.println("Current configuration:", new Object[0]);
            this.println();
            this.printRepositoryPath();
            this.printStackDepth();
            this.printGlobalBufferCount();
            this.printGlobalBufferSize();
            this.printThreadBufferSize();
            this.printMemorySize();
            this.printMaxChunkSize();
            this.printSampleThreads();
        }
        return this.getResult();
    }

    private void printRepositoryPath() {
        this.print("Repository path: ");
        this.printPath(Repository.getRepository().getRepositoryPath());
        this.println();
    }

    private void printDumpPath() {
        this.print("Dump path: ");
        this.printPath(Options.getDumpPath());
        this.println();
    }

    private void printSampleThreads() {
        this.println("Sample threads: " + Options.getSampleThreads(), new Object[0]);
    }

    private void printStackDepth() {
        this.println("Stack depth: " + Options.getStackDepth(), new Object[0]);
    }

    private void printGlobalBufferCount() {
        this.println("Global buffer count: " + Options.getGlobalBufferCount(), new Object[0]);
    }

    private void printGlobalBufferSize() {
        this.print("Global buffer size: ");
        this.printBytes(Options.getGlobalBufferSize());
        this.println();
    }

    private void printThreadBufferSize() {
        this.print("Thread buffer size: ");
        this.printBytes(Options.getThreadBufferSize());
        this.println();
    }

    private void printMemorySize() {
        this.print("Memory size: ");
        this.printBytes(Options.getMemorySize());
        this.println();
    }

    private void printMaxChunkSize() {
        this.print("Max chunk size: ");
        this.printBytes(Options.getMaxChunkSize());
        this.println();
    }
}

