/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="java.io.FileOutputStream")
final class FileOutputStreamInstrumentor {
    private String path;

    private FileOutputStreamInstrumentor() {
    }

    @JIInstrumentationMethod
    public void write(int b) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b);
            return;
        }
        try {
            event.begin();
            this.write(b);
            event.bytesWritten = 1L;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }

    @JIInstrumentationMethod
    public void write(byte[] b) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b);
            return;
        }
        try {
            event.begin();
            this.write(b);
            event.bytesWritten = b.length;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public void write(byte[] b, int off, int len) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.write(b, off, len);
            return;
        }
        try {
            event.begin();
            this.write(b, off, len);
            event.bytesWritten = len;
        }
        finally {
            event.path = this.path;
            event.commit();
            event.reset();
        }
    }
}

