/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.net.InetAddress;
import jdk.jfr.events.SocketWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;
import jdk.jfr.internal.instrument.JITypeMapping;

@JIInstrumentationTarget(value="java.net.SocketOutputStream")
@JITypeMapping(from="jdk.jfr.internal.instrument.SocketOutputStreamInstrumentor$AbstractPlainSocketImpl", to="java.net.AbstractPlainSocketImpl")
final class SocketOutputStreamInstrumentor {
    private AbstractPlainSocketImpl impl = null;

    private SocketOutputStreamInstrumentor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    private void socketWrite(byte[] b, int off, int len) throws IOException {
        SocketWriteEvent event = SocketWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.socketWrite(b, off, len);
            return;
        }
        int bytesWritten = 0;
        try {
            event.begin();
            this.socketWrite(b, off, len);
            bytesWritten = len;
        }
        catch (Throwable throwable) {
            event.end();
            if (event.shouldCommit()) {
                String hostString = this.impl.address.toString();
                int delimiterIndex = hostString.lastIndexOf(47);
                event.host = hostString.substring(0, delimiterIndex);
                event.address = hostString.substring(delimiterIndex + 1);
                event.port = this.impl.port;
                event.bytesWritten = bytesWritten < 0 ? 0L : (long)bytesWritten;
                event.commit();
                event.reset();
            }
            throw throwable;
        }
        event.end();
        if (event.shouldCommit()) {
            String hostString = this.impl.address.toString();
            int delimiterIndex = hostString.lastIndexOf(47);
            event.host = hostString.substring(0, delimiterIndex);
            event.address = hostString.substring(delimiterIndex + 1);
            event.port = this.impl.port;
            event.bytesWritten = bytesWritten < 0 ? 0L : (long)bytesWritten;
            event.commit();
            event.reset();
        }
    }

    void silenceFindBugsUnwrittenField(InetAddress dummy) {
        this.impl.address = dummy;
    }

    static class AbstractPlainSocketImpl {
        InetAddress address;
        int port;

        AbstractPlainSocketImpl() {
        }
    }
}

