/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.Timespan;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Threshold")
@Name(value="jdk.settings.Threshold")
@Description(value="Record event with duration above or equal to threshold")
@Timespan
public final class ThresholdSetting
extends Control {
    private static final long typeId = Type.getTypeId(ThresholdSetting.class);
    private String value = "0 ns";
    private final PlatformEventType eventType;

    public ThresholdSetting(PlatformEventType eventType, String defaultValue) {
        super(defaultValue);
        this.eventType = Objects.requireNonNull(eventType);
    }

    @Override
    public String combine(Set<String> values) {
        Long min = null;
        String text = null;
        for (String value : values) {
            long l = Utils.parseTimespanWithInfinity(value);
            if (min == null) {
                min = l;
                text = value;
                continue;
            }
            if (l >= min) continue;
            text = value;
            min = l;
        }
        return text == null ? "0 ns" : text;
    }

    @Override
    public void setValue(String value) {
        long l = Utils.parseTimespanWithInfinity(value);
        this.value = value;
        this.eventType.setThreshold(l);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long typeId) {
        return ThresholdSetting.typeId == typeId;
    }
}

