/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.PrintWriter;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.RecordedFrame;
import jdk.jfr.consumer.RecordedObject;
import jdk.jfr.internal.tool.EventPrintWriter;

final class JSONWriter
extends EventPrintWriter {
    private boolean first = true;

    public JSONWriter(PrintWriter writer) {
        super(writer);
    }

    @Override
    protected void printBegin() {
        this.printObjectBegin();
        this.printDataStructureName("recording");
        this.printObjectBegin();
        this.printDataStructureName("events");
        this.printArrayBegin();
    }

    @Override
    protected void print(List<RecordedEvent> events) {
        for (RecordedEvent event : events) {
            this.printNewDataStructure(this.first, true, null);
            this.printEvent(event);
            this.flush(false);
            this.first = false;
        }
    }

    @Override
    protected void printEnd() {
        this.printArrayEnd();
        this.printObjectEnd();
        this.printObjectEnd();
    }

    private void printEvent(RecordedEvent event) {
        this.printObjectBegin();
        EventType type = event.getEventType();
        this.printValue(true, false, "type", type.getName());
        this.printNewDataStructure(false, false, "values");
        this.printObjectBegin();
        boolean first = true;
        for (ValueDescriptor v : event.getFields()) {
            this.printValueDescriptor(first, false, v, this.getValue(event, v));
            first = false;
        }
        this.printObjectEnd();
        this.printObjectEnd();
    }

    void printValue(boolean first, boolean arrayElement, String name, Object value) {
        this.printNewDataStructure(first, arrayElement, name);
        if (!this.printIfNull(value)) {
            if (value instanceof Boolean) {
                this.printAsString(value);
                return;
            }
            if (value instanceof Double) {
                Double dValue = (Double)value;
                if (Double.isNaN(dValue) || Double.isInfinite(dValue)) {
                    this.printNull();
                    return;
                }
                this.printAsString(value);
                return;
            }
            if (value instanceof Float) {
                Float fValue = (Float)value;
                if (Float.isNaN(fValue.floatValue()) || Float.isInfinite(fValue.floatValue())) {
                    this.printNull();
                    return;
                }
                this.printAsString(value);
                return;
            }
            if (value instanceof Number) {
                this.printAsString(value);
                return;
            }
            this.print("\"");
            this.printEscaped(String.valueOf(value));
            this.print("\"");
        }
    }

    public void printObject(RecordedObject object) {
        this.printObjectBegin();
        boolean first = true;
        for (ValueDescriptor v : object.getFields()) {
            this.printValueDescriptor(first, false, v, this.getValue(object, v));
            first = false;
        }
        this.printObjectEnd();
    }

    private void printArray(ValueDescriptor v, Object[] array) {
        this.printArrayBegin();
        boolean first = true;
        int depth = 0;
        for (Object arrayElement : array) {
            if (!(arrayElement instanceof RecordedFrame) || depth < this.getStackDepth()) {
                this.printValueDescriptor(first, true, v, arrayElement);
            }
            ++depth;
            first = false;
        }
        this.printArrayEnd();
    }

    private void printValueDescriptor(boolean first, boolean arrayElement, ValueDescriptor vd, Object value) {
        if (vd.isArray() && !arrayElement) {
            this.printNewDataStructure(first, arrayElement, vd.getName());
            if (!this.printIfNull(value)) {
                this.printArray(vd, (Object[])value);
            }
            return;
        }
        if (!vd.getFields().isEmpty()) {
            this.printNewDataStructure(first, arrayElement, vd.getName());
            if (!this.printIfNull(value)) {
                this.printObject((RecordedObject)value);
            }
            return;
        }
        this.printValue(first, arrayElement, vd.getName(), value);
    }

    private void printNewDataStructure(boolean first, boolean arrayElement, String name) {
        if (!first) {
            this.print(", ");
            if (!arrayElement) {
                this.println();
            }
        }
        if (!arrayElement) {
            this.printDataStructureName(name);
        }
    }

    private boolean printIfNull(Object value) {
        if (value == null) {
            this.printNull();
            return true;
        }
        return false;
    }

    private void printNull() {
        this.print("null");
    }

    private void printDataStructureName(String text) {
        this.printIndent();
        this.print("\"");
        this.printEscaped(text);
        this.print("\": ");
    }

    private void printObjectEnd() {
        this.retract();
        this.println();
        this.printIndent();
        this.print("}");
    }

    private void printObjectBegin() {
        this.println("{");
        this.indent();
    }

    private void printArrayEnd() {
        this.print("]");
    }

    private void printArrayBegin() {
        this.print("[");
    }

    private void printEscaped(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.printEscaped(text.charAt(i));
        }
    }

    private void printEscaped(char c) {
        if (c == '\b') {
            this.print("\\b");
            return;
        }
        if (c == '\n') {
            this.print("\\n");
            return;
        }
        if (c == '\t') {
            this.print("\\t");
            return;
        }
        if (c == '\f') {
            this.print("\\f");
            return;
        }
        if (c == '\r') {
            this.print("\\r");
            return;
        }
        if (c == '\"') {
            this.print("\\\"");
            return;
        }
        if (c == '\\') {
            this.print("\\\\");
            return;
        }
        if (c == '/') {
            this.print("\\/");
            return;
        }
        if (c > '\u007f' || c < ' ') {
            this.print("\\u");
            this.print(Integer.toHexString(65536 + c).substring(1));
            return;
        }
        this.print(c);
    }
}

