/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.SequenceInputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.spi.MidiFileWriter;

public final class StandardMidiFileWriter
extends MidiFileWriter {
    private static final int MThd_MAGIC = 1297377380;
    private static final int MTrk_MAGIC = 1297379947;
    private static final int ONE_BYTE = 1;
    private static final int TWO_BYTE = 2;
    private static final int SYSEX = 3;
    private static final int META = 4;
    private static final int ERROR = 5;
    private static final int IGNORE = 6;
    private static final int MIDI_TYPE_0 = 0;
    private static final int MIDI_TYPE_1 = 1;
    private static final int bufferSize = 16384;
    private DataOutputStream tddos;
    private static final int[] types = new int[]{0, 1};
    private static final long mask = 127L;

    @Override
    public int[] getMidiFileTypes() {
        int[] localArray = new int[types.length];
        System.arraycopy(types, 0, localArray, 0, types.length);
        return localArray;
    }

    @Override
    public int[] getMidiFileTypes(Sequence sequence) {
        Track[] tracks = sequence.getTracks();
        int[] typesArray = tracks.length == 1 ? new int[]{0, 1} : new int[]{1};
        return typesArray;
    }

    @Override
    public boolean isFileTypeSupported(int type) {
        for (int i = 0; i < types.length; ++i) {
            if (type != types[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int write(Sequence in, int type, OutputStream out) throws IOException {
        byte[] buffer = null;
        int bytesRead = 0;
        long bytesWritten = 0L;
        if (!this.isFileTypeSupported(type, in)) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        InputStream fileStream = this.getFileStream(type, in);
        if (fileStream == null) {
            throw new IllegalArgumentException("Could not write MIDI file");
        }
        buffer = new byte[16384];
        while ((bytesRead = fileStream.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
            bytesWritten += (long)bytesRead;
        }
        return (int)bytesWritten;
    }

    @Override
    public int write(Sequence in, int type, File out) throws IOException {
        FileOutputStream fos = new FileOutputStream(out);
        int bytesWritten = this.write(in, type, fos);
        fos.close();
        return bytesWritten;
    }

    private InputStream getFileStream(int type, Sequence sequence) throws IOException {
        int timeFormat;
        int i;
        Track[] tracks = sequence.getTracks();
        int bytesBuilt = 0;
        int headerLength = 14;
        int length = 0;
        PipedOutputStream hpos = null;
        DataOutputStream hdos = null;
        PipedInputStream headerStream = null;
        InputStream[] trackStreams = null;
        InputStream trackStream = null;
        SequenceInputStream fStream = null;
        if (type == 0) {
            if (tracks.length != 1) {
                return null;
            }
        } else if (type == 1) {
            if (tracks.length < 1) {
                return null;
            }
        } else if (tracks.length == 1) {
            type = 0;
        } else if (tracks.length > 1) {
            type = 1;
        } else {
            return null;
        }
        trackStreams = new InputStream[tracks.length];
        int trackCount = 0;
        for (i = 0; i < tracks.length; ++i) {
            try {
                trackStreams[trackCount] = this.writeTrack(tracks[i], type);
                ++trackCount;
                continue;
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
        if (trackCount == 1) {
            trackStream = trackStreams[0];
        } else if (trackCount > 1) {
            trackStream = trackStreams[0];
            for (i = 1; i < tracks.length; ++i) {
                if (trackStreams[i] == null) continue;
                trackStream = new SequenceInputStream(trackStream, trackStreams[i]);
            }
        } else {
            throw new IllegalArgumentException("invalid MIDI data in sequence");
        }
        hpos = new PipedOutputStream();
        hdos = new DataOutputStream(hpos);
        headerStream = new PipedInputStream(hpos);
        hdos.writeInt(1297377380);
        hdos.writeInt(headerLength - 8);
        if (type == 0) {
            hdos.writeShort(0);
        } else {
            hdos.writeShort(1);
        }
        hdos.writeShort((short)trackCount);
        float divtype = sequence.getDivisionType();
        if (divtype == 0.0f) {
            timeFormat = sequence.getResolution();
        } else if (divtype == 24.0f) {
            timeFormat = -6144;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 25.0f) {
            timeFormat = -6400;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 29.97f) {
            timeFormat = -7424;
            timeFormat += sequence.getResolution() & 0xFF;
        } else if (divtype == 30.0f) {
            timeFormat = -7680;
            timeFormat += sequence.getResolution() & 0xFF;
        } else {
            return null;
        }
        hdos.writeShort(timeFormat);
        fStream = new SequenceInputStream(headerStream, trackStream);
        hdos.close();
        length = bytesBuilt + headerLength;
        return fStream;
    }

    private int getType(int byteValue) {
        if ((byteValue & 0xF0) == 240) {
            switch (byteValue) {
                case 240: 
                case 247: {
                    return 3;
                }
                case 255: {
                    return 4;
                }
            }
            return 6;
        }
        switch (byteValue & 0xF0) {
            case 128: 
            case 144: 
            case 160: 
            case 176: 
            case 224: {
                return 2;
            }
            case 192: 
            case 208: {
                return 1;
            }
        }
        return 5;
    }

    private int writeVarInt(long value) throws IOException {
        int shift;
        int len = 1;
        for (shift = 63; shift > 0 && (value & 127L << shift) == 0L; shift -= 7) {
        }
        while (shift > 0) {
            this.tddos.writeByte((int)((value & 127L << shift) >> shift | 0x80L));
            shift -= 7;
            ++len;
        }
        this.tddos.writeByte((int)(value & 0x7FL));
        return len;
    }

    private InputStream writeTrack(Track track, int type) throws IOException, InvalidMidiDataException {
        int bytesWritten = 0;
        boolean lastBytesWritten = false;
        int size = track.size();
        PipedOutputStream thpos = new PipedOutputStream();
        DataOutputStream thdos = new DataOutputStream(thpos);
        PipedInputStream thpis = new PipedInputStream(thpos);
        ByteArrayOutputStream tdbos = new ByteArrayOutputStream();
        this.tddos = new DataOutputStream(tdbos);
        ByteArrayInputStream tdbis = null;
        SequenceInputStream fStream = null;
        long currentTick = 0L;
        long deltaTick = 0L;
        long eventTick = 0L;
        int runningStatus = -1;
        block8: for (int i = 0; i < size; ++i) {
            MidiEvent event = track.get(i);
            byte[] data = null;
            ShortMessage shortMessage = null;
            MetaMessage metaMessage = null;
            SysexMessage sysexMessage = null;
            eventTick = event.getTick();
            deltaTick = event.getTick() - currentTick;
            currentTick = event.getTick();
            int status = event.getMessage().getStatus();
            int eventtype = this.getType(status);
            switch (eventtype) {
                case 1: {
                    shortMessage = (ShortMessage)event.getMessage();
                    int data1 = shortMessage.getData1();
                    bytesWritten += this.writeVarInt(deltaTick);
                    if (status != runningStatus) {
                        runningStatus = status;
                        this.tddos.writeByte(status);
                        ++bytesWritten;
                    }
                    this.tddos.writeByte(data1);
                    ++bytesWritten;
                    continue block8;
                }
                case 2: {
                    shortMessage = (ShortMessage)event.getMessage();
                    int data1 = shortMessage.getData1();
                    int data2 = shortMessage.getData2();
                    bytesWritten += this.writeVarInt(deltaTick);
                    if (status != runningStatus) {
                        runningStatus = status;
                        this.tddos.writeByte(status);
                        ++bytesWritten;
                    }
                    this.tddos.writeByte(data1);
                    ++bytesWritten;
                    this.tddos.writeByte(data2);
                    ++bytesWritten;
                    continue block8;
                }
                case 3: {
                    sysexMessage = (SysexMessage)event.getMessage();
                    int length = sysexMessage.getLength();
                    data = sysexMessage.getMessage();
                    bytesWritten += this.writeVarInt(deltaTick);
                    runningStatus = status;
                    this.tddos.writeByte(data[0]);
                    ++bytesWritten;
                    bytesWritten += this.writeVarInt(data.length - 1);
                    this.tddos.write(data, 1, data.length - 1);
                    bytesWritten += data.length - 1;
                    continue block8;
                }
                case 4: {
                    metaMessage = (MetaMessage)event.getMessage();
                    int length = metaMessage.getLength();
                    data = metaMessage.getMessage();
                    bytesWritten += this.writeVarInt(deltaTick);
                    runningStatus = status;
                    this.tddos.write(data, 0, data.length);
                    bytesWritten += data.length;
                    continue block8;
                }
                case 6: {
                    continue block8;
                }
                case 5: {
                    continue block8;
                }
                default: {
                    throw new InvalidMidiDataException("internal file writer error");
                }
            }
        }
        thdos.writeInt(1297379947);
        thdos.writeInt(bytesWritten);
        bytesWritten += 8;
        tdbis = new ByteArrayInputStream(tdbos.toByteArray());
        fStream = new SequenceInputStream(thpis, tdbis);
        thdos.close();
        this.tddos.close();
        return fStream;
    }
}

