/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private static final long serialVersionUID = -3975664071579892167L;
    private final String prompt;
    private String[] choices;
    private final int defaultChoice;
    private final boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String prompt, String[] choices, int defaultChoice, boolean multipleSelectionsAllowed) {
        if (prompt == null || prompt.length() == 0 || choices == null || choices.length == 0 || defaultChoice < 0 || defaultChoice >= choices.length) {
            throw new IllegalArgumentException();
        }
        this.prompt = prompt;
        this.defaultChoice = defaultChoice;
        this.multipleSelectionsAllowed = multipleSelectionsAllowed;
        this.choices = (String[])choices.clone();
        for (int i = 0; i < choices.length; ++i) {
            if (choices[i] != null && choices[i].length() != 0) continue;
            throw new IllegalArgumentException();
        }
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return (String[])this.choices.clone();
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int selection) {
        this.selections = new int[1];
        this.selections[0] = selection;
    }

    public void setSelectedIndexes(int[] selections) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException();
        }
        this.selections = selections == null ? null : (int[])selections.clone();
    }

    public int[] getSelectedIndexes() {
        return this.selections == null ? null : (int[])this.selections.clone();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.prompt == null || this.prompt.isEmpty() || this.choices == null || this.choices.length == 0 || this.defaultChoice < 0 || this.defaultChoice >= this.choices.length) {
            throw new InvalidObjectException("Missing/invalid prompt/choices");
        }
        this.choices = (String[])this.choices.clone();
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i] != null && !this.choices[i].isEmpty()) continue;
            throw new InvalidObjectException("Null/empty choices");
        }
        if (this.selections != null) {
            this.selections = (int[])this.selections.clone();
            if (!this.multipleSelectionsAllowed && this.selections.length != 1) {
                throw new InvalidObjectException("Multiple selections not allowed");
            }
        }
    }
}

