/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.OwnershipListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

final class XSelection {
    private static final Hashtable<XAtom, XSelection> table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private static long lastRequestServerTime;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private OwnershipListener ownershipListener = null;
    private final Object stateLock = new Object();

    static XSelection getSelection(XAtom atom) {
        return table.get(atom);
    }

    XSelection(XAtom atom) {
        if (atom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = atom;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean setOwner(Transferable contents, Map formatMap, long[] formats, long time) {
        long owner = XWindow.getXAWTRootWindow().getWindow();
        long selection = this.selectionAtom.getAtom();
        if (time == 0L) {
            time = XToolkit.getCurrentServerTime();
        }
        this.contents = contents;
        this.formatMap = formatMap;
        this.formats = formats;
        this.appContext = AppContext.getAppContext();
        this.ownershipTime = time;
        XToolkit.awtLock();
        try {
            XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), selection, owner, time);
            if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), selection) != owner) {
                this.reset();
                boolean bl = false;
                return bl;
            }
            this.setOwnerProp(true);
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private static void waitForSelectionNotify(WindowPropertyGetter dataGetter) throws InterruptedException {
        long startTime = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.awtLockWait(250L);
            } while (propertyGetter == dataGetter && System.currentTimeMillis() < startTime + (long)UNIXToolkit.getDatatransferTimeout());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long[] getTargets(long time) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] targets = null;
        Object object = lock;
        synchronized (object) {
            WindowPropertyGetter targetsGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = targetsGetter;
                    lastRequestServerTime = time;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), time);
                    try {
                        XSelection.waitForSelectionNotify(targetsGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException ie) {
                        long[] lArray;
                        try {
                            lArray = new long[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        targetsGetter.dispose();
                        return lArray;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                targetsGetter.dispose();
            }
        }
    }

    static long[] getFormats(WindowPropertyGetter targetsGetter) {
        int count;
        long[] formats = null;
        if (targetsGetter.isExecuted() && !targetsGetter.isDisposed() && (targetsGetter.getActualType() == 4L || targetsGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && targetsGetter.getActualFormat() == 32 && (count = targetsGetter.getNumberOfItems()) > 0) {
            long atoms = targetsGetter.getData();
            formats = new long[count];
            for (int index = 0; index < count; ++index) {
                formats[index] = Native.getLong(atoms + (long)(index * XAtom.getAtomSize()));
            }
        }
        return formats != null ? formats : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getData(long format, long time) throws IOException {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        byte[] data = null;
        Object object = lock;
        synchronized (object) {
            WindowPropertyGetter dataGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, false, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = dataGetter;
                    lastRequestServerTime = time;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), format, selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), time);
                    try {
                        XSelection.waitForSelectionNotify(dataGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException ie) {
                        byte[] byArray;
                        try {
                            byArray = new byte[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        dataGetter.dispose();
                        return byArray;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                dataGetter.dispose();
            }
        }
    }

    private void validateDataGetter(WindowPropertyGetter propertyGetter) throws IOException {
        if (propertyGetter.isDisposed()) {
            throw new IOException("Owner failed to convert data");
        }
        if (!propertyGetter.isExecuted()) {
            throw new IOException("Owner timed out");
        }
    }

    boolean isOwner() {
        return this.isOwner;
    }

    private void setOwnerProp(boolean f) {
        this.isOwner = f;
        this.fireOwnershipChanges(this.isOwner);
    }

    private void lostOwnership() {
        this.setOwnerProp(false);
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long requestor, long format, long property) {
        int dataFormat = 8;
        byte[] byteData = null;
        long nativeDataPtr = 0L;
        int count = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byteData = DataTransferer.getInstance().convertData(this, this.contents, format, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException ioe) {
            return false;
        }
        if (byteData == null) {
            return false;
        }
        count = byteData.length;
        try {
            if (count > 0) {
                if (count <= MAX_PROPERTY_SIZE) {
                    nativeDataPtr = Native.toData(byteData);
                } else {
                    new IncrementalDataProvider(requestor, property, format, 8, byteData);
                    nativeDataPtr = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(nativeDataPtr, count);
                    format = XDataTransferer.INCR_ATOM.getAtom();
                    dataFormat = 32;
                    count = 1;
                }
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, format, dataFormat, 0, nativeDataPtr, count);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            if (nativeDataPtr != 0L) {
                XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                nativeDataPtr = 0L;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSelectionRequest(XSelectionRequestEvent xsre) {
        long property = xsre.get_property();
        long requestor = xsre.get_requestor();
        long requestTime = xsre.get_time();
        long format = xsre.get_target();
        boolean conversionSucceeded = false;
        if (this.ownershipTime != 0L && (requestTime == 0L || requestTime >= this.ownershipTime)) {
            if (format == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                conversionSucceeded = this.handleMultipleRequest(requestor, property);
            } else {
                if (property == 0L) {
                    property = format;
                }
                conversionSucceeded = format == XDataTransferer.TARGETS_ATOM.getAtom() ? this.handleTargetsRequest(property, requestor) : this.convertAndStore(requestor, format, property);
            }
        }
        if (!conversionSucceeded) {
            property = 0L;
        }
        XSelectionEvent xse = new XSelectionEvent();
        try {
            xse.set_type(31);
            xse.set_send_event(true);
            xse.set_requestor(requestor);
            xse.set_selection(this.selectionAtom.getAtom());
            xse.set_target(format);
            xse.set_property(property);
            xse.set_time(requestTime);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), requestor, false, 0L, xse.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xse.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMultipleRequest(long requestor, long property) {
        boolean conversionSucceeded;
        block10: {
            if (0L == property) {
                return false;
            }
            conversionSucceeded = false;
            WindowPropertyGetter wpg = new WindowPropertyGetter(requestor, XAtom.get(property), 0L, 1000000L, false, 0L);
            try {
                wpg.execute();
                if (wpg.getActualFormat() != 32 || wpg.getNumberOfItems() % 2 != 0) break block10;
                long count = wpg.getNumberOfItems() / 2;
                long pairsPtr = wpg.getData();
                boolean writeBack = false;
                int i = 0;
                while ((long)i < count) {
                    long prop;
                    long target = Native.getLong(pairsPtr, 2 * i);
                    if (!this.convertAndStore(requestor, target, prop = Native.getLong(pairsPtr, 2 * i + 1))) {
                        Native.putLong(pairsPtr, 2 * i, 0L);
                        writeBack = true;
                    }
                    ++i;
                }
                if (writeBack) {
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, wpg.getActualType(), wpg.getActualFormat(), 0, wpg.getData(), wpg.getNumberOfItems());
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                conversionSucceeded = true;
            }
            finally {
                wpg.dispose();
            }
        }
        return conversionSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleTargetsRequest(long property, long requestor) throws IllegalStateException {
        boolean conversionSucceeded = false;
        long[] formatsLocal = this.formats;
        if (formatsLocal == null) {
            throw new IllegalStateException("Not an owner.");
        }
        long nativeDataPtr = 0L;
        try {
            int count = formatsLocal.length;
            int dataFormat = 32;
            if (count > 0) {
                nativeDataPtr = Native.allocateLongArray(count);
                Native.put(nativeDataPtr, formatsLocal);
            }
            conversionSucceeded = true;
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), requestor, property, 4L, 32, 0, nativeDataPtr, count);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            if (nativeDataPtr != 0L) {
                XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                nativeDataPtr = 0L;
            }
        }
        return conversionSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireOwnershipChanges(boolean isOwner) {
        OwnershipListener l = null;
        Object object = this.stateLock;
        synchronized (object) {
            l = this.ownershipListener;
        }
        if (null != l) {
            l.ownershipChanged(isOwner);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOwershipListener(OwnershipListener l) {
        Object object = this.stateLock;
        synchronized (object) {
            this.ownershipListener = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterOwnershipListener() {
        Object object = this.stateLock;
        synchronized (object) {
            this.ownershipListener = null;
        }
    }

    static {
        XToolkit.awtLock();
        try {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
        }
        finally {
            XToolkit.awtUnlock();
        }
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        @Override
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 28: {
                    XPropertyEvent xpe = ev.get_xproperty();
                    if (xpe.get_state() != 0 || xpe.get_atom() != selectionPropertyAtom.getAtom()) break;
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long requestor, long property, long target, int format, byte[] data) {
            if (format != 8) {
                throw new IllegalArgumentException("Unsupported format: " + format);
            }
            this.requestor = requestor;
            this.property = property;
            this.target = target;
            this.format = format;
            this.data = data;
            XWindowAttributes wattr = new XWindowAttributes();
            try {
                XToolkit.awtLock();
                try {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), requestor, wattr.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), requestor, wattr.get_your_event_mask() | 0x400000L);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                wattr.dispose();
            }
            XToolkit.addEventDispatcher(requestor, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 28: {
                    XPropertyEvent xpe = ev.get_xproperty();
                    if (xpe.get_window() != this.requestor || xpe.get_state() != 1 || xpe.get_atom() != this.property) break;
                    int count = this.data.length - this.offset;
                    long nativeDataPtr = 0L;
                    if (count > MAX_PROPERTY_SIZE) {
                        count = MAX_PROPERTY_SIZE;
                    }
                    if (count > 0) {
                        nativeDataPtr = XlibWrapper.unsafe.allocateMemory(count);
                        for (int i = 0; i < count; ++i) {
                            Native.putByte(nativeDataPtr + (long)i, this.data[this.offset + i]);
                        }
                    } else {
                        assert (count == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, nativeDataPtr, count);
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    if (nativeDataPtr != 0L) {
                        XlibWrapper.unsafe.freeMemory(nativeDataPtr);
                        nativeDataPtr = 0L;
                    }
                    this.offset += count;
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchEvent(XEvent ev) {
            switch (ev.get_type()) {
                case 31: {
                    XToolkit.awtLock();
                    try {
                        XSelectionEvent xse = ev.get_xselection();
                        if (propertyGetter != null && xse.get_time() == lastRequestServerTime) {
                            if (xse.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xse.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                case 30: {
                    XSelectionRequestEvent xsre = ev.get_xselectionrequest();
                    long atom = xsre.get_selection();
                    XSelection selection = XSelection.getSelection(XAtom.get(atom));
                    if (selection == null) break;
                    selection.handleSelectionRequest(xsre);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xsce = ev.get_xselectionclear();
                    long atom = xsce.get_selection();
                    XSelection selection = XSelection.getSelection(XAtom.get(atom));
                    if (selection != null) {
                        selection.lostOwnership();
                    }
                    XToolkit.awtLock();
                    try {
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }
}

