/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Canvas;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.peer.TrayIconPeer;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.AWTAccessor;
import sun.awt.SunToolkit;
import sun.awt.X11.InfoWindow;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XEmbeddedFrame;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSystemTrayPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWM;
import sun.awt.X11.XlibWrapper;
import sun.util.logging.PlatformLogger;

public class XTrayIconPeer
implements TrayIconPeer,
InfoWindow.Balloon.LiveArguments,
InfoWindow.Tooltip.LiveArguments {
    private static final PlatformLogger ctrLog = PlatformLogger.getLogger("sun.awt.X11.XTrayIconPeer.centering");
    TrayIcon target;
    TrayIconEventProxy eventProxy;
    XTrayIconEmbeddedFrame eframe;
    TrayIconCanvas canvas;
    InfoWindow.Balloon balloon;
    InfoWindow.Tooltip tooltip;
    PopupMenu popup;
    String tooltipString;
    boolean isTrayIconDisplayed;
    long eframeParentID;
    final XEventDispatcher parentXED;
    final XEventDispatcher eframeXED;
    static final XEventDispatcher dummyXED = new XEventDispatcher(){

        @Override
        public void dispatchEvent(XEvent ev) {
        }
    };
    volatile boolean isDisposed;
    boolean isParentWindowLocated;
    int old_x;
    int old_y;
    int ex_width;
    int ex_height;
    static final int TRAY_ICON_WIDTH = 24;
    static final int TRAY_ICON_HEIGHT = 24;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XTrayIconPeer(TrayIcon target) throws AWTException {
        this.target = target;
        this.eventProxy = new TrayIconEventProxy(this);
        this.canvas = new TrayIconCanvas(target, 24, 24);
        this.eframe = new XTrayIconEmbeddedFrame();
        this.eframe.setSize(24, 24);
        this.eframe.add(this.canvas);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                XTrayIconPeer.this.eframe.setModalExclusionType(Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
                return null;
            }
        });
        this.parentXED = XWM.getWMID() != 11 ? dummyXED : new XEventDispatcher(){

            @Override
            public void dispatchEvent(XEvent ev) {
                if (XTrayIconPeer.this.isDisposed() || ev.get_type() != 22) {
                    return;
                }
                XConfigureEvent ce = ev.get_xconfigure();
                if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                    ctrLog.fine("ConfigureNotify on parent of {0}: {1}x{2}+{3}+{4} (old: {5}+{6})", XTrayIconPeer.this, ce.get_width(), ce.get_height(), ce.get_x(), ce.get_y(), XTrayIconPeer.this.old_x, XTrayIconPeer.this.old_y);
                }
                if (ce.get_height() != 24 && ce.get_width() != 24) {
                    if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                        ctrLog.fine("ConfigureNotify on parent of {0}. Skipping as intermediate resizing.", XTrayIconPeer.this);
                    }
                    return;
                }
                if (ce.get_height() > 24) {
                    if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                        ctrLog.fine("ConfigureNotify on parent of {0}. Centering by \"Y\".", XTrayIconPeer.this);
                    }
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x(), ce.get_y() + ce.get_height() / 2 - 12, 24, 24);
                    XTrayIconPeer.this.ex_height = ce.get_height();
                    XTrayIconPeer.this.ex_width = 0;
                } else if (ce.get_width() > 24) {
                    if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                        ctrLog.fine("ConfigureNotify on parent of {0}. Centering by \"X\".", XTrayIconPeer.this);
                    }
                    XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x() + ce.get_width() / 2 - 12, ce.get_y(), 24, 24);
                    XTrayIconPeer.this.ex_width = ce.get_width();
                    XTrayIconPeer.this.ex_height = 0;
                } else if (XTrayIconPeer.this.isParentWindowLocated && ce.get_x() != XTrayIconPeer.this.old_x && ce.get_y() != XTrayIconPeer.this.old_y) {
                    if (XTrayIconPeer.this.ex_height != 0) {
                        if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                            ctrLog.fine("ConfigureNotify on parent of {0}. Move detected. Centering by \"Y\".", XTrayIconPeer.this);
                        }
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x(), ce.get_y() + XTrayIconPeer.this.ex_height / 2 - 12);
                    } else if (XTrayIconPeer.this.ex_width != 0) {
                        if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                            ctrLog.fine("ConfigureNotify on parent of {0}. Move detected. Centering by \"X\".", XTrayIconPeer.this);
                        }
                        XlibWrapper.XMoveWindow(XToolkit.getDisplay(), XTrayIconPeer.this.eframeParentID, ce.get_x() + XTrayIconPeer.this.ex_width / 2 - 12, ce.get_y());
                    } else if (ctrLog.isLoggable(PlatformLogger.Level.FINE)) {
                        ctrLog.fine("ConfigureNotify on parent of {0}. Move detected. Skipping.", XTrayIconPeer.this);
                    }
                }
                XTrayIconPeer.this.old_x = ce.get_x();
                XTrayIconPeer.this.old_y = ce.get_y();
                XTrayIconPeer.this.isParentWindowLocated = true;
            }
        };
        this.eframeXED = new XEventDispatcher(){
            XTrayIconPeer xtiPeer;
            {
                this.xtiPeer = XTrayIconPeer.this;
            }

            @Override
            public void dispatchEvent(XEvent ev) {
                if (XTrayIconPeer.this.isDisposed() || ev.get_type() != 21) {
                    return;
                }
                XReparentEvent re = ev.get_xreparent();
                XTrayIconPeer.this.eframeParentID = re.get_parent();
                if (XTrayIconPeer.this.eframeParentID == XToolkit.getDefaultRootWindow()) {
                    if (XTrayIconPeer.this.isTrayIconDisplayed) {
                        SunToolkit.executeOnEventHandlerThread(this.xtiPeer.target, new Runnable(){

                            @Override
                            public void run() {
                                SystemTray.getSystemTray().remove(xtiPeer.target);
                            }
                        });
                    }
                    return;
                }
                if (!XTrayIconPeer.this.isTrayIconDisplayed) {
                    XTrayIconPeer.this.addXED(XTrayIconPeer.this.eframeParentID, XTrayIconPeer.this.parentXED, 131072L);
                    XTrayIconPeer.this.isTrayIconDisplayed = true;
                    XToolkit.awtLockNotifyAll();
                }
            }
        };
        this.addXED(this.getWindow(), this.eframeXED, 131072L);
        XSystemTrayPeer.getPeerInstance().addTrayIcon(this);
        long start = System.currentTimeMillis();
        long PERIOD = XToolkit.getTrayIconDisplayTimeout();
        XToolkit.awtLock();
        try {
            while (!this.isTrayIconDisplayed) {
                try {
                    XToolkit.awtLockWait(PERIOD);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (System.currentTimeMillis() - start <= PERIOD) continue;
                break;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
        if (!this.isTrayIconDisplayed || this.eframeParentID == 0L || this.eframeParentID == XToolkit.getDefaultRootWindow()) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        this.eframe.setVisible(true);
        this.updateImage();
        this.balloon = new InfoWindow.Balloon(this.eframe, target, this);
        this.tooltip = new InfoWindow.Tooltip(this.eframe, target, this);
        this.addListeners();
    }

    @Override
    public void dispose() {
        if (SunToolkit.isDispatchThreadForAppContext(this.target)) {
            this.disposeOnEDT();
        } else {
            try {
                SunToolkit.executeOnEDTAndWait(this.target, new Runnable(){

                    @Override
                    public void run() {
                        XTrayIconPeer.this.disposeOnEDT();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    private void disposeOnEDT() {
        XToolkit.awtLock();
        this.isDisposed = true;
        XToolkit.awtUnlock();
        this.removeXED(this.getWindow(), this.eframeXED);
        this.removeXED(this.eframeParentID, this.parentXED);
        this.eframe.realDispose();
        this.balloon.dispose();
        this.isTrayIconDisplayed = false;
        XToolkit.targetDisposedPeer(this.target, this);
    }

    public static void suppressWarningString(Window w) {
        AWTAccessor.getWindowAccessor().setTrayIconWindow(w, true);
    }

    @Override
    public void setToolTip(String tooltip) {
        this.tooltipString = tooltip;
    }

    @Override
    public String getTooltipString() {
        return this.tooltipString;
    }

    @Override
    public void updateImage() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                XTrayIconPeer.this.canvas.updateImage(XTrayIconPeer.this.target.getImage());
            }
        };
        if (!SunToolkit.isDispatchThreadForAppContext(this.target)) {
            SunToolkit.executeOnEventHandlerThread(this.target, r);
        } else {
            r.run();
        }
    }

    @Override
    public void displayMessage(String caption, String text, String messageType) {
        Point loc = this.getLocationOnScreen();
        Rectangle screen = this.eframe.getGraphicsConfiguration().getBounds();
        if (loc.x >= screen.x && loc.x < screen.x + screen.width && loc.y >= screen.y && loc.y < screen.y + screen.height) {
            this.balloon.display(caption, text, messageType);
        }
    }

    @Override
    public void showPopupMenu(int x, int y) {
        if (this.isDisposed()) {
            return;
        }
        assert (SunToolkit.isDispatchThreadForAppContext(this.target));
        PopupMenu newPopup = this.target.getPopupMenu();
        if (this.popup != newPopup) {
            if (this.popup != null) {
                this.eframe.remove(this.popup);
            }
            if (newPopup != null) {
                this.eframe.add(newPopup);
            }
            this.popup = newPopup;
        }
        if (this.popup != null) {
            Point loc = ((XBaseWindow)((Object)this.eframe.getPeer())).toLocal(new Point(x, y));
            this.popup.show(this.eframe, loc.x, loc.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addXED(long window, XEventDispatcher xed, long mask) {
        if (window == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), window, mask);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XToolkit.addEventDispatcher(window, xed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXED(long window, XEventDispatcher xed) {
        if (window == 0L) {
            return;
        }
        XToolkit.awtLock();
        try {
            XToolkit.removeEventDispatcher(window, xed);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private Point getLocationOnScreen() {
        return this.eframe.getLocationOnScreen();
    }

    @Override
    public Rectangle getBounds() {
        Point loc = this.getLocationOnScreen();
        return new Rectangle(loc.x, loc.y, loc.x + 24, loc.y + 24);
    }

    void addListeners() {
        this.canvas.addMouseListener(this.eventProxy);
        this.canvas.addMouseMotionListener(this.eventProxy);
    }

    long getWindow() {
        return ((XEmbeddedFramePeer)this.eframe.getPeer()).getWindow();
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public String getActionCommand() {
        return this.target.getActionCommand();
    }

    public static class IconCanvas
    extends Canvas {
        volatile Image image;
        IconObserver observer;
        int width;
        int height;
        int curW;
        int curH;

        IconCanvas(int width, int height) {
            this.width = this.curW = width;
            this.height = this.curH = height;
        }

        public void updateImage(Image image) {
            this.image = image;
            if (this.observer == null) {
                this.observer = new IconObserver();
            }
            this.repaintImage(true);
        }

        protected void repaintImage(boolean doClear) {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    if (this.isVisible()) {
                        if (doClear) {
                            this.update(g);
                        } else {
                            this.paint(g);
                        }
                    }
                }
                finally {
                    g.dispose();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics g) {
            BufferedImage bufImage;
            Graphics2D gr;
            if (g != null && this.curW > 0 && this.curH > 0 && (gr = (bufImage = new BufferedImage(this.curW, this.curH, 2)).createGraphics()) != null) {
                try {
                    gr.setColor(this.getBackground());
                    gr.fillRect(0, 0, this.curW, this.curH);
                    gr.drawImage(this.image, 0, 0, this.curW, this.curH, this.observer);
                    gr.dispose();
                    g.drawImage(bufImage, 0, 0, this.curW, this.curH, null);
                }
                finally {
                    gr.dispose();
                }
            }
        }

        class IconObserver
        implements ImageObserver {
            IconObserver() {
            }

            @Override
            public boolean imageUpdate(Image image, int flags, int x, int y, int width, int height) {
                if (image != IconCanvas.this.image || !IconCanvas.this.isVisible()) {
                    return false;
                }
                if ((flags & 0x33) != 0) {
                    SunToolkit.executeOnEventHandlerThread(IconCanvas.this, new Runnable(){

                        @Override
                        public void run() {
                            IconCanvas.this.repaintImage(false);
                        }
                    });
                }
                return (flags & 0x20) == 0;
            }
        }
    }

    static class TrayIconCanvas
    extends IconCanvas {
        TrayIcon target;
        boolean autosize;

        TrayIconCanvas(TrayIcon target, int width, int height) {
            super(width, height);
            this.target = target;
        }

        @Override
        protected void repaintImage(boolean doClear) {
            boolean old_autosize = this.autosize;
            this.autosize = this.target.isImageAutoSize();
            this.curW = this.autosize ? this.width : this.image.getWidth(this.observer);
            this.curH = this.autosize ? this.height : this.image.getHeight(this.observer);
            super.repaintImage(doClear || old_autosize != this.autosize);
        }
    }

    private static class XTrayIconEmbeddedFrame
    extends XEmbeddedFrame {
        public XTrayIconEmbeddedFrame() {
            super(XToolkit.getDefaultRootWindow(), true, true);
        }

        @Override
        public boolean isUndecorated() {
            return true;
        }

        @Override
        public boolean isResizable() {
            return false;
        }

        @Override
        public void dispose() {
        }

        public void realDispose() {
            super.dispose();
        }
    }

    static class TrayIconEventProxy
    implements MouseListener,
    MouseMotionListener {
        XTrayIconPeer xtiPeer;

        TrayIconEventProxy(XTrayIconPeer xtiPeer) {
            this.xtiPeer = xtiPeer;
        }

        public void handleEvent(MouseEvent e) {
            if (e.getID() == 506) {
                return;
            }
            if (this.xtiPeer.isDisposed()) {
                return;
            }
            Point coord = XBaseWindow.toOtherWindow(this.xtiPeer.getWindow(), XToolkit.getDefaultRootWindow(), e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                this.xtiPeer.showPopupMenu(coord.x, coord.y);
            }
            e.translatePoint(coord.x - e.getX(), coord.y - e.getY());
            e.setSource(this.xtiPeer.target);
            XToolkit.postEvent(XToolkit.targetToAppContext(e.getSource()), e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if ((e.getClickCount() > 1 || this.xtiPeer.balloon.isVisible()) && e.getButton() == 1) {
                ActionEvent aev = new ActionEvent(this.xtiPeer.target, 1001, this.xtiPeer.target.getActionCommand(), e.getWhen(), e.getModifiers());
                XToolkit.postEvent(XToolkit.targetToAppContext(aev.getSource()), aev);
            }
            if (this.xtiPeer.balloon.isVisible()) {
                this.xtiPeer.balloon.hide();
            }
            this.handleEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.xtiPeer.tooltip.enter();
            this.handleEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.xtiPeer.tooltip.exit();
            this.handleEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.handleEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.handleEvent(e);
        }
    }
}

