/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.util.Locale;
import sun.awt.SunHints;
import sun.awt.SunToolkit;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.FontUtilities;
import sun.font.PhysicalFont;
import sun.font.SunFontManager;
import sun.util.logging.PlatformLogger;

public class FontConfigManager {
    static boolean fontConfigFailed = false;
    private static final FontConfigInfo fcInfo = new FontConfigInfo();
    private static String[] fontConfigNames = new String[]{"sans:regular:roman", "sans:bold:roman", "sans:regular:italic", "sans:bold:italic", "serif:regular:roman", "serif:bold:roman", "serif:regular:italic", "serif:bold:italic", "monospace:regular:roman", "monospace:bold:roman", "monospace:regular:italic", "monospace:bold:italic"};
    private FcCompFont[] fontConfigFonts;

    public static Object getFontConfigAAHint() {
        return FontConfigManager.getFontConfigAAHint("sans");
    }

    public static Object getFontConfigAAHint(String fcFamily) {
        if (FontUtilities.isWindows) {
            return null;
        }
        int hint = FontConfigManager.getFontConfigAASettings(FontConfigManager.getFCLocaleStr(), fcFamily);
        if (hint < 0) {
            return null;
        }
        return SunHints.Value.get(2, hint);
    }

    private static String getFCLocaleStr() {
        Locale l = SunToolkit.getStartupLocale();
        String localeStr = l.getLanguage();
        String country = l.getCountry();
        if (!country.equals("")) {
            localeStr = localeStr + "-" + country;
        }
        return localeStr;
    }

    public static native int getFontConfigVersion();

    public synchronized void initFontConfigFonts(boolean includeFallbacks) {
        int i;
        if (!(this.fontConfigFonts == null || includeFallbacks && this.fontConfigFonts[0].allFonts == null)) {
            return;
        }
        if (FontUtilities.isWindows || fontConfigFailed) {
            return;
        }
        long t0 = 0L;
        if (FontUtilities.isLogging()) {
            t0 = System.nanoTime();
        }
        FcCompFont[] fontArr = new FcCompFont[fontConfigNames.length];
        for (int i2 = 0; i2 < fontArr.length; ++i2) {
            fontArr[i2] = new FcCompFont();
            fontArr[i2].fcName = fontConfigNames[i2];
            int colonPos = fontArr[i2].fcName.indexOf(58);
            fontArr[i2].fcFamily = fontArr[i2].fcName.substring(0, colonPos);
            fontArr[i2].jdkName = FontUtilities.mapFcName(fontArr[i2].fcFamily);
            fontArr[i2].style = i2 % 4;
        }
        FontConfigManager.getFontConfig(FontConfigManager.getFCLocaleStr(), fcInfo, fontArr, includeFallbacks);
        FontConfigFont anyFont = null;
        for (i = 0; i < fontArr.length; ++i) {
            FcCompFont fci = fontArr[i];
            if (fci.firstFont == null) {
                if (FontUtilities.isLogging()) {
                    PlatformLogger logger = FontUtilities.getLogger();
                    logger.info("Fontconfig returned no font for " + fontArr[i].fcName);
                }
                fontConfigFailed = true;
                continue;
            }
            if (anyFont != null) continue;
            anyFont = fci.firstFont;
        }
        if (anyFont == null) {
            if (FontUtilities.isLogging()) {
                PlatformLogger logger = FontUtilities.getLogger();
                logger.info("Fontconfig returned no fonts at all.");
            }
            fontConfigFailed = true;
            return;
        }
        if (fontConfigFailed) {
            for (i = 0; i < fontArr.length; ++i) {
                if (fontArr[i].firstFont != null) continue;
                fontArr[i].firstFont = anyFont;
            }
        }
        this.fontConfigFonts = fontArr;
        if (FontUtilities.isLogging()) {
            PlatformLogger logger = FontUtilities.getLogger();
            long t1 = System.nanoTime();
            logger.info("Time spent accessing fontconfig=" + (t1 - t0) / 1000000L + "ms.");
            for (int i3 = 0; i3 < this.fontConfigFonts.length; ++i3) {
                FcCompFont fci = this.fontConfigFonts[i3];
                logger.info("FC font " + fci.fcName + " maps to family " + fci.firstFont.familyName + " in file " + fci.firstFont.fontFile);
                if (fci.allFonts == null) continue;
                for (int f = 0; f < fci.allFonts.length; ++f) {
                    FontConfigFont fcf = fci.allFonts[f];
                    logger.info("Family=" + fcf.familyName + " Style=" + fcf.styleStr + " Fullname=" + fcf.fullName + " File=" + fcf.fontFile);
                }
            }
        }
    }

    public PhysicalFont registerFromFcInfo(FcCompFont fcInfo) {
        SunFontManager fm = SunFontManager.getInstance();
        String fontFile = fcInfo.firstFont.fontFile;
        int offset = fontFile.length() - 4;
        if (offset <= 0) {
            return null;
        }
        String ext = fontFile.substring(offset).toLowerCase();
        boolean isTTC = ext.equals(".ttc");
        PhysicalFont physFont = fm.getRegisteredFontFile(fontFile);
        if (physFont != null) {
            if (isTTC) {
                Font2D f2d = fm.findFont2D(fcInfo.firstFont.familyName, fcInfo.style, 0);
                if (f2d instanceof PhysicalFont) {
                    return (PhysicalFont)f2d;
                }
                return null;
            }
            return physFont;
        }
        physFont = fm.findJREDeferredFont(fcInfo.firstFont.familyName, fcInfo.style);
        if (physFont == null && fm.isDeferredFont(fontFile) && (physFont = fm.initialiseDeferredFont(fcInfo.firstFont.fontFile)) != null) {
            if (isTTC) {
                Font2D f2d = fm.findFont2D(fcInfo.firstFont.familyName, fcInfo.style, 0);
                if (f2d instanceof PhysicalFont) {
                    return (PhysicalFont)f2d;
                }
                return null;
            }
            return physFont;
        }
        if (physFont == null) {
            int fontFormat = -1;
            int fontRank = 6;
            if (ext.equals(".ttf") || isTTC) {
                fontFormat = 0;
                fontRank = 3;
            } else if (ext.equals(".pfa") || ext.equals(".pfb")) {
                fontFormat = 1;
                fontRank = 4;
            }
            physFont = fm.registerFontFile(fcInfo.firstFont.fontFile, null, fontFormat, true, fontRank);
        }
        return physFont;
    }

    public CompositeFont getFontConfigFont(String name, int style) {
        Font2D f2D;
        name = name.toLowerCase();
        this.initFontConfigFonts(false);
        if (this.fontConfigFonts == null) {
            return null;
        }
        FcCompFont fcInfo = null;
        for (int i = 0; i < this.fontConfigFonts.length; ++i) {
            if (!name.equals(this.fontConfigFonts[i].fcFamily) || style != this.fontConfigFonts[i].style) continue;
            fcInfo = this.fontConfigFonts[i];
            break;
        }
        if (fcInfo == null) {
            fcInfo = this.fontConfigFonts[0];
        }
        if (FontUtilities.isLogging()) {
            FontUtilities.getLogger().info("FC name=" + name + " style=" + style + " uses " + fcInfo.firstFont.familyName + " in file: " + fcInfo.firstFont.fontFile);
        }
        if (fcInfo.compFont != null) {
            return fcInfo.compFont;
        }
        FontManager fm = FontManagerFactory.getInstance();
        CompositeFont jdkFont = (CompositeFont)fm.findFont2D(fcInfo.jdkName, style, 2);
        if (fcInfo.firstFont.familyName == null || fcInfo.firstFont.fontFile == null) {
            fcInfo.compFont = jdkFont;
            return fcInfo.compFont;
        }
        FontFamily family = FontFamily.getFamily(fcInfo.firstFont.familyName);
        PhysicalFont physFont = null;
        if (family != null && (f2D = family.getFontWithExactStyleMatch(fcInfo.style)) instanceof PhysicalFont) {
            physFont = (PhysicalFont)f2D;
        }
        if (physFont == null || !fcInfo.firstFont.fontFile.equals(physFont.platName)) {
            physFont = this.registerFromFcInfo(fcInfo);
            if (physFont == null) {
                fcInfo.compFont = jdkFont;
                return fcInfo.compFont;
            }
            family = FontFamily.getFamily(physFont.getFamilyName(null));
        }
        for (int i = 0; i < this.fontConfigFonts.length; ++i) {
            FcCompFont fc = this.fontConfigFonts[i];
            if (fc == fcInfo || !physFont.getFamilyName(null).equals(fc.firstFont.familyName) || fc.firstFont.fontFile.equals(physFont.platName) || family.getFontWithExactStyleMatch(fc.style) != null) continue;
            this.registerFromFcInfo(this.fontConfigFonts[i]);
        }
        fcInfo.compFont = new CompositeFont(physFont, jdkFont);
        return fcInfo.compFont;
    }

    public FcCompFont[] getFontConfigFonts() {
        return this.fontConfigFonts;
    }

    private static native void getFontConfig(String var0, FontConfigInfo var1, FcCompFont[] var2, boolean var3);

    void populateFontConfig(FcCompFont[] fcInfo) {
        this.fontConfigFonts = fcInfo;
    }

    FcCompFont[] loadFontConfig() {
        this.initFontConfigFonts(true);
        return this.fontConfigFonts;
    }

    FontConfigInfo getFontConfigInfo() {
        this.initFontConfigFonts(true);
        return fcInfo;
    }

    private static native int getFontConfigAASettings(String var0, String var1);

    public static class FontConfigInfo {
        public int fcVersion;
        public String[] cacheDirs = new String[4];
    }

    public static class FcCompFont {
        public String fcName;
        public String fcFamily;
        public String jdkName;
        public int style;
        public FontConfigFont firstFont;
        public FontConfigFont[] allFonts;
        public CompositeFont compFont;
    }

    public static class FontConfigFont {
        public String familyName;
        public String styleStr;
        public String fullName;
        public String fontFile;
    }
}

