/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.io.IOException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.spnego.SpNegoToken;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class NegTokenTarg
extends SpNegoToken {
    private int negResult = 0;
    private Oid supportedMech = null;
    private byte[] responseToken = null;
    private byte[] mechListMIC = null;

    NegTokenTarg(int result, Oid mech, byte[] token, byte[] mechListMIC) {
        super(1);
        this.negResult = result;
        this.supportedMech = mech;
        this.responseToken = token;
        this.mechListMIC = mechListMIC;
    }

    public NegTokenTarg(byte[] in) throws GSSException {
        super(1);
        this.parseToken(in);
    }

    @Override
    final byte[] encode() throws GSSException {
        try {
            DerOutputStream targToken = new DerOutputStream();
            DerOutputStream result = new DerOutputStream();
            result.putEnumerated(this.negResult);
            targToken.write(DerValue.createTag((byte)-128, true, (byte)0), result);
            if (this.supportedMech != null) {
                DerOutputStream mech = new DerOutputStream();
                byte[] mechType = this.supportedMech.getDER();
                mech.write(mechType);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)1), mech);
            }
            if (this.responseToken != null) {
                DerOutputStream rspToken = new DerOutputStream();
                rspToken.putOctetString(this.responseToken);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)2), rspToken);
            }
            if (this.mechListMIC != null) {
                if (DEBUG) {
                    System.out.println("SpNegoToken NegTokenTarg: sending MechListMIC");
                }
                DerOutputStream mic = new DerOutputStream();
                mic.putOctetString(this.mechListMIC);
                targToken.write(DerValue.createTag((byte)-128, true, (byte)3), mic);
            }
            DerOutputStream out = new DerOutputStream();
            out.write((byte)48, targToken);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + e.getMessage());
        }
    }

    private void parseToken(byte[] in) throws GSSException {
        try {
            DerValue der = new DerValue(in);
            if (!der.isContextSpecific((byte)1)) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the right token type");
            }
            DerValue tmp1 = der.data.getDerValue();
            if (tmp1.tag != 48) {
                throw new IOException("SPNEGO NegoTokenTarg : did not have the Sequence tag");
            }
            int lastField = -1;
            while (tmp1.data.available() > 0) {
                DerValue tmp2 = tmp1.data.getDerValue();
                if (tmp2.isContextSpecific((byte)0)) {
                    lastField = NegTokenTarg.checkNextField(lastField, 0);
                    this.negResult = tmp2.data.getEnumerated();
                    if (!DEBUG) continue;
                    System.out.println("SpNegoToken NegTokenTarg: negotiated result = " + NegTokenTarg.getNegoResultString(this.negResult));
                    continue;
                }
                if (tmp2.isContextSpecific((byte)1)) {
                    lastField = NegTokenTarg.checkNextField(lastField, 1);
                    ObjectIdentifier mech = tmp2.data.getOID();
                    this.supportedMech = new Oid(mech.toString());
                    if (!DEBUG) continue;
                    System.out.println("SpNegoToken NegTokenTarg: supported mechanism = " + this.supportedMech);
                    continue;
                }
                if (tmp2.isContextSpecific((byte)2)) {
                    lastField = NegTokenTarg.checkNextField(lastField, 2);
                    this.responseToken = tmp2.data.getOctetString();
                    continue;
                }
                if (!tmp2.isContextSpecific((byte)3)) continue;
                lastField = NegTokenTarg.checkNextField(lastField, 3);
                if (GSSUtil.useMSInterop()) continue;
                this.mechListMIC = tmp2.data.getOctetString();
                if (!DEBUG) continue;
                System.out.println("SpNegoToken NegTokenTarg: MechListMIC Token = " + NegTokenTarg.getHexBytes(this.mechListMIC));
            }
        }
        catch (IOException e) {
            throw new GSSException(10, -1, "Invalid SPNEGO NegTokenTarg token : " + e.getMessage());
        }
    }

    int getNegotiatedResult() {
        return this.negResult;
    }

    public Oid getSupportedMech() {
        return this.supportedMech;
    }

    byte[] getResponseToken() {
        return this.responseToken;
    }

    byte[] getMechListMIC() {
        return this.mechListMIC;
    }
}

