/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import jdk.jfr.Event;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.EventControl;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.MetadataRepository;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Utils;
import jdk.jfr.internal.handlers.EventHandler;

final class SettingsManager {
    private Map<String, InternalSetting> availableSettings = new LinkedHashMap<String, InternalSetting>();

    SettingsManager() {
    }

    void setSettings(List<Map<String, String>> activeSettings) {
        this.availableSettings = this.createSettingsMap(activeSettings);
        List<EventControl> eventControls = MetadataRepository.getInstance().getEventControls();
        if (!JVM.getJVM().isRecording()) {
            for (EventControl ec : eventControls) {
                ec.disable();
            }
        } else {
            if (Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO)) {
                Collections.sort(eventControls, (x, y) -> x.getEventType().getName().compareTo(y.getEventType().getName()));
            }
            for (EventControl ec : eventControls) {
                this.setEventControl(ec);
            }
        }
        if (JVM.getJVM().getAllowedToDoEventRetransforms()) {
            this.updateRetransform(JVM.getJVM().getAllEventClasses());
        }
    }

    public void updateRetransform(List<Class<? extends Event>> eventClasses) {
        ArrayList<Class<? extends Event>> classes = new ArrayList<Class<? extends Event>>();
        for (Class<? extends Event> eventClass : eventClasses) {
            PlatformEventType eventType;
            EventHandler eh = Utils.getHandler(eventClass);
            if (eh == null || !(eventType = eh.getPlatformEventType()).isMarkedForInstrumentation()) continue;
            classes.add(eventClass);
            eventType.markForInstrumentation(false);
            eventType.setInstrumented();
        }
        if (!classes.isEmpty()) {
            JVM.getJVM().retransformClasses(classes.toArray(new Class[0]));
        }
    }

    private Map<String, InternalSetting> createSettingsMap(List<Map<String, String>> activeSettings) {
        LinkedHashMap<String, InternalSetting> map = new LinkedHashMap<String, InternalSetting>(activeSettings.size());
        for (Map<String, String> rec : activeSettings) {
            for (InternalSetting internal : this.makeInternalSettings(rec)) {
                InternalSetting is = (InternalSetting)map.get(internal.getSettingsId());
                if (is == null) {
                    map.put(internal.getSettingsId(), internal);
                    continue;
                }
                is.add(internal);
            }
        }
        return map;
    }

    private Collection<InternalSetting> makeInternalSettings(Map<String, String> rec) {
        LinkedHashMap<String, InternalSetting> internals = new LinkedHashMap<String, InternalSetting>();
        for (Map.Entry<String, String> entry : rec.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            int index = key.indexOf("#");
            if (index <= 1 || index >= key.length() - 2) continue;
            String eventName = key.substring(0, index);
            eventName = Utils.upgradeLegacyJDKEvent(eventName);
            InternalSetting s = (InternalSetting)internals.get(eventName);
            String settingName = key.substring(index + 1).trim();
            if (s == null) {
                s = new InternalSetting(eventName);
                internals.put(eventName, s);
            }
            s.add(settingName, value);
        }
        for (InternalSetting s : internals.values()) {
            s.finish();
        }
        return internals.values();
    }

    void setEventControl(EventControl ec) {
        InternalSetting is = this.getInternalSetting(ec);
        Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "Applied settings for " + ec.getEventType().getLogName() + " {");
        for (Map.Entry<String, Control> entry : ec.getEntries()) {
            Set<String> values = null;
            String settingName = entry.getKey();
            if (is != null) {
                values = is.getValues(settingName);
            }
            Control control = entry.getValue();
            if (values != null) {
                control.apply(values);
                String after = control.getLastValue();
                if (!Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO) || !Utils.isSettingVisible(control, ec.getEventType().hasEventHook())) continue;
                if (values.size() > 1) {
                    StringJoiner sj = new StringJoiner(", ", "{", "}");
                    for (String s : values) {
                        sj.add("\"" + s + "\"");
                    }
                    String message = "  " + settingName + "= " + sj.toString() + " => \"" + after + "\"";
                    Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, message);
                    continue;
                }
                String message = "  " + settingName + "=\"" + control.getLastValue() + "\"";
                Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, message);
                continue;
            }
            control.setDefault();
            if (!Logger.shouldLog(LogTag.JFR_SETTING, LogLevel.INFO)) continue;
            String message = "  " + settingName + "=\"" + control.getLastValue() + "\"";
            Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, message);
        }
        ec.writeActiveSettingEvent();
        Logger.log(LogTag.JFR_SETTING, LogLevel.INFO, "}");
    }

    private InternalSetting getInternalSetting(EventControl ec) {
        String name = ec.getEventType().getName();
        InternalSetting nameBased = this.availableSettings.get(name);
        InternalSetting idBased = this.availableSettings.get(ec.getSettingsId());
        if (nameBased == null && idBased == null) {
            return null;
        }
        if (idBased == null) {
            return nameBased;
        }
        if (nameBased == null) {
            return idBased;
        }
        InternalSetting mixed = new InternalSetting(nameBased.getSettingsId());
        mixed.add(nameBased);
        mixed.add(idBased);
        return mixed;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (InternalSetting enabled : this.availableSettings.values()) {
            sb.append(enabled.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    boolean isEnabled(String eventName) {
        InternalSetting is = this.availableSettings.get(eventName);
        if (is == null) {
            return false;
        }
        return is.isEnabled();
    }

    private static class InternalSetting {
        private final String identifier;
        private Map<String, Set<String>> enabledMap = new LinkedHashMap<String, Set<String>>(5);
        private Map<String, Set<String>> allMap = new LinkedHashMap<String, Set<String>>(5);
        private boolean enabled;

        public InternalSetting(String settingsId) {
            this.identifier = settingsId;
        }

        public Set<String> getValues(String key) {
            if (this.enabled) {
                return this.enabledMap.get(key);
            }
            return this.allMap.get(key);
        }

        public void add(String attribute, String value) {
            if ("enabled".equals(attribute) && "true".equals(value)) {
                this.enabled = true;
                this.allMap = null;
            }
            this.addToMap(this.enabledMap, attribute, value);
            if (this.allMap != null) {
                this.addToMap(this.allMap, attribute, value);
            }
        }

        private void addToMap(Map<String, Set<String>> map, String attribute, String value) {
            Set<String> values = map.get(attribute);
            if (values == null) {
                values = new HashSet<String>(5);
                map.put(attribute, values);
            }
            values.add(value);
        }

        public String getSettingsId() {
            return this.identifier;
        }

        public void add(InternalSetting enabled) {
            for (Map.Entry<String, Set<String>> entry : enabled.enabledMap.entrySet()) {
                for (String value : entry.getValue()) {
                    this.add(entry.getKey(), value);
                }
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.identifier);
            sb.append(": ");
            sb.append(this.enabledMap.toString());
            return sb.toString();
        }

        public void finish() {
            if (!this.enabled) {
                HashMap<String, Set<String>> disabledMap = new HashMap<String, Set<String>>(2);
                HashSet<String> values = new HashSet<String>(2);
                values.add("false");
                disabledMap.put("enabled", values);
                this.enabledMap = disabledMap;
            }
        }
    }
}

